package com.arms.license;

import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;

public class GenerateKeyPair {
    public static void main(String[] args) throws Exception {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(2048);
        KeyPair keyPair = keyGen.generateKeyPair();

        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream("private.key"))) {
            out.writeObject(keyPair.getPrivate());
        }
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream("public.key"))) {
            out.writeObject(keyPair.getPublic());
        }

        System.out.println("✔ RSA 키 쌍 생성 완료");
    }
}
