/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.kafka.reqadd.controller;

import com.arms.api.kafka.reqadd.model.ReqAddDTO;
import com.arms.api.kafka.reqadd.model.ReqAddResponseVO;
import com.arms.api.kafka.reqadd.service.ReqAddService;
import com.arms.api.util.response.CommonResponse;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/auth-user/message/queue"})
public class UserReqAddController {
    private static final Logger log = LoggerFactory.getLogger(UserReqAddController.class);
    @Autowired(required=false)
    private ReqAddService reqAddService;

    @GetMapping(value={"/requirements"})
    public Mono<CommonResponse.ApiResult<List<ReqAddResponseVO>>> read() {
        if (this.reqAddService != null) {
            List response = this.reqAddService.read();
            return Mono.just((Object)CommonResponse.success((Object)response));
        }
        return Mono.just((Object)CommonResponse.success(Collections.emptyList()));
    }

    @PostMapping(value={"/requirements/{changeReqTableName}"})
    public Mono<CommonResponse.ApiResult<String>> create(@PathVariable String changeReqTableName, @RequestBody ReqAddDTO payload) {
        if (this.reqAddService != null) {
            this.reqAddService.create(changeReqTableName, payload);
        }
        return Mono.just((Object)CommonResponse.success((Object)"OK"));
    }

    @PutMapping(value={"/requirements/{changeReqTableName}"})
    public Mono<CommonResponse.ApiResult<String>> update(@PathVariable String changeReqTableName, @RequestBody String payload) {
        if (this.reqAddService != null) {
            this.reqAddService.update(changeReqTableName, payload);
        }
        return Mono.just((Object)CommonResponse.success((Object)"OK"));
    }

    @DeleteMapping(value={"/requirements/{changeReqTableName}"})
    public Mono<CommonResponse.ApiResult<String>> delete(@PathVariable String changeReqTableName, @RequestBody String payload) {
        if (this.reqAddService != null) {
            this.reqAddService.delete(changeReqTableName, payload);
        }
        return Mono.just((Object)CommonResponse.success((Object)"OK"));
    }
}

