package com.arms.api.mapping.service;

import com.arms.api.mapping.domain.State;
import com.arms.api.mapping.repository.StateRepository;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@AllArgsConstructor
public class StateService {

    private final StateRepository stateRepository;

    public void init(List<State> stateList){
        stateRepository.saveAll(stateList);
    }

    public void deleteState() { stateRepository.deleteAll(); }

    public State getArmsStateById(String stateId){
        return stateRepository.findById(stateId).orElseGet(()-> State.builder().build());
    }

}
