/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.admin.fluentd.service;

import com.arms.api.admin.esIndex.model.vo.IndexStatusSumVO;
import com.arms.api.admin.fluentd.service.FluentdIndexAdminService;
import com.arms.api.fluentd.entity.FluentdEntity;
import com.arms.api.util.aspect.DwrSendAlarm;
import com.arms.egovframework.javaservice.esframework.annotation.IndexStatusSnapShot;
import com.arms.egovframework.javaservice.esframework.model.vo.CatIndexVO;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class FluentdIndexAdminServiceImpl
implements FluentdIndexAdminService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FluentdIndexAdminServiceImpl.class);
    private final EsCommonRepositoryWrapper<FluentdEntity> esCommonRepositoryWrapper;

    public void delete() {
        this.esCommonRepositoryWrapper.deleteIndexWithDayRange(90);
    }

    public void delete(int day) {
        this.esCommonRepositoryWrapper.deleteIndexWithDayRange(day);
    }

    @Async
    @IndexStatusSnapShot(value="fluentd merge index job", clazz=FluentdEntity.class)
    @DwrSendAlarm(messageOnStart="Fluentd Index Merge \uc2dc\uc791", messageOnEnd="Fluentd Index Merge \uc644\ub8cc")
    public void merge() {
        this.esCommonRepositoryWrapper.mergeWithReindex(7);
    }

    @Async
    @IndexStatusSnapShot(value="fluentd merge index job", clazz=FluentdEntity.class)
    @DwrSendAlarm(messageOnStart="Fluentd Index Merge \uc2dc\uc791", messageOnEnd="Fluentd Index Merge \uc644\ub8cc")
    public void merge(int day) {
        this.esCommonRepositoryWrapper.mergeWithReindex(day);
    }

    public IndexStatusSumVO fluentDIndexSumList() {
        List catIndexVOList = this.esCommonRepositoryWrapper.catIndexVOList();
        return IndexStatusSumVO.builder().indexName(this.esCommonRepositoryWrapper.indexAliasName()).indexCount(this.esCommonRepositoryWrapper.indexAllCount()).docsCount(Long.valueOf(catIndexVOList.stream().mapToLong(CatIndexVO::getDocsCount).sum())).docDeleted(Long.valueOf(catIndexVOList.stream().mapToLong(CatIndexVO::getDocDeleted).sum())).build();
    }

    @Generated
    public FluentdIndexAdminServiceImpl(EsCommonRepositoryWrapper<FluentdEntity> esCommonRepositoryWrapper) {
        this.esCommonRepositoryWrapper = esCommonRepositoryWrapper;
    }
}

