/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.analysis.resource.controller;

import com.arms.api.analysis.resource.model.dto.ResourceRequestDTO;
import com.arms.api.analysis.resource.model.dto.ResourceWithVersionIdNamesDTO;
import com.arms.api.analysis.resource.model.vo.UniqueAssigneeIssueStatusVO;
import com.arms.api.analysis.resource.model.vo.UniqueAssigneeVO;
import com.arms.api.analysis.resource.model.vo.horizontalbar.HorizontalBarChartYAxisAndSeriesVO;
import com.arms.api.analysis.resource.model.vo.horizontalbar.ReqAndNotReqHorizontalBarChartVO;
import com.arms.api.analysis.resource.model.vo.pie.ReqAndNotReqPieChartVO;
import com.arms.api.analysis.resource.model.vo.pie.TotalIssueAndPieChartVO;
import com.arms.api.analysis.resource.model.vo.sankey.SankeyChartBaseVO;
import com.arms.api.analysis.resource.model.vo.stackedHorizontalBar.StackedHorizontalBarChartVO;
import com.arms.api.analysis.resource.model.vo.treemap.TreeMapWorkerVO;
import com.arms.api.analysis.resource.model.vo.wordcloud.WordCloudExcelVO;
import com.arms.api.analysis.resource.service.AnalysisResource;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/engine/analysis-resource"})
public class AnalysisResourceController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnalysisResourceController.class);
    private final AnalysisResource analysisResource;

    @PostMapping(value={"/issue-status-by-assignee"})
    public ResponseEntity<List<UniqueAssigneeIssueStatusVO>> issueStatusDataByAssignee(@RequestBody ResourceRequestDTO resourceDTO) {
        return ResponseEntity.ok((Object)this.analysisResource.issueStatusDataByAssignee(resourceDTO));
    }

    @PostMapping(value={"/word-cloud-data"})
    public ResponseEntity<List<WordCloudExcelVO>> wordCloudEData(@RequestBody ResourceRequestDTO resourceDTO) {
        log.info("AnalysisResourceController :: wordCloudEData");
        return ResponseEntity.ok((Object)this.analysisResource.wordCloudData(resourceDTO));
    }

    @PostMapping(value={"/issue-status-stacked-bar"})
    public ResponseEntity<StackedHorizontalBarChartVO> issueStatusStackedBarChartData(@RequestBody ResourceRequestDTO resourceDTO) {
        log.info("AnalysisResourceController :: issueStatusStackedBarChartData");
        return ResponseEntity.ok((Object)this.analysisResource.issueStatusStackedBarChartData(resourceDTO));
    }

    @PostMapping(value={"/top-contributors/pie"})
    public ResponseEntity<ReqAndNotReqPieChartVO> findPieChartData(@RequestBody ResourceRequestDTO resourceDTO) {
        log.info("AnalysisResourceController :: findPieChartData");
        return ResponseEntity.ok((Object)this.analysisResource.findPieChartData(resourceDTO));
    }

    @PostMapping(value={"/top-contributors/pie-expand"})
    public ResponseEntity<TotalIssueAndPieChartVO> findPieChartDataExpand(@RequestBody ResourceRequestDTO resourceDTO) {
        log.info("AnalysisResourceController :: findPieChartDataExpand");
        return ResponseEntity.ok((Object)this.analysisResource.findPieChartDataExpand(resourceDTO));
    }

    @PostMapping(value={"/top-contributors/horizontal-bar"})
    public ResponseEntity<List<HorizontalBarChartYAxisAndSeriesVO>> findHorizontalBarChartData(@RequestBody ResourceRequestDTO resourceDTO) {
        log.info("[ AnalysisResourceController :: findHorizontalBarChartData ] :: isReq => {}", (Object)resourceDTO.getPdServiceAndIsReq().getIsReq());
        return ResponseEntity.ok((Object)this.analysisResource.findHorizontalBarChartData(resourceDTO));
    }

    @PostMapping(value={"/top-contributors/horizontal-bar-at-once"})
    public ResponseEntity<ReqAndNotReqHorizontalBarChartVO> findHorizontalBarChartDataBySameAccounts(@RequestBody ResourceRequestDTO resourceDTO) {
        log.info("AnalysisResourceController :: findHorizontalBarChartDataBySameAccounts");
        return ResponseEntity.ok((Object)this.analysisResource.findHorizontalBarChartDataBySameAccounts(resourceDTO));
    }

    @PostMapping(value={"/version-assignee-summary"})
    public ResponseEntity<List<SankeyChartBaseVO>> findVersionAssigneeSummaryDataV3Refactored(@RequestBody ResourceRequestDTO resourceDTO) {
        log.info("AnalysisResourceController :: findVersionAssigneeSummaryDataV3Refactor");
        return ResponseEntity.ok((Object)this.analysisResource.sankeyChartBaseDataV3(resourceDTO));
    }

    @PostMapping(value={"/assignees-requirements-involvements-v2"}, name="resource-treemap-v2")
    public ResponseEntity<List<TreeMapWorkerVO>> findTreeMapChartDataV2(@RequestBody ResourceWithVersionIdNamesDTO resourceWithVersionIdNamesDTO) {
        log.info("[AnalysisResourceController :: findTreeMapChartDataV2]");
        return ResponseEntity.ok((Object)this.analysisResource.findTreeMapChartDataV2(resourceWithVersionIdNamesDTO));
    }

    @PostMapping(value={"/assignees-requirements-involvements-v3"}, name="resource-treemap-v3")
    public ResponseEntity<List<TreeMapWorkerVO>> findTreeMapChartDataV3(@RequestBody ResourceWithVersionIdNamesDTO resourceWithVersionIdNamesDTO) {
        log.info("[AnalysisResourceController :: findTreeMapChartDataV3]");
        return ResponseEntity.ok((Object)this.analysisResource.findTreeMapChartDataV3(resourceWithVersionIdNamesDTO));
    }

    @PostMapping(value={"/assignees-info"})
    public ResponseEntity<List<UniqueAssigneeVO>> findAssigneesInfo(@RequestBody ResourceRequestDTO resourceDTO) {
        log.info("AnalysisResourceController :: findAssigneesInfo");
        return ResponseEntity.ok((Object)this.analysisResource.findAssigneesInfo(resourceDTO));
    }

    @Generated
    public AnalysisResourceController(AnalysisResource analysisResource) {
        this.analysisResource = analysisResource;
    }
}

