/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.analysis.scope.service;

import com.arms.api.analysis.scope.dto.ScopeDTO;
import com.arms.api.analysis.scope.model.IssueSort;
import com.arms.api.analysis.scope.service.AnalysisScope;
import com.arms.api.analysis.scope.service.AnalysisScopeImpl;
import com.arms.api.analysis.scope.vo.AssigneeIssueCountVO;
import com.arms.api.analysis.scope.vo.CircularPackingChartVO;
import com.arms.api.analysis.scope.vo.IssueVO;
import com.arms.api.analysis.scope.vo.NetworkChartExcelDataVO;
import com.arms.api.analysis.scope.vo.PdServiceVersionsAndReqVO;
import com.arms.api.analysis.scope.vo.ReqDataTableIssuesVO;
import com.arms.api.analysis.scope.vo.TreeBarIssueVO;
import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;
import com.arms.api.util.ParseUtil;
import com.arms.api.util.model.dto.PdServiceAndIsReqDTO;
import com.arms.egovframework.javaservice.esframework.esquery.SimpleQuery;
import com.arms.egovframework.javaservice.esframework.esquery.filter.RangeQueryFilter;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SubGroupFieldDTO;
import com.arms.egovframework.javaservice.esframework.model.dto.request.AggregationRequestDTO;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentAggregations;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentBucket;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service(value="analysisScope")
public class AnalysisScopeImpl
implements AnalysisScope {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnalysisScopeImpl.class);
    private final EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper;

    public List<TreeBarIssueVO> treeBarDataV2(ScopeDTO scopeDTO) {
        List notReqIssues;
        Long pdServiceId = scopeDTO.getPdServiceAndIsReq().getPdServiceId();
        List reqIssues = this.retrieveAssignedIssuesByIsReq(scopeDTO, Boolean.valueOf(true));
        IssueClassification classification = this.classifyIssues(reqIssues, notReqIssues = this.retrieveAssignedIssuesByIsReq(scopeDTO, Boolean.valueOf(false)), pdServiceId);
        Map reqLinkIssueCountMap = this.aggregateIssueCounts(classification);
        if (reqLinkIssueCountMap.isEmpty()) {
            return Collections.emptyList();
        }
        return this.convertToTreeBarIssueVOList(reqLinkIssueCountMap, scopeDTO.getTopN());
    }

    private IssueClassification classifyIssues(List<AlmIssueEntity> reqIssues, List<AlmIssueEntity> notReqIssues, Long pdServiceId) {
        HashMap<String, AlmIssueEntity> rightReqIssues = new HashMap<String, AlmIssueEntity>();
        HashMap<String, AlmIssueEntity> rightSubTaskIssues = new HashMap<String, AlmIssueEntity>();
        HashMap<String, AlmIssueEntity> linkedIssues = new HashMap<String, AlmIssueEntity>();
        for (AlmIssueEntity issue : reqIssues) {
            if (pdServiceId.equals(issue.getPdServiceId())) {
                rightReqIssues.put(issue.getRecentId(), issue);
                continue;
            }
            linkedIssues.put(issue.getRecentId(), issue);
        }
        for (AlmIssueEntity issue : notReqIssues) {
            if (issue.getPdServiceId() == null || issue.getCReqLink() == null) {
                linkedIssues.put(issue.getRecentId(), issue);
                continue;
            }
            if (pdServiceId.equals(issue.getPdServiceId())) {
                rightSubTaskIssues.put(issue.getRecentId(), issue);
                continue;
            }
            linkedIssues.put(issue.getRecentId(), issue);
        }
        return new IssueClassification(rightReqIssues, rightSubTaskIssues, linkedIssues);
    }

    private Map<Long, Map<String, AssigneeIssueCountVO>> aggregateIssueCounts(IssueClassification classification) {
        HashMap<Long, Map<String, AssigneeIssueCountVO>> result = new HashMap<Long, Map<String, AssigneeIssueCountVO>>();
        HashMap processedIssues = new HashMap();
        for (AlmIssueEntity issue : classification.rightReqIssues.values()) {
            if (!this.tryAddIssue(processedIssues, issue.getCReqLink(), issue.getRecentId())) continue;
            this.incrementCount(result, issue.getCReqLink(), issue.getAssignee(), IssueSort.REQISSUE);
        }
        for (AlmIssueEntity issue : classification.rightSubTaskIssues.values()) {
            String recentId;
            Long cReqLink = issue.getCReqLink();
            if (!this.tryAddIssue(processedIssues, cReqLink, recentId = issue.getRecentId())) continue;
            this.incrementCount(result, cReqLink, issue.getAssignee(), IssueSort.SUBTASK);
            this.processLinkedIssuesForSubTask(issue, classification, result, processedIssues);
        }
        this.processCreatedLinkedIssues(classification, result, processedIssues);
        return result;
    }

    private void processLinkedIssuesForSubTask(AlmIssueEntity subTaskIssue, IssueClassification classification, Map<Long, Map<String, AssigneeIssueCountVO>> result, Map<Long, Set<String>> processedIssues) {
        if (ObjectUtils.isEmpty((Object)subTaskIssue.getLinkedIssues())) {
            return;
        }
        for (String linkedIssueId : subTaskIssue.getLinkedIssues()) {
            Long targetReqLink = this.findReqLinkForLinkedIssue(linkedIssueId, classification.rightReqIssues, classification.rightSubTaskIssues);
            if (targetReqLink == null || !this.tryAddIssue(processedIssues, targetReqLink, subTaskIssue.getRecentId())) continue;
            this.incrementCount(result, targetReqLink, subTaskIssue.getAssignee(), IssueSort.LINKEDISSUE);
        }
    }

    private void processCreatedLinkedIssues(IssueClassification classification, Map<Long, Map<String, AssigneeIssueCountVO>> result, Map<Long, Set<String>> processedIssues) {
        for (AlmIssueEntity linkedIssue : classification.linkedIssues.values()) {
            boolean isCreatedLink = ObjectUtils.isEmpty((Object)linkedIssue.getCReqLink());
            if (!isCreatedLink) continue;
            if (ObjectUtils.isEmpty((Object)linkedIssue.getParentReqKey())) {
                this.processCreatedLinkIssue(linkedIssue, classification, result, processedIssues);
                continue;
            }
            this.processCreatedLinkSubIssue(linkedIssue, classification, result, processedIssues);
        }
    }

    private void processCreatedLinkIssue(AlmIssueEntity createdLinkIssue, IssueClassification classification, Map<Long, Map<String, AssigneeIssueCountVO>> result, Map<Long, Set<String>> processedIssues) {
        if (ObjectUtils.isEmpty((Object)createdLinkIssue.getLinkedIssues())) {
            return;
        }
        for (String linkedIssueId : createdLinkIssue.getLinkedIssues()) {
            Long targetReqLink = this.findReqLinkForLinkedIssue(linkedIssueId, classification.rightReqIssues, classification.rightSubTaskIssues);
            if (targetReqLink == null || !this.tryAddIssue(processedIssues, targetReqLink, createdLinkIssue.getRecentId())) continue;
            this.incrementCount(result, targetReqLink, createdLinkIssue.getAssignee(), IssueSort.LINKEDISSUE);
        }
    }

    private void processCreatedLinkSubIssue(AlmIssueEntity subIssue, IssueClassification classification, Map<Long, Map<String, AssigneeIssueCountVO>> result, Map<Long, Set<String>> processedIssues) {
        String topLevelIssueId = ParseUtil.getPrefixIncludingLastDelimiter((String)subIssue.getRecentId()) + subIssue.getParentReqKey();
        AlmIssueEntity topLevelIssue = (AlmIssueEntity)classification.linkedIssues.get(topLevelIssueId);
        if (topLevelIssue == null) {
            return;
        }
        this.processIssueLinks(topLevelIssue, subIssue, classification, result, processedIssues);
        this.processIssueLinks(subIssue, subIssue, classification, result, processedIssues);
    }

    private void processIssueLinks(AlmIssueEntity sourceIssue, AlmIssueEntity targetIssue, IssueClassification classification, Map<Long, Map<String, AssigneeIssueCountVO>> result, Map<Long, Set<String>> processedIssues) {
        if (ObjectUtils.isEmpty((Object)sourceIssue.getLinkedIssues())) {
            return;
        }
        for (String linkedIssueId : sourceIssue.getLinkedIssues()) {
            Long targetReqLink = this.findReqLinkForLinkedIssue(linkedIssueId, classification.rightReqIssues, classification.rightSubTaskIssues);
            if (targetReqLink == null || !this.tryAddIssue(processedIssues, targetReqLink, targetIssue.getRecentId())) continue;
            this.incrementCount(result, targetReqLink, targetIssue.getAssignee(), IssueSort.LINKEDISSUE);
        }
    }

    private Long findReqLinkForLinkedIssue(String linkedIssueId, Map<String, AlmIssueEntity> reqIssues, Map<String, AlmIssueEntity> subTaskIssues) {
        AlmIssueEntity issue = reqIssues.get(linkedIssueId);
        if (issue == null) {
            issue = subTaskIssues.get(linkedIssueId);
        }
        return issue != null ? issue.getCReqLink() : null;
    }

    private boolean tryAddIssue(Map<Long, Set<String>> processedIssues, Long cReqLink, String recentId) {
        Set issueSet = processedIssues.computeIfAbsent(cReqLink, k -> new HashSet());
        return issueSet.add(recentId);
    }

    private void incrementCount(Map<Long, Map<String, AssigneeIssueCountVO>> result, Long cReqLink, AlmIssueEntity.Assignee assignee, IssueSort sort) {
        result.computeIfAbsent(cReqLink, k -> new HashMap()).compute(assignee.getAccountId(), (accountId, vo) -> {
            if (vo == null) {
                return this.createNewAssigneeVO(assignee, sort);
            }
            this.updateAssigneeVO(vo, sort);
            return vo;
        });
    }

    private AssigneeIssueCountVO createNewAssigneeVO(AlmIssueEntity.Assignee assignee, IssueSort sort) {
        return AssigneeIssueCountVO.builder().name(assignee.getDisplayName()).accountId(assignee.getAccountId()).emailAddress(assignee.getEmailAddress() != null ? assignee.getEmailAddress() : "").totalCount(1L).reqIssueCount(sort == IssueSort.REQISSUE ? 1L : 0L).subTaskCount(sort == IssueSort.SUBTASK ? 1L : 0L).linkedIssueCount(sort == IssueSort.LINKEDISSUE ? 1L : 0L).build();
    }

    private void updateAssigneeVO(AssigneeIssueCountVO vo, IssueSort sort) {
        switch (1.$SwitchMap$com$arms$api$analysis$scope$model$IssueSort[sort.ordinal()]) {
            case 1: {
                vo.addReqIssueCount(1L);
                break;
            }
            case 2: {
                vo.addSubTaskCount(1L);
                break;
            }
            case 3: {
                vo.addLinkedIssueCount(1L);
            }
        }
    }

    public List<TreeBarIssueVO> treeBarData(ScopeDTO scopeDTO) {
        Set existingSet;
        String recentId;
        Long cReqLink;
        AlmIssueEntity.Assignee assignee;
        HashMap reqLinkIssueCountVOList = new HashMap();
        HashMap<Long, Set> reqLinkRecentIdSetMap = new HashMap<Long, Set>();
        PdServiceAndIsReqDTO pdServiceAndIsReq = scopeDTO.getPdServiceAndIsReq();
        Long pdServiceId = pdServiceAndIsReq.getPdServiceId();
        List reqIssues = this.retrieveAssignedIssuesByIsReq(scopeDTO, Boolean.valueOf(true));
        List notReqIssues = this.retrieveAssignedIssuesByIsReq(scopeDTO, Boolean.valueOf(false));
        HashMap<String, AlmIssueEntity> rightReqIssueMap = new HashMap<String, AlmIssueEntity>();
        HashMap<String, AlmIssueEntity> rightSubTaskIssueMap = new HashMap<String, AlmIssueEntity>();
        HashMap<String, AlmIssueEntity> linkedIssueMap = new HashMap<String, AlmIssueEntity>();
        for (AlmIssueEntity reqIssue1 : reqIssues) {
            if (!reqIssue1.getPdServiceId().equals(pdServiceId)) {
                linkedIssueMap.computeIfAbsent(reqIssue1.getRecentId(), k -> reqIssue1);
                continue;
            }
            rightReqIssueMap.computeIfAbsent(reqIssue1.getRecentId(), k -> reqIssue1);
        }
        for (AlmIssueEntity notReqIssue1 : notReqIssues) {
            if (notReqIssue1.getPdServiceId() == null || notReqIssue1.getCReqLink() == null) {
                linkedIssueMap.computeIfAbsent(notReqIssue1.getRecentId(), k -> notReqIssue1);
                continue;
            }
            if (!notReqIssue1.getPdServiceId().equals(pdServiceId)) {
                linkedIssueMap.computeIfAbsent(notReqIssue1.getRecentId(), k -> notReqIssue1);
                continue;
            }
            rightSubTaskIssueMap.computeIfAbsent(notReqIssue1.getRecentId(), k -> notReqIssue1);
        }
        for (AlmIssueEntity reqIssue : rightReqIssueMap.values()) {
            assignee = reqIssue.getAssignee();
            cReqLink = reqIssue.getCReqLink();
            recentId = reqIssue.getRecentId();
            existingSet = reqLinkRecentIdSetMap.getOrDefault(cReqLink, new HashSet());
            if (existingSet.contains(recentId)) continue;
            if (existingSet.isEmpty()) {
                reqLinkRecentIdSetMap.put(cReqLink, existingSet);
            }
            existingSet.add(recentId);
            this.processReqLinkAssigneeIssueCount(reqLinkIssueCountVOList, cReqLink, assignee, IssueSort.REQISSUE);
        }
        for (AlmIssueEntity notReqIssue : rightSubTaskIssueMap.values()) {
            assignee = notReqIssue.getAssignee();
            cReqLink = notReqIssue.getCReqLink();
            recentId = notReqIssue.getRecentId();
            existingSet = reqLinkRecentIdSetMap.getOrDefault(cReqLink, new HashSet());
            if (existingSet.contains(recentId)) continue;
            if (existingSet.isEmpty()) {
                reqLinkRecentIdSetMap.put(cReqLink, existingSet);
            }
            existingSet.add(recentId);
            this.processReqLinkAssigneeIssueCount(reqLinkIssueCountVOList, cReqLink, assignee, IssueSort.SUBTASK);
            if (ObjectUtils.isEmpty((Object)notReqIssue.getLinkedIssues())) continue;
            notReqIssue.getLinkedIssues().forEach(linkedIssueRecentId -> {
                AlmIssueEntity fetchedIssue;
                Long reqLinkOfIssue;
                Set recentIdSet;
                if (rightReqIssueMap.get(linkedIssueRecentId) != null && !ObjectUtils.isEmpty((Object)(recentIdSet = (Set)reqLinkRecentIdSetMap.getOrDefault(reqLinkOfIssue = (fetchedIssue = (AlmIssueEntity)rightReqIssueMap.get(linkedIssueRecentId)).getCReqLink(), new HashSet()))) && !recentIdSet.contains(recentId)) {
                    this.processReqLinkAssigneeIssueCount(reqLinkIssueCountVOList, reqLinkOfIssue, assignee, IssueSort.LINKEDISSUE);
                    recentIdSet.add(recentId);
                }
                if (rightSubTaskIssueMap.get(linkedIssueRecentId) != null && !ObjectUtils.isEmpty((Object)(recentIdSet = (Set)reqLinkRecentIdSetMap.getOrDefault(reqLinkOfIssue = (fetchedIssue = (AlmIssueEntity)rightSubTaskIssueMap.get(linkedIssueRecentId)).getCReqLink(), new HashSet()))) && !recentIdSet.contains(recentId)) {
                    this.processReqLinkAssigneeIssueCount(reqLinkIssueCountVOList, reqLinkOfIssue, assignee, IssueSort.LINKEDISSUE);
                    recentIdSet.add(recentId);
                }
            });
        }
        for (AlmIssueEntity linkedIssue : linkedIssueMap.values()) {
            AlmIssueEntity topLevelLinkIssue;
            assignee = linkedIssue.getAssignee();
            String recentId2 = linkedIssue.getRecentId();
            if (ObjectUtils.isEmpty((Object)linkedIssue.getCReqLink()) && ObjectUtils.isEmpty((Object)linkedIssue.getParentReqKey()) && !ObjectUtils.isEmpty((Object)linkedIssue.getLinkedIssues())) {
                linkedIssue.getLinkedIssues().forEach(linkedIssueRecentId -> {
                    AlmIssueEntity fetchedIssue;
                    Long reqLinkOfIssue;
                    Set recentIdSet;
                    if (rightReqIssueMap.get(linkedIssueRecentId) != null && !(recentIdSet = (Set)reqLinkRecentIdSetMap.getOrDefault(reqLinkOfIssue = (fetchedIssue = (AlmIssueEntity)rightReqIssueMap.get(linkedIssueRecentId)).getCReqLink(), new HashSet())).contains(recentId2)) {
                        this.processReqLinkAssigneeIssueCount(reqLinkIssueCountVOList, reqLinkOfIssue, assignee, IssueSort.LINKEDISSUE);
                        recentIdSet.add(recentId2);
                    }
                    if (rightSubTaskIssueMap.get(linkedIssueRecentId) != null && !(recentIdSet = (Set)reqLinkRecentIdSetMap.getOrDefault(reqLinkOfIssue = (fetchedIssue = (AlmIssueEntity)rightSubTaskIssueMap.get(linkedIssueRecentId)).getCReqLink(), new HashSet())).contains(recentId2)) {
                        this.processReqLinkAssigneeIssueCount(reqLinkIssueCountVOList, reqLinkOfIssue, assignee, IssueSort.LINKEDISSUE);
                        recentIdSet.add(recentId2);
                    }
                });
            }
            if (!ObjectUtils.isEmpty((Object)linkedIssue.getCReqLink()) || ObjectUtils.isEmpty((Object)linkedIssue.getParentReqKey())) continue;
            String topLevelLinkedIssueRecentId = ParseUtil.getPrefixIncludingLastDelimiter((String)recentId2) + linkedIssue.getParentReqKey();
            if (linkedIssueMap.get(topLevelLinkedIssueRecentId) != null && !ObjectUtils.isEmpty((Object)(topLevelLinkIssue = (AlmIssueEntity)linkedIssueMap.get(topLevelLinkedIssueRecentId)).getLinkedIssues())) {
                topLevelLinkIssue.getLinkedIssues().forEach(linkedIssueRecentId -> {
                    AlmIssueEntity fetchedIssue;
                    Long reqLinkOfIssue;
                    Set recentIdSet;
                    if (rightReqIssueMap.get(linkedIssueRecentId) != null && !(recentIdSet = (Set)reqLinkRecentIdSetMap.getOrDefault(reqLinkOfIssue = (fetchedIssue = (AlmIssueEntity)rightReqIssueMap.get(linkedIssueRecentId)).getCReqLink(), new HashSet())).contains(recentId2)) {
                        this.processReqLinkAssigneeIssueCount(reqLinkIssueCountVOList, reqLinkOfIssue, assignee, IssueSort.LINKEDISSUE);
                        recentIdSet.add(recentId2);
                    }
                    if (rightSubTaskIssueMap.get(linkedIssueRecentId) != null && !(recentIdSet = (Set)reqLinkRecentIdSetMap.getOrDefault(reqLinkOfIssue = (fetchedIssue = (AlmIssueEntity)rightSubTaskIssueMap.get(linkedIssueRecentId)).getCReqLink(), new HashSet())).contains(recentId2)) {
                        this.processReqLinkAssigneeIssueCount(reqLinkIssueCountVOList, reqLinkOfIssue, assignee, IssueSort.LINKEDISSUE);
                        recentIdSet.add(recentId2);
                    }
                });
            }
            if (ObjectUtils.isEmpty((Object)linkedIssue.getLinkedIssues())) continue;
            linkedIssue.getLinkedIssues().forEach(linkedIssueRecentId -> {
                AlmIssueEntity fetchedIssue;
                Long reqLinkOfIssue;
                Set recentIdSet;
                if (rightReqIssueMap.get(linkedIssueRecentId) != null && !(recentIdSet = (Set)reqLinkRecentIdSetMap.getOrDefault(reqLinkOfIssue = (fetchedIssue = (AlmIssueEntity)rightReqIssueMap.get(linkedIssueRecentId)).getCReqLink(), new HashSet())).contains(recentId2)) {
                    this.processReqLinkAssigneeIssueCount(reqLinkIssueCountVOList, reqLinkOfIssue, assignee, IssueSort.LINKEDISSUE);
                    recentIdSet.add(recentId2);
                }
                if (rightSubTaskIssueMap.get(linkedIssueRecentId) != null && !(recentIdSet = (Set)reqLinkRecentIdSetMap.getOrDefault(reqLinkOfIssue = (fetchedIssue = (AlmIssueEntity)rightSubTaskIssueMap.get(linkedIssueRecentId)).getCReqLink(), new HashSet())).contains(recentId2)) {
                    this.processReqLinkAssigneeIssueCount(reqLinkIssueCountVOList, reqLinkOfIssue, assignee, IssueSort.LINKEDISSUE);
                    recentIdSet.add(recentId2);
                }
            });
        }
        if (reqLinkIssueCountVOList.isEmpty()) {
            return Collections.emptyList();
        }
        return this.convertToTreeBarIssueVOList(reqLinkIssueCountVOList, scopeDTO.getTopN());
    }

    private List<TreeBarIssueVO> convertToTreeBarIssueVOList(Map<Long, Map<String, AssigneeIssueCountVO>> reqLinkIssueCountVOList, Integer topN) {
        ArrayList<TreeBarIssueVO> result = new ArrayList<TreeBarIssueVO>();
        List sortedEntries = reqLinkIssueCountVOList.entrySet().stream().sorted((e1, e2) -> Integer.compare(((Map)e2.getValue()).size(), ((Map)e1.getValue()).size())).collect(Collectors.toList());
        if (topN != null && topN > 0) {
            sortedEntries = sortedEntries.stream().limit(topN.intValue()).collect(Collectors.toList());
        }
        for (Map.Entry entry : sortedEntries) {
            Long cReqLink = (Long)entry.getKey();
            Map assigneeMap = (Map)entry.getValue();
            for (AssigneeIssueCountVO assigneeVO : assigneeMap.values()) {
                Object displayName = assigneeVO.getName();
                if (assigneeVO.getEmailAddress() != null && !assigneeVO.getEmailAddress().isEmpty()) {
                    String username = ParseUtil.extractUsernameFromEmail((String)assigneeVO.getEmailAddress());
                    displayName = (String)displayName + "(" + username + ")";
                }
                TreeBarIssueVO treeBarIssueVO = TreeBarIssueVO.builder().cReqLink(cReqLink).assigneeDisplayName((String)displayName).assigneeCount(Long.valueOf(assigneeVO.getTotalCount())).build();
                result.add(treeBarIssueVO);
            }
        }
        return result;
    }

    private void processReqLinkAssigneeIssueCount(Map<Long, Map<String, AssigneeIssueCountVO>> reqLinkIssueCountVOList, Long cReqLink, AlmIssueEntity.Assignee assignee, IssueSort sort) {
        String accountId = assignee.getAccountId();
        String name = assignee.getDisplayName();
        String emailAddress = assignee.getEmailAddress() == null ? "" : assignee.getEmailAddress();
        reqLinkIssueCountVOList.compute(cReqLink, (key, idAssigneeIssueCountVOMap) -> {
            if (idAssigneeIssueCountVOMap == null) {
                HashMap<String, AssigneeIssueCountVO> newMap = new HashMap<String, AssigneeIssueCountVO>();
                newMap.put(accountId, AssigneeIssueCountVO.builder().name(name).accountId(accountId).emailAddress(emailAddress).totalCount(1L).reqIssueCount(sort.equals((Object)IssueSort.REQISSUE) ? 1L : 0L).subTaskCount(sort.equals((Object)IssueSort.SUBTASK) ? 1L : 0L).linkedIssueCount(sort.equals((Object)IssueSort.LINKEDISSUE) ? 1L : 0L).build());
                return newMap;
            }
            idAssigneeIssueCountVOMap.compute(accountId, (id, assigneeVO) -> {
                if (assigneeVO == null) {
                    return AssigneeIssueCountVO.builder().name(name).accountId(accountId).emailAddress(emailAddress).totalCount(1L).reqIssueCount(sort.equals((Object)IssueSort.REQISSUE) ? 1L : 0L).subTaskCount(sort.equals((Object)IssueSort.SUBTASK) ? 1L : 0L).linkedIssueCount(sort.equals((Object)IssueSort.LINKEDISSUE) ? 1L : 0L).build();
                }
                if (sort.equals((Object)IssueSort.REQISSUE)) {
                    assigneeVO.addReqIssueCount(1L);
                }
                if (sort.equals((Object)IssueSort.SUBTASK)) {
                    assigneeVO.addSubTaskCount(1L);
                }
                if (sort.equals((Object)IssueSort.LINKEDISSUE)) {
                    assigneeVO.addLinkedIssueCount(1L);
                }
                return assigneeVO;
            });
            return idAssigneeIssueCountVOMap;
        });
    }

    private List<AlmIssueEntity> retrieveAssignedIssuesByIsReq(ScopeDTO scopeDTO, Boolean isReq) {
        PdServiceAndIsReqDTO pdServiceAndIsReq = scopeDTO.getPdServiceAndIsReq();
        Long pdServiceId = pdServiceAndIsReq.getPdServiceId();
        List pdServiceVersions = pdServiceAndIsReq.getPdServiceVersions();
        return this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termsQueryFilter((String)"linkedIssuePdServiceIds", List.of(pdServiceId)).andTermsQueryFilter("linkedIssuePdServiceVersions", pdServiceVersions).andTermQueryMust("isReq", (Object)isReq).andRangeQueryFilter(RangeQueryFilter.of((String)"updated").betweenDate(scopeDTO.getStartDate(), scopeDTO.getEndDate())).andExistsQueryFilter("assignee")).toDocs();
    }

    private List<AlmIssueEntity> retrieveIssuesByIsReq(ScopeDTO scopeDTO, Boolean isReq) {
        PdServiceAndIsReqDTO pdServiceAndIsReq = scopeDTO.getPdServiceAndIsReq();
        Long pdServiceId = pdServiceAndIsReq.getPdServiceId();
        List pdServiceVersions = pdServiceAndIsReq.getPdServiceVersions();
        return this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termsQueryFilter((String)"linkedIssuePdServiceIds", List.of(pdServiceId)).andTermsQueryFilter("linkedIssuePdServiceVersions", pdServiceVersions).andTermQueryMust("isReq", (Object)isReq).andRangeQueryFilter(RangeQueryFilter.of((String)"updated").betweenDate(scopeDTO.getStartDate(), scopeDTO.getEndDate()))).toDocs();
    }

    public List<PdServiceVersionsAndReqVO> getPdServiceVersionsAndReq(ScopeDTO scopeDto) {
        List reqIssueList = this.getReqIssueList(scopeDto);
        Map subTaskIssueCount = this.getSubTaskIssueCount(scopeDto);
        return reqIssueList.stream().flatMap(reqIssue -> {
            Long pdServiceId = reqIssue.getPdServiceId();
            String recentId = reqIssue.getRecentId();
            String key = reqIssue.getKey();
            Long cReqLink = reqIssue.getCReqLink();
            long subTaskCount = subTaskIssueCount.getOrDefault(recentId, 0).intValue();
            int linkedIssueCount = Optional.ofNullable(reqIssue.getLinkedIssues()).map(List::size).orElse(0);
            return reqIssue.getPdServiceVersions().stream().map(version -> PdServiceVersionsAndReqVO.builder().pdServiceId(pdServiceId).pdServiceVersionId(version).reqId(key).recentId(recentId).cReqLink(cReqLink).relatedIssueCount(Long.valueOf(subTaskCount + (long)linkedIssueCount)).issueType("REQ").build());
        }).collect(Collectors.toList());
    }

    public List<IssueVO> getVersionsAndIssuList(ScopeDTO scopeDTO) {
        List requirements = this.getReqIssueList(scopeDTO);
        List<String> reqRecentIds = requirements.stream().map(AlmIssueEntity::getRecentId).toList();
        List subtasks = this.getVersionsAndSubTaskIssue(scopeDTO);
        List allAlmIssuesCreatedInternally = this.getAllAlmIssuesCreatedInternally();
        List relatedAlmIssue = this.findAllRelatedAlmIssues(allAlmIssuesCreatedInternally, reqRecentIds);
        ArrayList merged = new ArrayList();
        if (requirements != null) {
            merged.addAll(requirements);
        }
        if (subtasks != null) {
            merged.addAll(subtasks);
        }
        if (relatedAlmIssue != null) {
            merged.addAll(relatedAlmIssue);
        }
        return this.setIssueData(merged);
    }

    public List<IssueVO> getIssueList(ScopeDTO scopeDTO) {
        List reqIssueList = this.getReqIssue(scopeDTO);
        List<String> reqRecentIds = reqIssueList.stream().map(AlmIssueEntity::getRecentId).toList();
        List subtasks = this.getSubTaskAndLinkedIssue(scopeDTO);
        List allAlmIssuesCreatedInternally = this.getAllAlmIssuesCreatedInternally();
        List relatedAlmIssue = this.findAllRelatedAlmIssues(allAlmIssuesCreatedInternally, reqRecentIds);
        ArrayList merged = new ArrayList();
        if (reqIssueList != null) {
            merged.addAll(reqIssueList);
        }
        if (subtasks != null) {
            merged.addAll(subtasks);
        }
        if (relatedAlmIssue != null) {
            merged.addAll(relatedAlmIssue);
        }
        return this.setIssueData(merged);
    }

    private List<IssueVO> setIssueData(List<AlmIssueEntity> issueList) {
        Map byRecentId = issueList.stream().filter(Objects::nonNull).filter(i -> i.getRecentId() != null && !i.getRecentId().isEmpty()).collect(Collectors.toMap(AlmIssueEntity::getRecentId, i -> i, (a, b) -> a, LinkedHashMap::new));
        ArrayList<IssueVO> out = new ArrayList<IssueVO>(byRecentId.size());
        for (AlmIssueEntity e : byRecentId.values()) {
            out.add(IssueVO.builder().recentId(e.getRecentId()).issueKey(e.getKey()).parentReqKey(e.getParentReqKey()).upperKey(e.getUpperKey()).isReq(e.getIsReq()).issueType(this.classifyLinkType(e)).serverId(e.getJira_server_id()).cReqLink(e.getCReqLink()).projectKey(e.getProject().getKey()).versions(e.getPdServiceVersions()).linkedIssueKeys(e.getLinkedIssues()).build());
        }
        return out;
    }

    private String classifyLinkType(AlmIssueEntity e) {
        if (Boolean.TRUE.equals(e.getIsReq())) {
            return "REQ";
        }
        if (e.getCReqLink() != null) {
            return "SUB";
        }
        if (e.getParentReqKey() != null && !e.getParentReqKey().isEmpty()) {
            return "SUB";
        }
        return "ALM";
    }

    private List<AlmIssueEntity> getReqIssueList(ScopeDTO scopeDTO) {
        Long serviceId = scopeDTO.getPdServiceAndIsReq().getPdServiceId();
        List versions = scopeDTO.getPdServiceAndIsReq().getPdServiceVersions();
        return this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termQueryMust((String)"pdServiceId", (Object)serviceId).andTermsQueryFilter("pdServiceVersions", versions).andTermQueryMust("isReq", (Object)true)).toDocs();
    }

    private List<AlmIssueEntity> getReqIssue(ScopeDTO scopeDTO) {
        Long serviceId = scopeDTO.getPdServiceAndIsReq().getPdServiceId();
        List versions = scopeDTO.getPdServiceAndIsReq().getPdServiceVersions();
        List issues = this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termQueryMust((String)"pdServiceId", (Object)serviceId).andTermQueryMust("isReq", (Object)true).andTermQueryMust("cReqLink", (Object)scopeDTO.getReqId()).andTermsQueryFilter("pdServiceVersions", versions)).toDocs();
        Map<String, AlmIssueEntity> uniqueIssuesMap = issues.stream().collect(Collectors.toMap(AlmIssueEntity::getRecentId, issue -> issue, (existing, replacement) -> existing));
        return new ArrayList<AlmIssueEntity>(uniqueIssuesMap.values());
    }

    private List<AlmIssueEntity> getAllAlmIssuesCreatedInternally() {
        return this.esCommonRepositoryWrapper.findRecentDocsByScrollApi(SimpleQuery.termQueryMust((String)"isReq", (Object)false).andExistQueryMustNot("cReqLink"));
    }

    private List<AlmIssueEntity> findAllRelatedAlmIssues(List<AlmIssueEntity> allAlmIssues, List<String> reqRecentIds) {
        Map byRecentId = allAlmIssues.stream().filter(Objects::nonNull).filter(i -> i.getRecentId() != null && !i.getRecentId().isEmpty()).collect(Collectors.toMap(AlmIssueEntity::getRecentId, i -> i, (a, b) -> a, LinkedHashMap::new));
        Map childrenByParent = this.buildChildrenIndex(allAlmIssues);
        HashSet<String> reqRecentIdsSet = new HashSet<String>(reqRecentIds);
        List<AlmIssueEntity> seed = allAlmIssues.stream().filter(Objects::nonNull).filter(issue -> {
            List linked = issue.getLinkedIssues();
            if (linked == null || linked.isEmpty()) {
                return false;
            }
            for (String rid : linked) {
                if (rid == null || !reqRecentIdsSet.contains(rid)) continue;
                return true;
            }
            return false;
        }).toList();
        if (seed.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<String> outVisited = new HashSet<String>();
        HashSet<String> linkExpanded = new HashSet<String>();
        ArrayList<AlmIssueEntity> out = new ArrayList<AlmIssueEntity>();
        ArrayDeque<AlmIssueEntity> wave = new ArrayDeque<AlmIssueEntity>(seed);
        int MAX_EXPANSIONS = Math.max(1, allAlmIssues.size());
        while (!wave.isEmpty() && linkExpanded.size() <= MAX_EXPANSIONS) {
            List linked;
            String curKey;
            String curRid;
            AlmIssueEntity cur = (AlmIssueEntity)wave.pollFirst();
            if (cur == null || (curRid = cur.getRecentId()) == null || !linkExpanded.add(curRid)) continue;
            if (outVisited.add(curRid)) {
                out.add(cur);
            }
            if ((curKey = cur.getKey()) != null && !curKey.isEmpty()) {
                this.collectDescendants(curKey, childrenByParent, outVisited, out);
            }
            if ((linked = cur.getLinkedIssues()) == null || linked.isEmpty()) continue;
            for (String nextRid : linked) {
                AlmIssueEntity next;
                if (nextRid == null || nextRid.isEmpty() || (next = (AlmIssueEntity)byRecentId.get(nextRid)) == null || linkExpanded.contains(nextRid)) continue;
                wave.addLast(next);
            }
        }
        return out;
    }

    private Map<String, List<AlmIssueEntity>> buildChildrenIndex(List<AlmIssueEntity> issues) {
        HashMap<String, List<AlmIssueEntity>> map = new HashMap<String, List<AlmIssueEntity>>();
        for (AlmIssueEntity almIssueEntity : issues) {
            String parent;
            if (almIssueEntity == null || (parent = almIssueEntity.getParentReqKey()) == null || parent.isEmpty()) continue;
            map.computeIfAbsent(parent, k -> new ArrayList()).add(almIssueEntity);
        }
        for (Map.Entry entry : map.entrySet()) {
            entry.setValue(Collections.unmodifiableList((List)entry.getValue()));
        }
        return map;
    }

    private void collectDescendants(String parentKey, Map<String, List<AlmIssueEntity>> childrenByParent, Set<String> outVisited, List<AlmIssueEntity> out) {
        ArrayDeque<String> stack = new ArrayDeque<String>();
        stack.push(parentKey);
        while (!stack.isEmpty()) {
            List<AlmIssueEntity> children;
            String curKey = (String)stack.pop();
            if (curKey == null || curKey.isEmpty() || (children = childrenByParent.get(curKey)) == null || children.isEmpty()) continue;
            for (AlmIssueEntity ch : children) {
                String rid;
                if (ch == null || (rid = ch.getRecentId()) == null || !outVisited.add(rid)) continue;
                out.add(ch);
                String nextKey = ch.getKey();
                if (nextKey == null || nextKey.isEmpty()) continue;
                stack.push(nextKey);
            }
        }
    }

    private List<AlmIssueEntity> getVersionsAndSubTaskIssue(ScopeDTO scopeDTO) {
        return this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termQueryMust((String)"pdServiceId", (Object)scopeDTO.getPdServiceAndIsReq().getPdServiceId()).andTermQueryMust("isReq", (Object)false).andTermsQueryFilter("pdServiceVersions", scopeDTO.getPdServiceAndIsReq().getPdServiceVersions())).toDocs();
    }

    private List<AlmIssueEntity> getSubTaskAndLinkedIssue(ScopeDTO scopeDTO) {
        List issues = this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termQueryMust((String)"pdServiceId", (Object)scopeDTO.getPdServiceAndIsReq().getPdServiceId()).andTermQueryMust("isReq", (Object)false).andTermQueryMust("cReqLink", (Object)scopeDTO.getReqId()).andTermsQueryFilter("pdServiceVersions", scopeDTO.getPdServiceAndIsReq().getPdServiceVersions())).toDocs();
        Map<String, AlmIssueEntity> uniqueIssuesMap = issues.stream().collect(Collectors.toMap(AlmIssueEntity::getRecentId, issue -> issue, (existing, replacement) -> existing));
        return new ArrayList<AlmIssueEntity>(uniqueIssuesMap.values());
    }

    public List<CircularPackingChartVO> getCircularPackingChartDataV2(ScopeDTO scopeDTO) {
        Long pdServiceId = scopeDTO.getPdServiceAndIsReq().getPdServiceId();
        List reqIssues = this.retrieveIssuesByIsReq(scopeDTO, Boolean.valueOf(true));
        List notReqIssues = this.retrieveIssuesByIsReq(scopeDTO, Boolean.valueOf(false));
        IssueClassification classification = this.classifyIssues(reqIssues, notReqIssues, pdServiceId);
        Map reqLinkIssueCountMap = this.aggregateIssueCountsV2(classification);
        return this.buildCircularPackingChartVOList(classification.rightReqIssues, reqLinkIssueCountMap);
    }

    private List<CircularPackingChartVO> buildCircularPackingChartVOList(Map<String, AlmIssueEntity> rightReqIssues, Map<Long, Map<String, AssigneeIssueCountVO>> reqLinkIssueCountMap) {
        ArrayList<CircularPackingChartVO> result = new ArrayList<CircularPackingChartVO>(rightReqIssues.size());
        for (AlmIssueEntity reqIssue : rightReqIssues.values()) {
            Long cReqLink = reqIssue.getCReqLink();
            Map assigneeMap = reqLinkIssueCountMap.getOrDefault(cReqLink, Collections.emptyMap());
            CircularPackingAggregation aggregation = this.calculateAggregation(assigneeMap);
            String almState = reqIssue.getStatus() != null ? reqIssue.getStatus().getName() : null;
            CircularPackingChartVO chartVO = CircularPackingChartVO.builder().almState(almState).linkedIssueCount(aggregation.totalLinkedIssueCount).subTaskCount(aggregation.totalSubTaskCount).numOfWorkers(aggregation.numOfWorkers).workersList(aggregation.workersList).recentId(reqIssue.getRecentId()).issueKey(reqIssue.getKey()).cReqLink(cReqLink).versions(reqIssue.getPdServiceVersions()).serviceId(reqIssue.getPdServiceId()).type("ALM").build();
            result.add(chartVO);
        }
        return result;
    }

    private CircularPackingAggregation calculateAggregation(Map<String, AssigneeIssueCountVO> assigneeMap) {
        if (assigneeMap.isEmpty()) {
            return new CircularPackingAggregation(0, 0, Collections.emptyList());
        }
        int totalSubTaskCount = 0;
        int totalLinkedIssueCount = 0;
        ArrayList<String> workersList = new ArrayList<String>();
        for (AssigneeIssueCountVO assigneeVO : assigneeMap.values()) {
            totalSubTaskCount = (int)((long)totalSubTaskCount + assigneeVO.getSubTaskCount());
            totalLinkedIssueCount = (int)((long)totalLinkedIssueCount + assigneeVO.getLinkedIssueCount());
            String displayName = assigneeVO.getName();
            if (displayName == null || displayName.isEmpty()) continue;
            workersList.add(displayName);
        }
        return new CircularPackingAggregation(totalSubTaskCount, totalLinkedIssueCount, workersList);
    }

    public List<NetworkChartExcelDataVO> getNetworkChartExcelData(ScopeDTO scopeDTO) {
        List reqIssueList = this.getReqIssueInDataRange(scopeDTO);
        Map subTaskAndLinkedIssueCount = this.getSubTaskIssueCount(scopeDTO);
        return reqIssueList.stream().map(reqIssue -> NetworkChartExcelDataVO.builder().createDate(reqIssue.stringValueOfCreatedDate()).pdServiceVersions(reqIssue.getPdServiceVersions()).key(reqIssue.getKey()).summary(reqIssue.getSummary()).issueType("requirement").subTaskCount(subTaskAndLinkedIssueCount.getOrDefault(reqIssue.getRecentId(), 0) - reqIssue.getLinkedIssues().size()).linkedIssueCount(reqIssue.getLinkedIssues().size()).build()).collect(Collectors.toList());
    }

    private List<AlmIssueEntity> getReqIssueInDataRange(ScopeDTO scopeDTO) {
        return this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termQueryFilter((String)"isReq", (Object)true).andTermQueryFilter("pdServiceId", (Object)scopeDTO.getPdServiceAndIsReq().getPdServiceId()).andTermsQueryFilter("pdServiceVersions", scopeDTO.getPdServiceAndIsReq().getPdServiceVersions()).andRangeQueryFilter(RangeQueryFilter.of((String)"created").betweenDate(scopeDTO.getStartDate(), scopeDTO.getEndDate()))).toDocs();
    }

    private Map<String, Integer> getSubTaskIssueCount(ScopeDTO scopeDTO) {
        Long serviceId = scopeDTO.getPdServiceAndIsReq().getPdServiceId();
        List versions = scopeDTO.getPdServiceAndIsReq().getPdServiceVersions();
        DocumentAggregations aggregations = this.esCommonRepositoryWrapper.aggregateRecentDocs(SimpleQuery.aggregation((AggregationRequestDTO)AggregationRequestDTO.builder().mainField("jira_server_id").mainFieldAlias("jira_server_id").subGroupFieldDTOS(List.of(SubGroupFieldDTO.builder().subFieldAlias("parentReqKey").subField("parentReqKey").build(), SubGroupFieldDTO.builder().subFieldAlias("projectKey").subField("project.project_key.keyword").build())).build()).andTermQueryMust("pdServiceId", (Object)serviceId).andTermQueryMust("isReq", (Object)false).andTermsQueryFilter("pdServiceVersions", versions));
        List documentBuckets = aggregations.deepestList();
        HashMap<String, Integer> subTaskCount = new HashMap<String, Integer>();
        for (DocumentBucket documentBucket : documentBuckets) {
            String jira_server_id = documentBucket.valueByName("jira_server_id");
            String key = documentBucket.valueByName("parentReqKey");
            String projectKey = documentBucket.valueByName("projectKey");
            Long count = documentBucket.countByName("parentReqKey");
            String id = jira_server_id + "_" + projectKey + "_" + key;
            subTaskCount.put(id, count.intValue());
        }
        return subTaskCount;
    }

    public List<ReqDataTableIssuesVO> getDataTableIssues(ScopeDTO scopeDTO) {
        List reqIssueList = this.getReqIssueInDataRange(scopeDTO);
        Map subTaskAndLinkedIssueCount = this.getSubTaskIssueCount(scopeDTO);
        HashSet uniqueReqLinks = new HashSet();
        return reqIssueList.stream().filter(reqIssue -> uniqueReqLinks.add(reqIssue.getCReqLink())).map(reqIssue -> {
            String rawDate = reqIssue.stringValueOfCreatedDate();
            String formattedDate = rawDate != null && rawDate.length() >= 10 ? rawDate.substring(0, 10) : rawDate;
            return ReqDataTableIssuesVO.builder().reqLink(reqIssue.getCReqLink()).pdServiceVersionLinks(reqIssue.getPdServiceVersions()).priorityName(reqIssue.getCReqProperty().getCReqPriorityName()).difficultyName(reqIssue.getCReqProperty().getCReqDifficultyName()).stateName(reqIssue.getCReqProperty().getCReqStateName()).summary(reqIssue.getSummary()).createDate(formattedDate).subTaskCount(subTaskAndLinkedIssueCount.getOrDefault(reqIssue.getRecentId(), 0).intValue()).linkedIssueCount(reqIssue.getLinkedIssues().size()).build();
        }).collect(Collectors.toList());
    }

    private Map<Long, Map<String, AssigneeIssueCountVO>> aggregateIssueCountsV2(IssueClassification classification) {
        HashMap<Long, Map<String, AssigneeIssueCountVO>> result = new HashMap<Long, Map<String, AssigneeIssueCountVO>>();
        HashMap processedIssues = new HashMap();
        for (AlmIssueEntity issue : classification.rightReqIssues.values()) {
            if (!this.tryAddIssue(processedIssues, issue.getCReqLink(), issue.getRecentId())) continue;
            this.incrementCountV2(result, issue.getCReqLink(), issue.getAssignee(), IssueSort.REQISSUE);
        }
        for (AlmIssueEntity issue : classification.rightSubTaskIssues.values()) {
            String recentId;
            Long cReqLink = issue.getCReqLink();
            if (!this.tryAddIssue(processedIssues, cReqLink, recentId = issue.getRecentId())) continue;
            this.incrementCountV2(result, cReqLink, issue.getAssignee(), IssueSort.SUBTASK);
            this.processLinkedIssuesForSubTaskV2(issue, classification, result, processedIssues);
        }
        this.processCreatedLinkedIssuesV2(classification, result, processedIssues);
        return result;
    }

    private void incrementCountV2(Map<Long, Map<String, AssigneeIssueCountVO>> result, Long cReqLink, AlmIssueEntity.Assignee assignee, IssueSort sort) {
        String accountId = assignee != null ? assignee.getAccountId() : "UNASSIGNED";
        String name = assignee != null ? assignee.getDisplayName() : "Unassigned";
        String emailAddress = assignee != null && assignee.getEmailAddress() != null ? assignee.getEmailAddress() : "";
        result.computeIfAbsent(cReqLink, k -> new HashMap()).compute(accountId, (id, vo) -> {
            if (vo == null) {
                return AssigneeIssueCountVO.builder().name(name).accountId(accountId).emailAddress(emailAddress).totalCount(1L).reqIssueCount(sort == IssueSort.REQISSUE ? 1L : 0L).subTaskCount(sort == IssueSort.SUBTASK ? 1L : 0L).linkedIssueCount(sort == IssueSort.LINKEDISSUE ? 1L : 0L).build();
            }
            this.updateAssigneeVO(vo, sort);
            return vo;
        });
    }

    private void processLinkedIssuesForSubTaskV2(AlmIssueEntity subTaskIssue, IssueClassification classification, Map<Long, Map<String, AssigneeIssueCountVO>> result, Map<Long, Set<String>> processedIssues) {
        if (ObjectUtils.isEmpty((Object)subTaskIssue.getLinkedIssues())) {
            return;
        }
        for (String linkedIssueId : subTaskIssue.getLinkedIssues()) {
            Long targetReqLink = this.findReqLinkForLinkedIssue(linkedIssueId, classification.rightReqIssues, classification.rightSubTaskIssues);
            if (targetReqLink == null || !this.tryAddIssue(processedIssues, targetReqLink, subTaskIssue.getRecentId())) continue;
            this.incrementCountV2(result, targetReqLink, subTaskIssue.getAssignee(), IssueSort.LINKEDISSUE);
        }
    }

    private void processCreatedLinkedIssuesV2(IssueClassification classification, Map<Long, Map<String, AssigneeIssueCountVO>> result, Map<Long, Set<String>> processedIssues) {
        for (AlmIssueEntity linkedIssue : classification.linkedIssues.values()) {
            boolean isCreatedLink = ObjectUtils.isEmpty((Object)linkedIssue.getCReqLink());
            if (!isCreatedLink) continue;
            if (ObjectUtils.isEmpty((Object)linkedIssue.getParentReqKey())) {
                this.processCreatedLinkIssueV2(linkedIssue, classification, result, processedIssues);
                continue;
            }
            this.processCreatedLinkSubIssueV2(linkedIssue, classification, result, processedIssues);
        }
    }

    private void processCreatedLinkIssueV2(AlmIssueEntity createdLinkIssue, IssueClassification classification, Map<Long, Map<String, AssigneeIssueCountVO>> result, Map<Long, Set<String>> processedIssues) {
        if (ObjectUtils.isEmpty((Object)createdLinkIssue.getLinkedIssues())) {
            return;
        }
        for (String linkedIssueId : createdLinkIssue.getLinkedIssues()) {
            Long targetReqLink = this.findReqLinkForLinkedIssue(linkedIssueId, classification.rightReqIssues, classification.rightSubTaskIssues);
            if (targetReqLink == null || !this.tryAddIssue(processedIssues, targetReqLink, createdLinkIssue.getRecentId())) continue;
            this.incrementCountV2(result, targetReqLink, createdLinkIssue.getAssignee(), IssueSort.LINKEDISSUE);
        }
    }

    private void processCreatedLinkSubIssueV2(AlmIssueEntity subIssue, IssueClassification classification, Map<Long, Map<String, AssigneeIssueCountVO>> result, Map<Long, Set<String>> processedIssues) {
        String topLevelIssueId = ParseUtil.getPrefixIncludingLastDelimiter((String)subIssue.getRecentId()) + subIssue.getParentReqKey();
        AlmIssueEntity topLevelIssue = (AlmIssueEntity)classification.linkedIssues.get(topLevelIssueId);
        if (topLevelIssue == null) {
            return;
        }
        this.processIssueLinksV2(topLevelIssue, subIssue, classification, result, processedIssues);
        this.processIssueLinksV2(subIssue, subIssue, classification, result, processedIssues);
    }

    private void processIssueLinksV2(AlmIssueEntity sourceIssue, AlmIssueEntity targetIssue, IssueClassification classification, Map<Long, Map<String, AssigneeIssueCountVO>> result, Map<Long, Set<String>> processedIssues) {
        if (ObjectUtils.isEmpty((Object)sourceIssue.getLinkedIssues())) {
            return;
        }
        for (String linkedIssueId : sourceIssue.getLinkedIssues()) {
            Long targetReqLink = this.findReqLinkForLinkedIssue(linkedIssueId, classification.rightReqIssues, classification.rightSubTaskIssues);
            if (targetReqLink == null || !this.tryAddIssue(processedIssues, targetReqLink, targetIssue.getRecentId())) continue;
            this.incrementCountV2(result, targetReqLink, targetIssue.getAssignee(), IssueSort.LINKEDISSUE);
        }
    }

    @Generated
    public AnalysisScopeImpl(EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper) {
        this.esCommonRepositoryWrapper = esCommonRepositoryWrapper;
    }
}

