/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.issue.almapi.model.dto;

import com.arms.api.issue.almapi.model.dto.AlmIssueValid;
import com.arms.api.issue.almapi.model.dto.AlmIssueWithRequirementDTO;
import com.arms.api.issue.almapi.model.dto.CReqProperty;
import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AlmIssueValid
public class AlmIssueWithRequirementDTO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlmIssueWithRequirementDTO.class);
    private String jiraServerId;
    private String cTitle;
    private Long cReqStatusId;
    private String issueKey;
    private String projectKeyOrId;
    private Long serviceId;
    private List<Long> versions;
    private Long cReqLink;
    private CReqProperty cReqProperty;

    public String recentId() {
        return this.jiraServerId + "_" + this.projectKeyOrId + "_" + this.issueKey;
    }

    public String extractIssueKeyFromMainKey(String issueKey) {
        return this.jiraServerId + "_" + this.projectKeyOrId + "_" + issueKey;
    }

    public String extractIssueKeyFromMainKey(String projectKey, String issueKey) {
        return this.jiraServerId + "_" + projectKey + "_" + issueKey;
    }

    public AlmIssueWithRequirementDTO(AlmIssueEntity almIssueEntity) {
        this.jiraServerId = almIssueEntity.getJira_server_id();
        this.cReqStatusId = almIssueEntity.getCReqStatusId();
        this.issueKey = almIssueEntity.getKey();
        this.projectKeyOrId = almIssueEntity.getProject().getKey();
        this.serviceId = almIssueEntity.getPdServiceId();
        this.versions = almIssueEntity.getPdServiceVersions();
        this.cReqLink = almIssueEntity.getCReqLink();
        this.cReqProperty = this.getCReqProperty(almIssueEntity);
    }

    public AlmIssueWithRequirementDTO(AlmIssueEntity almIssueEntity, String selfGenIssueKey) {
        this.jiraServerId = almIssueEntity.getJira_server_id();
        this.cReqStatusId = almIssueEntity.getCReqStatusId();
        this.issueKey = selfGenIssueKey;
        this.projectKeyOrId = almIssueEntity.getProject().getKey();
        this.serviceId = almIssueEntity.getPdServiceId();
        this.versions = almIssueEntity.getPdServiceVersions();
        this.cReqLink = almIssueEntity.getCReqLink();
        this.cReqProperty = this.getCReqProperty(almIssueEntity);
    }

    private CReqProperty getCReqProperty(AlmIssueEntity almIssueEntity) {
        AlmIssueEntity.CReqProperty almIssueEntityCReqProperty = almIssueEntity.getCReqProperty();
        if (almIssueEntityCReqProperty == null) {
            return null;
        }
        CReqProperty cReqProperty = new CReqProperty();
        cReqProperty.setCReqPriorityLink(almIssueEntityCReqProperty.getCReqPriorityLink());
        cReqProperty.setCReqPriorityName(almIssueEntityCReqProperty.getCReqPriorityName());
        cReqProperty.setCReqDifficultyLink(almIssueEntityCReqProperty.getCReqDifficultyLink());
        cReqProperty.setCReqDifficultyName(almIssueEntityCReqProperty.getCReqDifficultyName());
        cReqProperty.setCReqStateLink(almIssueEntityCReqProperty.getCReqStateLink());
        cReqProperty.setCReqStateName(almIssueEntityCReqProperty.getCReqStateName());
        return cReqProperty;
    }

    @Generated
    public static AlmIssueWithRequirementDTOBuilder builder() {
        return new AlmIssueWithRequirementDTOBuilder();
    }

    @Generated
    public String getJiraServerId() {
        return this.jiraServerId;
    }

    @Generated
    public String getCTitle() {
        return this.cTitle;
    }

    @Generated
    public Long getCReqStatusId() {
        return this.cReqStatusId;
    }

    @Generated
    public String getIssueKey() {
        return this.issueKey;
    }

    @Generated
    public String getProjectKeyOrId() {
        return this.projectKeyOrId;
    }

    @Generated
    public Long getServiceId() {
        return this.serviceId;
    }

    @Generated
    public List<Long> getVersions() {
        return this.versions;
    }

    @Generated
    public Long getCReqLink() {
        return this.cReqLink;
    }

    @Generated
    public CReqProperty getCReqProperty() {
        return this.cReqProperty;
    }

    @Generated
    public void setJiraServerId(String jiraServerId) {
        this.jiraServerId = jiraServerId;
    }

    @Generated
    public void setCTitle(String cTitle) {
        this.cTitle = cTitle;
    }

    @Generated
    public void setCReqStatusId(Long cReqStatusId) {
        this.cReqStatusId = cReqStatusId;
    }

    @Generated
    public void setIssueKey(String issueKey) {
        this.issueKey = issueKey;
    }

    @Generated
    public void setProjectKeyOrId(String projectKeyOrId) {
        this.projectKeyOrId = projectKeyOrId;
    }

    @Generated
    public void setServiceId(Long serviceId) {
        this.serviceId = serviceId;
    }

    @Generated
    public void setVersions(List<Long> versions) {
        this.versions = versions;
    }

    @Generated
    public void setCReqLink(Long cReqLink) {
        this.cReqLink = cReqLink;
    }

    @Generated
    public void setCReqProperty(CReqProperty cReqProperty) {
        this.cReqProperty = cReqProperty;
    }

    @Generated
    public AlmIssueWithRequirementDTO(String jiraServerId, String cTitle, Long cReqStatusId, String issueKey, String projectKeyOrId, Long serviceId, List<Long> versions, Long cReqLink, CReqProperty cReqProperty) {
        this.jiraServerId = jiraServerId;
        this.cTitle = cTitle;
        this.cReqStatusId = cReqStatusId;
        this.issueKey = issueKey;
        this.projectKeyOrId = projectKeyOrId;
        this.serviceId = serviceId;
        this.versions = versions;
        this.cReqLink = cReqLink;
        this.cReqProperty = cReqProperty;
    }

    @Generated
    public AlmIssueWithRequirementDTO() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlmIssueWithRequirementDTO)) {
            return false;
        }
        AlmIssueWithRequirementDTO other = (AlmIssueWithRequirementDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$jiraServerId = this.getJiraServerId();
        String other$jiraServerId = other.getJiraServerId();
        if (this$jiraServerId == null ? other$jiraServerId != null : !this$jiraServerId.equals(other$jiraServerId)) {
            return false;
        }
        String this$issueKey = this.getIssueKey();
        String other$issueKey = other.getIssueKey();
        if (this$issueKey == null ? other$issueKey != null : !this$issueKey.equals(other$issueKey)) {
            return false;
        }
        String this$projectKeyOrId = this.getProjectKeyOrId();
        String other$projectKeyOrId = other.getProjectKeyOrId();
        return !(this$projectKeyOrId == null ? other$projectKeyOrId != null : !this$projectKeyOrId.equals(other$projectKeyOrId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AlmIssueWithRequirementDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $jiraServerId = this.getJiraServerId();
        result = result * 59 + ($jiraServerId == null ? 43 : $jiraServerId.hashCode());
        String $issueKey = this.getIssueKey();
        result = result * 59 + ($issueKey == null ? 43 : $issueKey.hashCode());
        String $projectKeyOrId = this.getProjectKeyOrId();
        result = result * 59 + ($projectKeyOrId == null ? 43 : $projectKeyOrId.hashCode());
        return result;
    }
}

