/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.issue.priority.service;

import com.arms.api.issue.priority.model.IssuePriorityDTO;
import com.arms.api.issue.priority.strategy.CloudJiraIssuePriorityStrategy;
import com.arms.api.issue.priority.strategy.IssuePriorityStrategy;
import com.arms.api.issue.priority.strategy.IssuePriorityStrategyFactory;
import com.arms.api.issue.priority.strategy.OnpremiseJiraIssuePriorityStrategy;
import com.arms.api.issue.priority.strategy.OnpremiseRedmineIssuePriorityStrategy;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.model.enums.ServerType;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.api.util.errors.ErrorCode;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IssuePriorityService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IssuePriorityService.class);
    private ServerInfoService ServerInfoService;
    private CloudJiraIssuePriorityStrategy cloudJiraIssuePriorityStrategy;
    private OnpremiseJiraIssuePriorityStrategy onpremiseJiraIssuePriorityStrategy;
    private OnpremiseRedmineIssuePriorityStrategy onpremiseRedmineIssuePriorityStrategy;

    @Autowired
    public IssuePriorityService(ServerInfoService ServerInfoService2, CloudJiraIssuePriorityStrategy cloudJiraIssuePriorityStrategy, OnpremiseJiraIssuePriorityStrategy onpremiseJiraIssuePriorityStrategy, OnpremiseRedmineIssuePriorityStrategy onpremiseRedmineIssuePriorityStrategy) {
        this.ServerInfoService = ServerInfoService2;
        this.cloudJiraIssuePriorityStrategy = cloudJiraIssuePriorityStrategy;
        this.onpremiseJiraIssuePriorityStrategy = onpremiseJiraIssuePriorityStrategy;
        this.onpremiseRedmineIssuePriorityStrategy = onpremiseRedmineIssuePriorityStrategy;
    }

    private IssuePriorityStrategyFactory settingIssuePriorityStrategy(ServerInfo serverInfo) {
        CloudJiraIssuePriorityStrategy issuePriorityStrategy;
        if (serverInfo == null || serverInfo.getType().isEmpty()) {
            log.error("settingIssuePriorityStrategy Error: serverInfo_\uc720\ud615 {}", (Object)ErrorCode.SERVER_TYPE_INFO_ERROR.getErrorMsg(new Object[0]));
            throw new IllegalArgumentException("settingIssuePriorityStrategy Error: serverInfo_\uc720\ud615 " + ErrorCode.SERVER_TYPE_INFO_ERROR.getErrorMsg(new Object[0]));
        }
        ServerType serverType = ServerType.typeValueOf((String)serverInfo.getType());
        if (serverType == ServerType.CLOUD) {
            issuePriorityStrategy = this.cloudJiraIssuePriorityStrategy;
        } else if (serverType == ServerType.ON_PREMISS) {
            issuePriorityStrategy = this.onpremiseJiraIssuePriorityStrategy;
        } else if (serverType == ServerType.REDMINE_ON_PREMISS) {
            issuePriorityStrategy = this.onpremiseRedmineIssuePriorityStrategy;
        } else {
            throw new IllegalArgumentException("settingIssuePriorityStrategy Error: \ud5c8\uc6a9\ud558\uc9c0 \uc54a\ub294 serverInfo_\uc720\ud615\uc785\ub2c8\ub2e4. :: " + String.valueOf(serverType) + " :: " + ErrorCode.SERVER_TYPE_INFO_ERROR.getErrorMsg(new Object[0]));
        }
        IssuePriorityStrategyFactory issuePriorityStrategyFactory = new IssuePriorityStrategyFactory();
        issuePriorityStrategyFactory.registerIssuePriorityStrategy((IssuePriorityStrategy)issuePriorityStrategy);
        return issuePriorityStrategyFactory;
    }

    public List<IssuePriorityDTO> getIssuePriorityList(String connectId) {
        ServerInfo serverInfo = this.ServerInfoService.verifyServerInfo(connectId);
        IssuePriorityStrategyFactory issuePriorityStrategy = this.settingIssuePriorityStrategy(serverInfo);
        List issuePriorityList = issuePriorityStrategy.getIssuePriorityList(serverInfo);
        return issuePriorityList;
    }

    @Generated
    public IssuePriorityService() {
    }
}

