/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.issue.priority.strategy;

import com.arms.api.issue.priority.model.IssuePriorityDTO;
import com.arms.api.issue.priority.model.OnpremiseRedmineIssuePriorityDTO;
import com.arms.api.issue.priority.strategy.IssuePriorityStrategy;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.api.util.alm.RedmineApi;
import com.arms.api.util.alm.RedmineUtil;
import com.arms.api.util.errors.ErrorLogUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClient;

@Component
public class OnpremiseRedmineIssuePriorityStrategy
implements IssuePriorityStrategy {
    private final RedmineUtil redmineUtil;
    private final RedmineApi redmineApi;
    private final ServerInfoService serverInfoService;

    public List<IssuePriorityDTO> getIssuePriorityList(ServerInfo serverInfo) {
        WebClient webClient = RedmineUtil.createRedmineWebClientCommunicator((String)serverInfo.getUri(), (String)this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
        String endpoint = this.redmineApi.getEndpoint().getPriorityList();
        try {
            OnpremiseRedmineIssuePriorityDTO redmineIssuePriorityDTO = (OnpremiseRedmineIssuePriorityDTO)this.redmineUtil.get(webClient, endpoint, OnpremiseRedmineIssuePriorityDTO.class).block();
            return Optional.ofNullable(redmineIssuePriorityDTO).map(OnpremiseRedmineIssuePriorityDTO::getIssue_priorities).orElseGet(Collections::emptyList).stream().filter(Objects::nonNull).filter(OnpremiseRedmineIssuePriorityDTO.IssuePriority::isActive).map(issuePriority -> this.convertIssuePriorityDTO(issuePriority, serverInfo.getUri())).collect(Collectors.toList());
        }
        catch (Exception e) {
            String errorMessage = ErrorLogUtil.exceptionLoggingAndReturn((Exception)e, (String)this.getClass().getName(), (String)String.format("%s[%s] :: getIssuePriorityList Error", serverInfo.getType(), serverInfo.getUri()));
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private IssuePriorityDTO convertIssuePriorityDTO(OnpremiseRedmineIssuePriorityDTO.IssuePriority issuePriority, String serverInfoPath) {
        IssuePriorityDTO IssuePriorityDTO2 = new IssuePriorityDTO();
        IssuePriorityDTO2.setId(String.valueOf(issuePriority.getId()));
        IssuePriorityDTO2.setName(issuePriority.getName());
        IssuePriorityDTO2.setDefault(issuePriority.is_default());
        IssuePriorityDTO2.setSelf(this.redmineUtil.checkServerInfoPath(serverInfoPath) + this.redmineApi.replaceID(this.redmineApi.getEndpoint().getPriority(), String.valueOf(issuePriority.getId())));
        return IssuePriorityDTO2;
    }

    @Generated
    public OnpremiseRedmineIssuePriorityStrategy(RedmineUtil redmineUtil, RedmineApi redmineApi, ServerInfoService serverInfoService) {
        this.redmineUtil = redmineUtil;
        this.redmineApi = redmineApi;
        this.serverInfoService = serverInfoService;
    }
}

