/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.project.strategy;

import com.arms.api.project.dto.ProjectDTO;
import com.arms.api.project.strategy.ProjectStrategy;
import com.arms.api.project.vo.ProjectVO;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.api.util.alm.JiraApi;
import com.arms.api.util.alm.JiraUtil;
import com.arms.api.util.errors.ErrorLogUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClient;

@Component
public class CloudJiraProjectStrategy
implements ProjectStrategy {
    private final JiraUtil jiraUtil;
    private final JiraApi jiraApi;
    private final ServerInfoService serverInfoService;

    public ProjectVO getProject(ServerInfo serverInfo, String projectKeyOrId) {
        String endpoint = this.jiraApi.getEndpoint().getProject() + "/" + projectKeyOrId;
        WebClient webClient = this.jiraUtil.createJiraCloudCommunicator(serverInfo.getUri(), serverInfo.getUserId(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
        try {
            ProjectDTO projectDTO = (ProjectDTO)this.jiraUtil.get(webClient, endpoint, ProjectDTO.class).block();
            return this.convertProjectVO(projectDTO);
        }
        catch (Exception e) {
            String errorMessage = ErrorLogUtil.exceptionLoggingAndReturn((Exception)e, (String)this.getClass().getName(), (String)String.format("%s[%s] :: getProject Error \ud504\ub85c\uc81d\ud2b8[%s] ", serverInfo.getType(), serverInfo.getUri(), projectKeyOrId));
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public List<ProjectVO> getProjectList(ServerInfo serverInfo) {
        String endpoint = this.jiraApi.getEndpoint().getProject();
        WebClient webClient = this.jiraUtil.createJiraCloudCommunicator(serverInfo.getUri(), serverInfo.getUserId(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
        try {
            List projectList = (List)this.jiraUtil.get(webClient, endpoint, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).block();
            return Optional.ofNullable(projectList).orElse(Collections.emptyList()).stream().filter(Objects::nonNull).map(arg_0 -> this.convertProjectVO(arg_0)).collect(Collectors.toList());
        }
        catch (Exception e) {
            String errorMessage = ErrorLogUtil.exceptionLoggingAndReturn((Exception)e, (String)this.getClass().getName(), (String)String.format("%s[%s] :: getProjectList Error", serverInfo.getType(), serverInfo.getUri()));
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private ProjectVO convertProjectVO(ProjectDTO projectDTO) {
        return ProjectVO.builder().id(projectDTO.getId()).key(projectDTO.getKey()).name(projectDTO.getName()).self(projectDTO.getSelf()).build();
    }

    @Generated
    public CloudJiraProjectStrategy(JiraUtil jiraUtil, JiraApi jiraApi, ServerInfoService serverInfoService) {
        this.jiraUtil = jiraUtil;
        this.jiraApi = jiraApi;
        this.serverInfoService = serverInfoService;
    }
}

