/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.util.aes;

import com.arms.api.util.aes.AESProperty;
import jakarta.annotation.PostConstruct;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class AES256 {
    private final AESProperty aesProperty;
    private String key;
    private static final int IV_SIZE = 12;
    private static final int TAG_LENGTH_BIT = 128;
    private static final String TRANSFORMATION = "AES/GCM/NoPadding";

    private AES256(AESProperty aesProperty) {
        this.aesProperty = aesProperty;
    }

    @PostConstruct
    public void init() {
        this.key = this.aesProperty.getToken();
    }

    private Key getAESKey() {
        byte[] keyBytes = new byte[32];
        byte[] b = this.key.getBytes(StandardCharsets.UTF_8);
        System.arraycopy(b, 0, keyBytes, 0, Math.min(b.length, keyBytes.length));
        return new SecretKeySpec(keyBytes, "AES");
    }

    private byte[] generateRandomIV() {
        byte[] iv = new byte[12];
        new SecureRandom().nextBytes(iv);
        return iv;
    }

    public String encrypt(String plainText) {
        try {
            if (ObjectUtils.isEmpty((Object)this.key)) {
                return plainText;
            }
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            byte[] iv = this.generateRandomIV();
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv);
            cipher.init(1, this.getAESKey(), gcmParameterSpec);
            byte[] encrypted = cipher.doFinal(plainText.getBytes(StandardCharsets.UTF_8));
            byte[] combined = new byte[12 + encrypted.length];
            System.arraycopy(iv, 0, combined, 0, 12);
            System.arraycopy(encrypted, 0, combined, 12, encrypted.length);
            return Base64.encodeBase64String((byte[])combined);
        }
        catch (Exception e) {
            throw new RuntimeException("[AES256 :: encrypt] :: \uc554\ud638\ud654 \uc911 \uc624\ub958 \ubc1c\uc0dd", e);
        }
    }

    public String decrypt(String encryptedText) {
        try {
            if (ObjectUtils.isEmpty((Object)this.key)) {
                return encryptedText;
            }
            byte[] decodedBytes = Base64.decodeBase64((String)encryptedText);
            byte[] iv = Arrays.copyOfRange(decodedBytes, 0, 12);
            byte[] cipherText = Arrays.copyOfRange(decodedBytes, 12, decodedBytes.length);
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv);
            cipher.init(2, this.getAESKey(), gcmParameterSpec);
            return new String(cipher.doFinal(cipherText), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException("[AES256 :: decrypt] :: \ubcf5\ud638\ud654 \uc911 \uc624\ub958 \ubc1c\uc0dd", e);
        }
    }
}

