/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.util.alm;

import com.arms.api.issue.almapi.model.vo.CloudJiraIssues;
import com.arms.api.issue.almapi.model.vo.cloudjiraspec.CloudJiraIssueRawDataVO;
import com.arms.api.util.alm.JiraApi;
import com.arms.api.util.alm.dto.CloudJiraIssueCreationFieldMetadata;
import com.arms.api.util.errors.ErrorLogUtil;
import com.arms.api.util.exception.Retryable429Exception;
import com.arms.api.util.response.CommonResponse;
import com.arms.config.WebClientBuilder;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.internal.async.AsynchronousJiraRestClientFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

@Component
public class JiraUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JiraUtil.class);
    private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(30L);
    private final JiraApi jiraApi;
    private final WebClientBuilder webClientBuilder;

    public WebClient createJiraCloudCommunicator(String uri, String email, String apiToken) {
        return this.webClientBuilder.builder().baseUrl(uri).defaultHeader("Content-Type", new String[]{"application/json"}).defaultHeader("Accept", new String[]{"application/json"}).defaultHeader("Authorization", new String[]{"Basic " + this.getBase64Credentials(email, apiToken)}).build();
    }

    public JiraRestClient createJiraOnPremiseCommunicator(String jiraUrl, String jiraID, String jiraPass) {
        AsynchronousJiraRestClientFactory factory = new AsynchronousJiraRestClientFactory();
        try {
            return factory.createWithBasicHttpAuthentication(new URI(jiraUrl), jiraID, jiraPass);
        }
        catch (URISyntaxException e) {
            String errorMessage = ErrorLogUtil.exceptionLoggingAndReturn((Exception)e, (String)this.getClass().getName(), (String)String.format("%s :: [%s] :: \uc628\ud504\ub808\ubbf8\uc2a4_\ud1b5\uc2e0\uae30_\uc0dd\uc131 \uc911 \uc624\ub958", jiraUrl, jiraID));
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private String getBase64Credentials(String jiraID, String jiraPass) {
        String credentials = jiraID + ":" + jiraPass;
        return new String(Base64.getEncoder().encode(credentials.getBytes()));
    }

    public <T> Mono<T> get(WebClient webClient, String uri, Class<T> responseType) {
        return webClient.get().uri(uri, new Object[0]).retrieve().bodyToMono(responseType);
    }

    public <T> Mono<T> get(WebClient webClient, String uri, ParameterizedTypeReference<T> elementTypeRef) {
        return webClient.get().uri(uri, new Object[0]).retrieve().bodyToMono(elementTypeRef);
    }

    public <T> T getWithRawData(WebClient webClient, String uri, Class<T> responseType) {
        try {
            log.info("cloud request uri:{}", (Object)uri);
            String rawData = (String)webClient.get().uri(uri, new Object[0]).exchangeToMono(response -> {
                if (response.statusCode().value() == 429) {
                    String retryAfter = response.headers().asHttpHeaders().getFirst("Retry-After");
                    long delay = retryAfter != null ? Long.parseLong(retryAfter) : 3L;
                    log.warn("429 error, retry after {} seconds", (Object)delay);
                    return Mono.error((Throwable)new Retryable429Exception(delay));
                }
                return response.bodyToMono(String.class);
            }).retryWhen((Retry)Retry.max((long)5L).filter(ex -> ex instanceof Retryable429Exception).doBeforeRetry(signal -> {
                long delay = ((Retryable429Exception)signal.failure()).getDelaySeconds();
                try {
                    Thread.sleep(delay * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            })).block(DEFAULT_TIMEOUT);
            if (rawData == null) {
                throw new RuntimeException("WebClient \ud638\ucd9c \uacb0\uacfc\uac00 null\uc785\ub2c8\ub2e4.");
            }
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            Object mappedData = objectMapper.readValue(rawData, responseType);
            if (mappedData instanceof CloudJiraIssueRawDataVO) {
                ((CloudJiraIssueRawDataVO)mappedData).applyRawData(rawData);
            } else if (mappedData instanceof CloudJiraIssues) {
                CloudJiraIssues \uc870\ud68c_\ub370\uc774\ud130 = (CloudJiraIssues)mappedData;
                JsonNode rootNode = objectMapper.readTree(rawData);
                JsonNode issuesNode = rootNode.get("issues");
                if (issuesNode != null && \uc870\ud68c_\ub370\uc774\ud130.getIssues() != null) {
                    for (int i = 0; i < \uc870\ud68c_\ub370\uc774\ud130.getIssues().size(); ++i) {
                        CloudJiraIssueRawDataVO issue = (CloudJiraIssueRawDataVO)\uc870\ud68c_\ub370\uc774\ud130.getIssues().get(i);
                        String issueRawData = issuesNode.get(i).toString();
                        issue.applyRawData(issueRawData);
                    }
                }
            }
            return (T)mappedData;
        }
        catch (Exception e) {
            log.error("ROW DATA JSON \ub9e4\ud551 \uc911 \uc624\ub958 \ubc1c\uc0dd: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("ROW DATA JSON \ub9e4\ud551 \uc911 \uc624\ub958 \ubc1c\uc0dd", e);
        }
    }

    public <T> Mono<T> post(WebClient webClient, String uri, Object requestBody, Class<T> responseType) {
        return ((WebClient.RequestBodySpec)webClient.post().uri(uri, new Object[0])).body(BodyInserters.fromValue((Object)requestBody)).retrieve().bodyToMono(responseType);
    }

    public <T> Mono<T> put(WebClient webClient, String uri, Object requestBody, Class<T> responseType) {
        return ((WebClient.RequestBodySpec)webClient.put().uri(uri, new Object[0])).body(BodyInserters.fromValue((Object)requestBody)).retrieve().bodyToMono(responseType);
    }

    public <T> Mono<T> delete(WebClient webClient, String uri, Class<T> responseType) {
        return webClient.delete().uri(uri, new Object[0]).retrieve().bodyToMono(responseType);
    }

    public CommonResponse.ApiResult<?> executePost(WebClient webClient, String uri, Object requestBody) {
        Mono response = ((WebClient.RequestBodySpec)webClient.post().uri(uri, new Object[0])).body(BodyInserters.fromValue((Object)requestBody)).retrieve().toEntity(Void.class);
        return (CommonResponse.ApiResult)response.map(entity -> {
            if (entity.getStatusCode() == HttpStatus.NO_CONTENT) {
                return CommonResponse.success((Object)"OK");
            }
            return CommonResponse.error((String)"Fail", (HttpStatus)HttpStatus.BAD_REQUEST);
        }).onErrorResume(WebClientResponseException.class, e -> Mono.just((Object)CommonResponse.error((Throwable)e, (HttpStatusCode)e.getStatusCode()))).onErrorResume(Exception.class, e -> Mono.just((Object)CommonResponse.error((Throwable)e, (HttpStatus)HttpStatus.BAD_REQUEST))).block(DEFAULT_TIMEOUT);
    }

    public CommonResponse.ApiResult<?> executePut(WebClient webClient, String uri, Object requestBody) {
        Mono response = ((WebClient.RequestBodySpec)webClient.put().uri(uri, new Object[0])).body(BodyInserters.fromValue((Object)requestBody)).retrieve().toEntity(Void.class);
        return (CommonResponse.ApiResult)response.map(entity -> {
            if (entity.getStatusCode() == HttpStatus.NO_CONTENT) {
                return CommonResponse.success((Object)"OK");
            }
            return CommonResponse.error((String)"Fail", (HttpStatus)HttpStatus.BAD_REQUEST);
        }).onErrorResume(WebClientResponseException.class, e -> Mono.just((Object)CommonResponse.error((Throwable)e, (HttpStatusCode)e.getStatusCode()))).onErrorResume(Exception.class, e -> Mono.just((Object)CommonResponse.error((Throwable)e, (HttpStatus)HttpStatus.BAD_REQUEST))).block(DEFAULT_TIMEOUT);
    }

    public CommonResponse.ApiResult<?> executeDelete(WebClient webClient, String uri) {
        Mono response = webClient.delete().uri(uri, new Object[0]).retrieve().toEntity(Void.class);
        return (CommonResponse.ApiResult)response.map(entity -> {
            if (entity.getStatusCode() == HttpStatus.NO_CONTENT) {
                return CommonResponse.success((Object)"OK");
            }
            return CommonResponse.error((String)"Fail", (HttpStatus)HttpStatus.BAD_REQUEST);
        }).onErrorResume(WebClientResponseException.class, e -> Mono.just((Object)CommonResponse.error((Throwable)e, (HttpStatusCode)e.getStatusCode()))).onErrorResume(Exception.class, e -> Mono.just((Object)CommonResponse.error((Throwable)e, (HttpStatus)HttpStatus.BAD_REQUEST))).block(DEFAULT_TIMEOUT);
    }

    public Map<String, CloudJiraIssueCreationFieldMetadata.FieldMetadata> checkFieldMetadata(WebClient webClient, String \ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514, String \uc774\uc288\uc720\ud615_\uc544\uc774\ub514) {
        String \ud544\ub4dc\ud655\uc778endpoint = this.jiraApi.\ud504\ub85c\uc81d\ud2b8\ud0a4_\ub300\uccb4\ud558\uae30(this.jiraApi.getEndpoint().getIssue().getCreatemeta(), \ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514);
        \ud544\ub4dc\ud655\uc778endpoint = this.jiraApi.\uc774\uc288\uc720\ud615\ud0a4_\ub300\uccb4\ud558\uae30(\ud544\ub4dc\ud655\uc778endpoint, \uc774\uc288\uc720\ud615_\uc544\uc774\ub514);
        int \uac80\uc0c9_\uc2dc\uc791_\uc9c0\uc810 = 0;
        int \ucd5c\ub300_\uac80\uc0c9\uc218 = this.jiraApi.getParameter().getMaxResults();
        boolean isLast = false;
        ArrayList \uba54\ud0c0\ub370\uc774\ud130_\ubaa9\ub85d = new ArrayList();
        try {
            while (!isLast) {
                String endpoint = \ud544\ub4dc\ud655\uc778endpoint + "?startAt=" + \uac80\uc0c9_\uc2dc\uc791_\uc9c0\uc810 + "&maxResults=" + \ucd5c\ub300_\uac80\uc0c9\uc218;
                CloudJiraIssueCreationFieldMetadata cloudJiraIssueCreationFieldMetadata = (CloudJiraIssueCreationFieldMetadata)this.get(webClient, endpoint, CloudJiraIssueCreationFieldMetadata.class).block(DEFAULT_TIMEOUT);
                if (cloudJiraIssueCreationFieldMetadata == null) {
                    log.info("\ud074\ub77c\uc6b0\ub4dc \uc9c0\ub77c \ud074\ub77c\uc6b0\ub4dc \ud504\ub85c\uc81d\ud2b8 : {}, \uc774\uc288\uc720\ud615 : {}, \uc774\uc288\uc0dd\uc131\ud544\ub4dc_\uba54\ud0c0\ub370\uc774\ud130 \ubaa9\ub85d\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.", (Object)\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514, (Object)\uc774\uc288\uc720\ud615_\uc544\uc774\ub514);
                    return null;
                }
                if (cloudJiraIssueCreationFieldMetadata.getFields() == null || cloudJiraIssueCreationFieldMetadata.getFields().isEmpty()) {
                    log.info("\ud074\ub77c\uc6b0\ub4dc \uc9c0\ub77c \ud074\ub77c\uc6b0\ub4dc \ud504\ub85c\uc81d\ud2b8 : {}, \uc774\uc288\uc720\ud615 : {}, \uc774\uc288\uc0dd\uc131\ud544\ub4dc_\uba54\ud0c0\ub370\uc774\ud130 \ubaa9\ub85d\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.", (Object)\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514, (Object)\uc774\uc288\uc720\ud615_\uc544\uc774\ub514);
                    return null;
                }
                \uba54\ud0c0\ub370\uc774\ud130_\ubaa9\ub85d.addAll(cloudJiraIssueCreationFieldMetadata.getFields());
                if (cloudJiraIssueCreationFieldMetadata.getTotal().intValue() == \uba54\ud0c0\ub370\uc774\ud130_\ubaa9\ub85d.size()) {
                    isLast = true;
                    continue;
                }
                \uac80\uc0c9_\uc2dc\uc791_\uc9c0\uc810 += \ucd5c\ub300_\uac80\uc0c9\uc218;
            }
        }
        catch (Exception e) {
            log.error("\ud074\ub77c\uc6b0\ub4dc \uc9c0\ub77c \ud504\ub85c\uc81d\ud2b8 : {}, \uc774\uc288\uc720\ud615 : {}, \uc774\uc288\uc0dd\uc131\ud544\ub4dc_\uba54\ud0c0\ub370\uc774\ud130 \ud655\uc778\ud558\uae30 \uc911 \uc624\ub958", (Object)\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514, (Object)\uc774\uc288\uc720\ud615_\uc544\uc774\ub514);
            String \uc5d0\ub7ec\ub85c\uadf8 = ErrorLogUtil.exceptionLoggingAndReturn((Exception)e, (String)this.getClass().getName(), (String)"\ud544\ub4dc_\uba54\ud0c0\ub370\uc774\ud130 \ud655\uc778\ud558\uae30");
            throw new IllegalArgumentException(\uc5d0\ub7ec\ub85c\uadf8 + "\n\ud544\ub4dc \uba54\ud0c0\ub370\uc774\ud130 \uc870\ud68c \uc911 \uc624\ub958 :: \ud504\ub85c\uc81d\ud2b8 :: " + \ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514 + " :: \uc774\uc288 \uc720\ud615 :: " + \uc774\uc288\uc720\ud615_\uc544\uc774\ub514 + " :: \uc5d0\ub7ec \uba54\uc138\uc9c0 :: " + \uc5d0\ub7ec\ub85c\uadf8);
        }
        Map<String, CloudJiraIssueCreationFieldMetadata.FieldMetadata> \ud544\ub4dc\ub9f5 = \uba54\ud0c0\ub370\uc774\ud130_\ubaa9\ub85d.stream().collect(Collectors.toMap(CloudJiraIssueCreationFieldMetadata.FieldMetadata::getFieldId, field -> field));
        return \ud544\ub4dc\ub9f5;
    }

    public LocalDate getNextDate(String dateString) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate date = LocalDate.parse(dateString, formatter);
        return date.plusDays(1L);
    }

    @Generated
    public JiraUtil(JiraApi jiraApi, WebClientBuilder webClientBuilder) {
        this.jiraApi = jiraApi;
        this.webClientBuilder = webClientBuilder;
    }
}

