/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.util.response;

import com.arms.api.util.errors.ErrorCode;
import com.arms.api.util.response.CommonResponse;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;

public class CommonResponse {
    private CommonResponse() {
    }

    public static <T> ApiResult<T> success(T response) {
        return new ApiResult(true, response, null);
    }

    public static ApiResult<?> error(Throwable throwable, HttpStatusCode status) {
        return new ApiResult(false, null, new ApiError(throwable, status));
    }

    public static ApiResult<?> error(Throwable throwable, HttpStatus status) {
        return new ApiResult(false, null, new ApiError(throwable, status));
    }

    public static ApiResult<?> error(String message, HttpStatus status) {
        return new ApiResult(false, null, new ApiError(message, status));
    }

    public static ApiResult<?> error(ErrorCode errorCode, HttpStatus status) {
        return new ApiResult(false, null, new ApiError(errorCode, status));
    }

    public static ApiResult<?> error(String message, ErrorCode errorCode, HttpStatus status) {
        return new ApiResult(false, null, new ApiError(message, errorCode, status));
    }
}

