/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.kafka.reqadd.service;

import com.arms.api.kafka.reqadd.model.ReqAddDTO;
import com.arms.api.kafka.reqadd.model.ReqAddResponseVO;
import com.arms.api.util.redisrepo.CustomRedisTemplate;
import com.arms.util.DataSerializer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.concurrent.ListenableFuture;

@Service
public class ReqAddService {
    private static final Logger log = LoggerFactory.getLogger(ReqAddService.class);
    private static final String ALM_ISSUE_TOPIC = "REQADD";
    private static final String REQUIREMENT_KEY_FORMAT = "requirement:%s:%s:%s";
    private final KafkaTemplate<String, String> kafkaTemplate;
    private final AdminClient adminClient;

    public ReqAddService(@Qualifier(value="customRedisTemplateImpl") CustomRedisTemplate customRedisTemplate, KafkaTemplate<String, String> kafkaTemplate, AdminClient adminClient) {
        this.kafkaTemplate = kafkaTemplate;
        this.adminClient = adminClient;
    }

    private String generateRequirementKey(String tableName, String type, String uuid) {
        return String.format(REQUIREMENT_KEY_FORMAT, tableName, type, uuid);
    }

    public List<ReqAddResponseVO> read() {
        log.info("Reading requirements");
        ArrayList<ReqAddResponseVO> responses = new ArrayList<ReqAddResponseVO>();
        return responses;
    }

    public void create(String tableName, ReqAddDTO reqAddDTO) {
        this.hasTopic();
        String uuid = UUID.randomUUID().toString();
        String requirementKey = this.generateRequirementKey(tableName, "CREATE", uuid);
        String jsonString = DataSerializer.serialize((Object)reqAddDTO);
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("payload", jsonString);
        value.put("status", "READY");
        value.put("createdAt", Instant.now().toString());
        ListenableFuture future = this.kafkaTemplate.send(ALM_ISSUE_TOPIC, (Object)requirementKey, (Object)jsonString);
        future.addCallback(result -> log.info("Successfully sent message"), ex -> log.error("Failed to send message", ex));
    }

    public boolean update(String tableName, String payload) {
        this.hasTopic();
        String uuid = UUID.randomUUID().toString();
        String requirementKey = this.generateRequirementKey(tableName, "UPDATE", uuid);
        this.kafkaTemplate.send(ALM_ISSUE_TOPIC, (Object)requirementKey, (Object)payload);
        return true;
    }

    public boolean delete(String tableName, String payload) {
        this.hasTopic();
        String uuid = UUID.randomUUID().toString();
        String requirementKey = this.generateRequirementKey(tableName, "DELETE", uuid);
        this.kafkaTemplate.send(ALM_ISSUE_TOPIC, (Object)requirementKey, (Object)payload);
        return true;
    }

    private void hasTopic() {
        if (!this.topicExists(ALM_ISSUE_TOPIC)) {
            this.createTopic(ALM_ISSUE_TOPIC);
            log.info("Created new topic: {}", (Object)ALM_ISSUE_TOPIC);
        }
    }

    private boolean topicExists(String topicName) {
        try {
            Set topics = (Set)this.adminClient.listTopics().names().get();
            return topics.contains(topicName);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("Thread interrupted while checking topic existence: {}", (Object)topicName, (Object)e);
            return false;
        }
        catch (Exception e) {
            log.error("Failed to check topic existence: {}", (Object)topicName, (Object)e);
            return false;
        }
    }

    private void createTopic(String topicName) {
        try {
            NewTopic newTopic = new NewTopic(topicName, 1, 1);
            this.adminClient.createTopics(Collections.singleton(newTopic)).all().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("Thread interrupted while creating topic: {}", (Object)topicName, (Object)e);
        }
        catch (Exception e) {
            log.error("Failed to create topic: {}", (Object)topicName, (Object)e);
        }
    }
}

