/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.keycloak.user.service;

import com.arms.api.keycloak.user.service.KeycloakUserService;
import java.util.List;
import java.util.Map;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.springframework.stereotype.Service;

@Service
public class KeycloakUserServiceImpl
implements KeycloakUserService {
    private final RealmResource realmResource;
    private final String ADMIN = "ROLE_ADMIN";

    private Boolean checkRolePermission(String userId, String currentPage) {
        List roleRepresentations = this.realmResource.users().get(userId).roles().realmLevel().listEffective(false);
        for (RoleRepresentation roleRepresentation : roleRepresentations) {
            Map attributes = roleRepresentation.getAttributes();
            if ("ROLE_ADMIN".equals(roleRepresentation.getName())) {
                return true;
            }
            if (attributes == null || !attributes.containsKey(currentPage)) continue;
            return true;
        }
        return false;
    }

    private Boolean checkUserPermission(String userId, String currentPage) {
        UserRepresentation userRepresentation = this.realmResource.users().get(userId).toRepresentation();
        Map attributes = userRepresentation.getAttributes();
        if (attributes != null && attributes.containsKey(currentPage)) {
            return true;
        }
        return false;
    }

    private Boolean checkGroupPermission(String userId, String currentPage) {
        List groupRepresentations = this.realmResource.users().get(userId).groups();
        for (GroupRepresentation groupRepresentation : groupRepresentations) {
            GroupRepresentation group = this.realmResource.groups().group(groupRepresentation.getId()).toRepresentation();
            Map attributes = group.getAttributes();
            if (attributes == null || !attributes.containsKey(currentPage)) continue;
            return true;
        }
        return false;
    }

    public Boolean ckeckPermissions(String userId, String currentPage) {
        Boolean rolePermission = this.checkRolePermission(userId, currentPage);
        if (!rolePermission.booleanValue()) {
            Boolean userPermission = this.checkUserPermission(userId, currentPage);
            if (!userPermission.booleanValue()) {
                return this.checkGroupPermission(userId, currentPage);
            }
            return true;
        }
        return true;
    }

    public KeycloakUserServiceImpl(RealmResource realmResource) {
        this.realmResource = realmResource;
    }
}

