/*
 * Decompiled with CFR 0.152.
 */
package com.arms.config.filter;

import com.arms.config.filter.BlockRequestGatewayFilter;
import com.arms.config.filter.PermitUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.stereotype.Component;

@Component
public class BlockRequestGatewayFilter
extends AbstractGatewayFilterFactory<Config> {
    private static final Logger log = LoggerFactory.getLogger(BlockRequestGatewayFilter.class);
    private final PermitUrl permitUrl;

    public BlockRequestGatewayFilter(PermitUrl permitUrl) {
        super(Config.class);
        this.permitUrl = permitUrl;
    }

    public GatewayFilter apply(Config config) {
        return (exchange, chain) -> {
            String path = exchange.getRequest().getURI().getPath();
            boolean isPermitted = false;
            for (String permitUrl : this.permitUrl.getUrls()) {
                if (!path.contains(permitUrl)) continue;
                isPermitted = true;
                break;
            }
            if (!isPermitted) {
                return exchange.getResponse().setComplete();
            }
            return chain.filter(exchange);
        };
    }

    public String name() {
        return "BlockRequestGatewayFilter";
    }
}

