/*
 * Decompiled with CFR 0.152.
 */
package com.arms.config.interceptor;

import java.net.URI;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@RefreshScope
public class LoginErrorFilter
implements WebFilter {
    @Value(value="${spring.security.auth.success.redirect-url}")
    private String redirectUrl;

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        String requestPath = exchange.getRequest().getURI().getPath();
        if ("/login".equals(requestPath) && exchange.getRequest().getQueryParams().containsKey((Object)"error")) {
            exchange.getResponse().setStatusCode(HttpStatus.FOUND);
            exchange.getResponse().getHeaders().setLocation(URI.create(this.redirectUrl));
            return Mono.empty();
        }
        return chain.filter(exchange);
    }
}

