/*
 * Decompiled with CFR 0.152.
 */
package com.arms.config;

import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;
import org.keycloak.admin.client.resource.RealmResource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@RefreshScope
public class KeycloakConfig {
    @Value(value="${spring.security.oauth2.client.registration.middle-proxy.realm}")
    private String realm;
    @Value(value="${spring.security.oauth2.client.registration.middle-proxy.server-url}")
    private String serverUrl;
    @Value(value="${spring.security.oauth2.client.registration.middle-proxy.client-id}")
    private String clientId;
    @Value(value="${spring.security.oauth2.client.registration.middle-proxy.client-secret}")
    private String clientSecret;

    @Bean
    public Keycloak keycloak() {
        return KeycloakBuilder.builder().serverUrl(this.serverUrl).realm(this.realm).grantType("client_credentials").clientId(this.clientId).clientSecret(this.clientSecret).build();
    }

    @Bean
    public RealmResource realmResource(Keycloak keycloak) {
        return keycloak.realm(this.realm);
    }
}

