/*
 * Decompiled with CFR 0.152.
 */
package com.arms.config;

import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
public class RedisConfig {
    private static final Logger logger = LoggerFactory.getLogger(RedisConfig.class);
    @Value(value="${spring.redis.host}")
    private String redisHost;
    @Value(value="${spring.redis.port}")
    private int redisPort;
    @Value(value="${spring.redis.ssl.enabled:false}")
    private boolean redisSslEnabled;

    @PostConstruct
    public void logRedisConfig() {
        logger.info("--- Custom RedisConfig Initializing --- Valued Properties ---");
        logger.info("Redis Host from @Value: {}", (Object)this.redisHost);
        logger.info("Redis Port from @Value: {}", (Object)this.redisPort);
        logger.info("Redis SSL Enabled from @Value: {}", (Object)this.redisSslEnabled);
        logger.info("--- End Custom RedisConfig Initializing ---");
    }

    @Bean
    public LettuceConnectionFactory lettuceConnectionFactory() {
        LettuceClientConfiguration clientConfig;
        logger.info("--- Creating LettuceConnectionFactory --- Input Parameters ---");
        logger.info("Using Redis Host: {}", (Object)this.redisHost);
        logger.info("Using Redis Port: {}", (Object)this.redisPort);
        logger.info("Using SSL Enabled: {}", (Object)this.redisSslEnabled);
        logger.info("--- End LettuceConnectionFactory Input Parameters ---");
        RedisStandaloneConfiguration redisStandaloneConfiguration = new RedisStandaloneConfiguration();
        redisStandaloneConfiguration.setHostName(this.redisHost);
        redisStandaloneConfiguration.setPort(this.redisPort);
        if (this.redisSslEnabled) {
            logger.info("LettuceClientConfiguration: SSL ENABLED");
            clientConfig = LettuceClientConfiguration.builder().useSsl().build();
        } else {
            logger.info("LettuceClientConfiguration: SSL DISABLED (default configuration)");
            clientConfig = LettuceClientConfiguration.defaultConfiguration();
        }
        LettuceConnectionFactory lettuceConnectionFactory = new LettuceConnectionFactory(redisStandaloneConfiguration, clientConfig);
        lettuceConnectionFactory.afterPropertiesSet();
        logger.info("LettuceConnectionFactory created and properties set.");
        return lettuceConnectionFactory;
    }

    @Bean
    public RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory connectionFactory) {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(connectionFactory);
        template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setValueSerializer((RedisSerializer)new GenericJackson2JsonRedisSerializer());
        template.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setHashValueSerializer((RedisSerializer)new GenericJackson2JsonRedisSerializer());
        template.afterPropertiesSet();
        return template;
    }

    @Bean
    public StringRedisTemplate stringRedisTemplate(RedisConnectionFactory connectionFactory) {
        StringRedisTemplate template = new StringRedisTemplate();
        template.setConnectionFactory(connectionFactory);
        return template;
    }

    @Bean
    public RedisScript<Boolean> updateContentAndHistoryScript() {
        String luaScript = "    local contentKey = KEYS[1]\n    local historyKey = KEYS[2]\n    local newContent = ARGV[1]\n    local operationJson = ARGV[2] -- Operation passed as JSON string\n\n    redis.call('SET', contentKey, newContent)\n    redis.call('RPUSH', historyKey, operationJson) -- Store the JSON string\n\n    -- Trim the history list if it exceeds the max size\n    local maxHistory = tonumber(ARGV[3])\n    if maxHistory and maxHistory > 0 then\n        local currentSize = redis.call('LLEN', historyKey)\n        if currentSize > maxHistory then\n            redis.call('LTRIM', historyKey, currentSize - maxHistory, -1)\n        end\n    end\n\n    return true\n";
        DefaultRedisScript redisScript = new DefaultRedisScript();
        redisScript.setScriptText(luaScript);
        redisScript.setResultType(Boolean.class);
        return redisScript;
    }
}

