/*
 * Decompiled with CFR 0.152.
 */
package com.arms.egovframework.javaservice.esframework.repository.common;

import com.arms.egovframework.javaservice.esframework.esquery.SimpleQuery;
import com.arms.egovframework.javaservice.esframework.factory.AggregationQueryFactory;
import com.arms.egovframework.javaservice.esframework.factory.SearchDocQueryFactory;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.MainGroupDTO;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SearchDocDTO;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SingleValueGroupDTO;
import com.arms.egovframework.javaservice.esframework.model.entity.BaseEntity;
import com.arms.egovframework.javaservice.esframework.model.vo.CatIndexVO;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentAggregations;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentResultWrapper;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepository;
import com.arms.egovframework.javaservice.esframework.repository.common.FindRepository;
import java.io.Serializable;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.elasticsearch.core.query.Query;

public class EsCommonRepositoryWrapper<E extends BaseEntity> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EsCommonRepositoryWrapper.class);
    private final FindRepository findRepository;
    private final Class<E> entityClass;

    public EsCommonRepositoryWrapper(FindRepository findRepository, Class<E> entityClass) {
        this.entityClass = entityClass;
        this.findRepository = findRepository;
    }

    private EsCommonRepository<E, Serializable> getRepository() {
        return this.findRepository.findRepositoryByClass((Object)this.entityClass);
    }

    public DocumentAggregations aggregateRecentDocs(SimpleQuery<MainGroupDTO> simpleQuery) {
        return this.getRepository().aggregateRecentDocs((Query)AggregationQueryFactory.nested((MainGroupDTO)((MainGroupDTO)simpleQuery.toSearchDoc())).createForRecentTrue(this.entityClass));
    }

    public DocumentAggregations aggregateDocs(SimpleQuery<MainGroupDTO> simpleQuery) {
        return this.getRepository().aggregateDocs((Query)AggregationQueryFactory.nested((MainGroupDTO)((MainGroupDTO)simpleQuery.toSearchDoc())).create());
    }

    public DocumentAggregations aggregateDocsByDay(SimpleQuery<MainGroupDTO> simpleQuery) {
        return this.getRepository().aggregateDocs((Query)AggregationQueryFactory.nestedWithDay((MainGroupDTO)((MainGroupDTO)simpleQuery.toSearchDoc())).create());
    }

    public DocumentAggregations aggregateDocsCardinalityByDay(SimpleQuery<SingleValueGroupDTO> simpleQuery) {
        return this.getRepository().aggregateDocs((Query)AggregationQueryFactory.cardinalityWithDay((SingleValueGroupDTO)((SingleValueGroupDTO)simpleQuery.toSearchDoc())).create());
    }

    public DocumentAggregations aggregateRecentDocsByDay(SimpleQuery<MainGroupDTO> simpleQuery) {
        return this.getRepository().aggregateRecentDocs((Query)AggregationQueryFactory.nestedWithDay((MainGroupDTO)((MainGroupDTO)simpleQuery.toSearchDoc())).createForRecentTrue(this.entityClass));
    }

    public DocumentAggregations aggregateRecentDocsCardinalityByDay(SimpleQuery<SingleValueGroupDTO> simpleQuery) {
        return this.getRepository().aggregateRecentDocs((Query)AggregationQueryFactory.cardinalityWithDay((SingleValueGroupDTO)((SingleValueGroupDTO)simpleQuery.toSearchDoc())).createForRecentTrue(this.entityClass));
    }

    public DocumentAggregations aggregateRecentDocsByWeek(SimpleQuery<MainGroupDTO> simpleQuery) {
        return this.getRepository().aggregateRecentDocs((Query)AggregationQueryFactory.nestedWithWeek((MainGroupDTO)((MainGroupDTO)simpleQuery.toSearchDoc())).createForRecentTrue(this.entityClass));
    }

    public DocumentResultWrapper<E> findRecentHits(SimpleQuery<SearchDocDTO> simpleQuery) {
        return this.getRepository().findRecentHits((Query)SearchDocQueryFactory.searchDoc((SearchDocDTO)simpleQuery.toSearchDoc()).createForRecentTrue(this.entityClass));
    }

    public DocumentResultWrapper<E> findHits(SimpleQuery<SearchDocDTO> simpleQuery) {
        return this.getRepository().findHits((Query)SearchDocQueryFactory.searchDoc((SearchDocDTO)simpleQuery.toSearchDoc()).create());
    }

    public E findRecentDocByRecentId(Serializable serializable) {
        return (E)((BaseEntity)this.getRepository().findRecentDocByRecentId(serializable));
    }

    public <U extends Serializable> E findDocById(U id) {
        return (E)((BaseEntity)this.getRepository().findDocById(id));
    }

    public <U extends Serializable> DocumentResultWrapper<E> findRecentDocById(U id) {
        return this.getRepository().findRecentDocById(id);
    }

    public List<E> findDocsByScrollApi(SimpleQuery<SearchDocDTO> simpleQuery) {
        return this.getRepository().findDocsByScrollApi((Query)SearchDocQueryFactory.searchDoc((SearchDocDTO)simpleQuery.toSearchDoc()).create());
    }

    public List<E> findRecentDocsByScrollApi(SimpleQuery<SearchDocDTO> simpleQuery) {
        return this.getRepository().findRecentDocsByScrollApi((Query)SearchDocQueryFactory.searchDoc((SearchDocDTO)simpleQuery.toSearchDoc()).createForRecentTrue(this.entityClass));
    }

    public DocumentResultWrapper<E> findRecentDocsBySearchAfter(SimpleQuery<SearchDocDTO> simpleQuery) {
        return this.getRepository().findRecentDocsBySearchAfter((Query)SearchDocQueryFactory.searchDoc((SearchDocDTO)simpleQuery.toSearchDoc()).createForRecentTrue(this.entityClass), simpleQuery.toSearchDoc().getSearchAfter());
    }

    public DocumentResultWrapper<E> findDocsBySearchAfter(SimpleQuery<SearchDocDTO> simpleQuery) {
        return this.getRepository().findDocsBySearchAfter((Query)SearchDocQueryFactory.searchDoc((SearchDocDTO)simpleQuery.toSearchDoc()).create(), simpleQuery.toSearchDoc().getSearchAfter());
    }

    public String indexAliasName() {
        return this.getRepository().indexAliasName();
    }

    public void deleteIndexWithDayRange(int days) {
        this.getRepository().deleteIndexWithDayRange(days);
    }

    public void mergeWithReindex(int day) {
        this.getRepository().mergeWithReindex(day);
    }

    public E save(E entity) {
        return (E)((BaseEntity)this.getRepository().save(entity));
    }

    public E modifyWithIndexName(E entity, String indexName) {
        return (E)((BaseEntity)this.getRepository().modifyWithIndexName(entity, indexName));
    }

    public E saveEmpty(E entity) {
        return (E)((BaseEntity)this.getRepository().saveEmpty(entity));
    }

    public <U extends Serializable> String deleteById(U u) {
        BaseEntity docById = this.findDocById(u);
        return this.getRepository().deleteDocByEntity((Object)docById);
    }

    public <U extends Serializable> Serializable deleteRecentDocById(U u) {
        return this.getRepository().deleteRecentDocById(u);
    }

    public DocumentResultWrapper<E> findAllHits() {
        return this.getRepository().findAllHits();
    }

    public DocumentResultWrapper<E> findRecentAllHits() {
        return this.getRepository().findRecentAllHits();
    }

    public List<CatIndexVO> catIndexVOList() {
        return this.getRepository().catIndexVOList();
    }

    public Long indexAllCount() {
        return this.getRepository().indexCount();
    }
}

