/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.fluentd.service;

import com.arms.api.fluentd.entity.FluentdEntity;
import com.arms.api.fluentd.model.dto.ScheduleHistoryDTO;
import com.arms.api.fluentd.model.vo.ScheduleHistoryVO;
import com.arms.api.fluentd.model.vo.ScheduleLogVO;
import com.arms.api.fluentd.service.FluentdSearch;
import com.arms.api.search_engine.dto.BaseSearchAggrDTO;
import com.arms.api.search_engine.dto.SearchDTO;
import com.arms.api.search_engine.vo.SearchAggrResultVO;
import com.arms.api.search_engine.vo.SearchDocFieldNameAndCount;
import com.arms.api.search_engine.vo.SearchResultVO;
import com.arms.egovframework.javaservice.esframework.esquery.SimpleQuery;
import com.arms.egovframework.javaservice.esframework.esquery.filter.RangeQueryFilter;
import com.arms.egovframework.javaservice.esframework.esquery.highlight.EsHighlightQuery;
import com.arms.egovframework.javaservice.esframework.esquery.must.QueryStringMust;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SortDTO;
import com.arms.egovframework.javaservice.esframework.model.dto.request.AggregationRequestDTO;
import com.arms.egovframework.javaservice.esframework.model.dto.request.SearchRequestDTO;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentAggregations;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentBucket;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentResultWrapper;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.index.query.Operator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="fluentdSearch")
public class FluentdSearchImpl
implements FluentdSearch {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FluentdSearchImpl.class);
    private final EsCommonRepositoryWrapper<FluentdEntity> esCommonRepositoryWrapper;

    @Override
    public SearchAggrResultVO aggregateByFluentdLogName(BaseSearchAggrDTO searchAggrDTO) {
        String startDate = this.convertTimeFormatOfFluentdLog(searchAggrDTO.getStartDate());
        String endDate = this.convertTimeFormatOfFluentdLog(searchAggrDTO.getEndDate());
        try {
            DocumentAggregations documentAggregations = this.esCommonRepositoryWrapper.aggregateDocs(SimpleQuery.aggregation(AggregationRequestDTO.builder().size(5).mainField("@log_name").mainFieldAlias("@log_name").isAscending(false).build()).andQueryStringFilter(searchAggrDTO.getSearchString()).andRangeQueryFilter(RangeQueryFilter.of("@timestamp").betweenDate(startDate, endDate)));
            List<DocumentBucket> documentBuckets = documentAggregations.deepestList();
            List<SearchDocFieldNameAndCount> list = documentBuckets.stream().map(documentBucket -> SearchDocFieldNameAndCount.builder().docFieldName(documentBucket.valueByName("@log_name")).docCount(documentBucket.countByName("@log_name")).build()).toList();
            return SearchAggrResultVO.builder().totalHits(documentAggregations.getTotalHits()).docFieldNameAndCounts(list).build();
        }
        catch (OpenSearchException e) {
            if (this.isIllegalArgumentException(e)) {
                log.warn("[ FluentdSearchImpl ::aggregateByFluentdLogName ] Aggregation failed due to illegal_argument_exception (text field aggregation etc). Returning empty VO.");
                return SearchAggrResultVO.builder().totalHits(0L).docFieldNameAndCounts(Collections.emptyList()).build();
            }
            throw e;
        }
    }

    private boolean isIllegalArgumentException(Throwable t) {
        for (Throwable cause = t; cause != null; cause = cause.getCause()) {
            String message;
            if (!(cause instanceof OpenSearchStatusException) && !(cause instanceof OpenSearchException) || (message = cause.getMessage()) == null || !message.contains("illegal_argument_exception")) continue;
            return true;
        }
        return false;
    }

    @Override
    public SearchResultVO<FluentdEntity> searchFluentdLog(SearchDTO searchDTO) {
        String startDate = this.convertTimeFormatOfFluentdLog(searchDTO.getStartDate());
        String endDate = this.convertTimeFormatOfFluentdLog(searchDTO.getEndDate());
        String filterFieldName = this.getFilterFieldName(searchDTO.getFilter().getName());
        DocumentResultWrapper<FluentdEntity> hits = this.esCommonRepositoryWrapper.findHits(SimpleQuery.search(searchDTO).andQueryStringFilter(searchDTO.getSearchString()).andTermsQueryFilter(filterFieldName, searchDTO.getFilter().getValues()).andRangeQueryFilter(RangeQueryFilter.of("@timestamp").betweenDate(startDate, endDate)).orderBy(SortDTO.builder().field("@timestamp").sortType("desc").build()).highlight(EsHighlightQuery.esHighlightAll()));
        return SearchResultVO.builder().totalResultDocs(hits.getTotalHits()).searchResultDocs(hits.toHitDocs()).build();
    }

    @Override
    public void keepAliveConnection() {
        log.info("keepAliveConnection");
        SearchRequestDTO searchRequestDTO = new SearchRequestDTO();
        searchRequestDTO.setSize(1);
        this.esCommonRepositoryWrapper.findHits(SimpleQuery.search(searchRequestDTO).andTermQueryFilter("recent_id", "313"));
    }

    private String getFilterFieldName(String filterName) {
        if (filterName != null && !filterName.isBlank() && filterName.equals("log")) {
            return "@log_name";
        }
        return null;
    }

    private String convertTimeFormatOfFluentdLog(String inputTime) {
        if (inputTime != null && !inputTime.isEmpty()) {
            LocalDateTime localDateTime = LocalDateTime.parse(inputTime, DateTimeFormatter.ISO_DATE_TIME);
            ZonedDateTime zonedDateTime = localDateTime.atZone(ZoneOffset.ofHours(0));
            return zonedDateTime.format(DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss.SSSSSSSSSZZZZZ"));
        }
        return null;
    }

    @Override
    public List<ScheduleHistoryVO> getScheduleHistory(SearchDTO searchDTO) {
        String scheduleName = searchDTO.getSearchString();
        String queryStringWithStartedAt = scheduleName + " started at";
        String queryStringWithFinishedAt = scheduleName + " finished at";
        SearchDTO searchDTOForStartAt = new SearchDTO();
        searchDTOForStartAt.setSearchString(queryStringWithStartedAt);
        SearchDTO searchDTOForFinishedAt = new SearchDTO();
        searchDTOForFinishedAt.setSearchString(queryStringWithFinishedAt);
        List<FluentdEntity> scheduleStartedAtLogs = this.getScheduleLog(searchDTOForStartAt);
        List<FluentdEntity> scheduleFinishedAtLogs = this.getScheduleLog(searchDTOForFinishedAt);
        List<ScheduleLogVO> startedAtLogs = this.parseScheduleLogs(scheduleName, scheduleStartedAtLogs, "START");
        List<ScheduleLogVO> finishedAtLogs = this.parseScheduleLogs(scheduleName, scheduleFinishedAtLogs, "FINISH");
        return this.mergeToScheduleHistory(startedAtLogs, finishedAtLogs);
    }

    private List<ScheduleHistoryVO> mergeToScheduleHistory(List<ScheduleLogVO> startedLogs, List<ScheduleLogVO> finishedLogs) {
        String threadId;
        HashMap<String, ScheduleHistoryDTO> historyDTOMap = new HashMap<String, ScheduleHistoryDTO>();
        for (ScheduleLogVO startedLog : startedLogs) {
            if (startedLog.getThreadId() == null) {
                log.warn("mergeToScheduleHistory.startedLog(scheduleName: {}, started at {}) :: threadId is null. Skip and continue", (Object)startedLog.getScheduleName(), (Object)startedLog.getEventTime());
                continue;
            }
            threadId = startedLog.getThreadId();
            historyDTOMap.compute(threadId, (existingKey, existingDTO) -> {
                if (existingDTO == null) {
                    return ScheduleHistoryDTO.builder().threadId(threadId).threadName(startedLog.getThreadName()).scheduleName(startedLog.getScheduleName()).startedAt(Optional.ofNullable(startedLog.getEventTime()).orElse("")).build();
                }
                existingDTO.setStartedAt(startedLog.getEventTime());
                return existingDTO;
            });
        }
        for (ScheduleLogVO finishedLog : finishedLogs) {
            if (finishedLog.getThreadId() == null) {
                log.warn("mergeToScheduleHistory.startedLog(scheduleName: {}, finished at {}) :: threadId is null. Skip and continue", (Object)finishedLog.getScheduleName(), (Object)finishedLog.getEventTime());
                continue;
            }
            threadId = finishedLog.getThreadId();
            historyDTOMap.compute(threadId, (existingKey, existingDTO) -> {
                if (existingDTO == null) {
                    return ScheduleHistoryDTO.builder().threadId(threadId).threadName(finishedLog.getThreadName()).scheduleName(finishedLog.getScheduleName()).finishedAt(Optional.ofNullable(finishedLog.getEventTime()).orElse("")).elapsedTime(Optional.ofNullable(finishedLog.getElapsedTime()).orElse("")).build();
                }
                existingDTO.setFinishedAt(Optional.ofNullable(finishedLog.getEventTime()).orElse(""));
                existingDTO.setElapsedTime(Optional.ofNullable(finishedLog.getElapsedTime()).orElse(""));
                return existingDTO;
            });
        }
        return this.convertDtoMapToVoList(historyDTOMap);
    }

    private List<ScheduleLogVO> parseScheduleLogs(String scheduleName, List<FluentdEntity> scheduleLogs, String eventType) {
        ArrayList<ScheduleLogVO> logVOList = new ArrayList<ScheduleLogVO>();
        if (scheduleLogs == null || scheduleLogs.isEmpty()) {
            log.info("[FluentdServiceImpl :: parseScheduleLogs] :: scheduleName => {}, scheduleLogs is null or empty", (Object)scheduleName);
            return Collections.emptyList();
        }
        for (FluentdEntity scheduleLog : scheduleLogs) {
            String logString = scheduleLog.getLog();
            if (logString == null || logString.isBlank()) {
                log.warn("A parseScheduleLog.logString (from scheduleLogs) is empty. skip and continue");
                continue;
            }
            ScheduleLogVO.ScheduleLogVOBuilder builder = ScheduleLogVO.builder();
            builder.scheduleName(scheduleName);
            this.extractGroup(logString, "\\[([^\\]]+)]\\sINFO", 1).ifPresentOrElse(builder::threadName, () -> log.info("Thread name not found."));
            this.extractGroup(logString, "- \\[([a-fA-F0-9]{8})\\] ::", 1).ifPresentOrElse(builder::threadId, () -> log.info("Thread UUID not found."));
            if ("START".equalsIgnoreCase(eventType)) {
                builder.eventType("START");
                this.extractGroup(logString, "started at (\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2})", 1).ifPresentOrElse(builder::eventTime, () -> log.info("Start time not found."));
            } else if ("FINISH".equalsIgnoreCase(eventType)) {
                builder.eventType("FINISH");
                this.extractGroup(logString, "finished at (\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2})", 1).ifPresentOrElse(builder::eventTime, () -> log.info("Finish time not found."));
                this.extractGroup(logString, "completed in (\\d+) ms", 1).ifPresentOrElse(builder::elapsedTime, () -> log.info("Elapsed time not found."));
            } else {
                log.warn("Unknown event type '{}'. Skipping this log entry.", (Object)eventType);
                continue;
            }
            logVOList.add(builder.build());
        }
        return logVOList;
    }

    private List<FluentdEntity> getScheduleLog(SearchDTO searchDTO) {
        String startDate = this.convertTimeFormatOfFluentdLog(searchDTO.getStartDate());
        String endDate = this.convertTimeFormatOfFluentdLog(searchDTO.getEndDate());
        DocumentResultWrapper<FluentdEntity> hits = this.esCommonRepositoryWrapper.findHits(SimpleQuery.search(searchDTO).andQueryStringMust(QueryStringMust.of(searchDTO.getSearchString()).operator(Operator.AND)).andRangeQueryFilter(RangeQueryFilter.of("@timestamp").betweenDate(startDate, endDate)).orderBy(SortDTO.builder().field("@timestamp").sortType("desc").build()));
        return hits.toDocs();
    }

    private Optional<String> extractGroup(String input, String regex, int group) {
        Matcher matcher = Pattern.compile(regex).matcher(input);
        return matcher.find() ? Optional.ofNullable(matcher.group(group)) : Optional.empty();
    }

    private List<ScheduleHistoryVO> convertDtoMapToVoList(Map<String, ScheduleHistoryDTO> historyDTOMap) {
        if (historyDTOMap == null || historyDTOMap.isEmpty()) {
            return new ArrayList<ScheduleHistoryVO>();
        }
        return historyDTOMap.values().stream().map(dto -> new ScheduleHistoryVO(dto.getThreadId(), dto.getThreadName(), dto.getScheduleName(), dto.getStartedAt(), dto.getFinishedAt(), dto.getElapsedTime())).collect(Collectors.toList());
    }

    @Generated
    public FluentdSearchImpl(EsCommonRepositoryWrapper<FluentdEntity> esCommonRepositoryWrapper) {
        this.esCommonRepositoryWrapper = esCommonRepositoryWrapper;
    }
}

