/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.blog.service;

import com.arms.api.blog.model.entity.BlogDTO;
import com.arms.api.blog.model.entity.BlogEntity;
import com.arms.api.blog.model.vo.BlogVO;
import com.arms.api.blog.service.BlogService;
import com.arms.egovframework.javaservice.esframework.esquery.SimpleQuery;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SearchDocDTO;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SortDTO;
import com.arms.egovframework.javaservice.esframework.model.dto.request.SearchRequestDTO;
import com.arms.egovframework.javaservice.esframework.model.entity.BaseEntity;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentResultWrapper;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import java.io.Serializable;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class BlogServiceImpl
implements BlogService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BlogServiceImpl.class);
    private final EsCommonRepositoryWrapper<BlogEntity> esCommonRepositoryWrapper;

    @Transactional
    public Long addBlog(BlogDTO blogDTO) {
        BlogEntity blogEntity = blogDTO.createBlogEntity();
        BlogEntity savedEntity = (BlogEntity)this.esCommonRepositoryWrapper.save((BaseEntity)blogEntity);
        return savedEntity.getC_id();
    }

    @Transactional
    public Long updateBlog(BlogDTO blogDTO) {
        if (this.esCommonRepositoryWrapper.findDocById((Serializable)blogDTO.getC_id()) == null) {
            throw new IllegalArgumentException("\ube14\ub85c\uadf8 \uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        BlogEntity willUpdateEntity = blogDTO.createBlogEntity();
        this.esCommonRepositoryWrapper.save((BaseEntity)willUpdateEntity);
        return willUpdateEntity.getC_id();
    }

    @Transactional(readOnly=true)
    public BlogEntity getBlog(BlogDTO blogDTO) {
        Long c_id = blogDTO.getC_id();
        String c_blog_contents = blogDTO.getC_blog_contents();
        BlogEntity existingEntity = (BlogEntity)this.esCommonRepositoryWrapper.findDocById((Serializable)c_id);
        if (existingEntity == null) {
            if (c_blog_contents != null && !c_blog_contents.isEmpty()) {
                BlogEntity willCreateEntity = blogDTO.createBlogEntity();
                this.asyncViewCountUp(c_id);
                this.esCommonRepositoryWrapper.save((BaseEntity)willCreateEntity);
                return willCreateEntity;
            }
            throw new IllegalArgumentException("\ube14\ub85c\uadf8 \uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        this.asyncViewCountUp(c_id);
        return existingEntity;
    }

    @Transactional
    public Long removeBlog(Long blogId) {
        this.esCommonRepositoryWrapper.deleteById((Serializable)blogId);
        return blogId;
    }

    @Async
    public void asyncViewCountUp(Long blogId) {
        BlogEntity existingEntity = (BlogEntity)this.esCommonRepositoryWrapper.findDocById((Serializable)blogId);
        if (existingEntity != null) {
            existingEntity.viewCountUp();
            this.esCommonRepositoryWrapper.save((BaseEntity)existingEntity);
        } else {
            log.warn("\ube14\ub85c\uadf8 \uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4: {}", (Object)blogId);
        }
    }

    public List<BlogEntity> getBlogListByViewCountDesc(BlogDTO blogDTO) {
        blogDTO.setSize(20);
        return this.getList(SimpleQuery.search((SearchRequestDTO)blogDTO).orderBy(new SortDTO[]{SortDTO.builder().field("c_blog_view_count").sortType("desc").build(), SortDTO.builder().field("c_blog_created").sortType("desc").build()})).getBlogEntities();
    }

    public BlogVO searchBlog(BlogDTO blogDTO) {
        return this.getList(SimpleQuery.search((SearchRequestDTO)blogDTO).andMatchQueryFilter("c_blog_title", (Object)blogDTO.getC_blog_title()).andMatchQueryFilter("c_blog_contents", (Object)blogDTO.getC_blog_contents()).orderBy(new SortDTO[]{SortDTO.builder().field("c_blog_view_count").sortType("desc").build(), SortDTO.builder().field("c_blog_created").sortType("desc").build()}));
    }

    private BlogVO getList(SimpleQuery<SearchDocDTO> simpleQuery) {
        DocumentResultWrapper docsBySearchAfter = this.esCommonRepositoryWrapper.findDocsBySearchAfter(simpleQuery);
        List docs = docsBySearchAfter.toDocs();
        return BlogVO.builder().blogEntities(docs).totalHits(docsBySearchAfter.getTotalHits()).searchAfter(docsBySearchAfter.getLastSortValue()).build();
    }

    @Generated
    public BlogServiceImpl(EsCommonRepositoryWrapper<BlogEntity> esCommonRepositoryWrapper) {
        this.esCommonRepositoryWrapper = esCommonRepositoryWrapper;
    }
}

