/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.issue.almapi.service;

import com.arms.api.issue.almapi.model.dto.ArmsStateCategoryDTO;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.msa_communicate.MiddleProxyArmsStateCategory;
import com.arms.api.util.response.CommonResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CategoryMappingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CategoryMappingService.class);
    private final MiddleProxyArmsStateCategory middleProxyMiddleProxyArmsStateCategory;

    public String getMappingCategory(ServerInfo serverInfo, String statusId) {
        return this.getMappingCategory(serverInfo, null, null, statusId);
    }

    public String getMappingCategory(ServerInfo serverInfo, String projectKey, String issueTypeId, String statusId) {
        if (serverInfo == null || serverInfo.getConnectId() == null) {
            log.error(" [ getMappingCategory ] :: \uc720\ud6a8\ud55c \uac12\uc774 \uc5c6\uc2b5\ub2c8\ub2e4 :: ServerInfo");
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)statusId)) {
            log.error(" [ getMappingCategory ] :: \uc720\ud6a8\ud55c \uac12\uc774 \uc5c6\uc2b5\ub2c8\ub2e4 :: statusId");
            return null;
        }
        String connectId = String.valueOf(serverInfo.getConnectId());
        return this.getCategoryName(connectId, projectKey, issueTypeId, statusId);
    }

    private String getCategoryName(String connectId, String projectKey, String issueTypeId, String statusId) {
        CommonResponse.ApiResult armsStateCategory = this.middleProxyMiddleProxyArmsStateCategory.getArmsStateCategory(connectId, projectKey, issueTypeId, statusId);
        ArmsStateCategoryDTO armsStateCategoryDTO = (ArmsStateCategoryDTO)armsStateCategory.getResponse();
        if (armsStateCategoryDTO == null || StringUtils.isEmpty((CharSequence)armsStateCategoryDTO.getId())) {
            log.warn("[getCategoryName] :: \uce74\ud14c\uace0\ub9ac \ub9e4\ud551 \uc5c6\uc74c - connectId={}, projectKey={}, issueTypeId={}, statusId={}", new Object[]{connectId, projectKey, issueTypeId, statusId});
            return null;
        }
        return armsStateCategoryDTO.getName();
    }

    @Generated
    public CategoryMappingService(MiddleProxyArmsStateCategory middleProxyMiddleProxyArmsStateCategory) {
        this.middleProxyMiddleProxyArmsStateCategory = middleProxyMiddleProxyArmsStateCategory;
    }
}

