/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.util.errors;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.reactive.function.client.WebClientResponseException;

/*
 * Exception performing whole class analysis ignored.
 */
public class ErrorLogUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ErrorLogUtil.class);

    public static void exceptionLogging(Exception e, String className, String methodName) {
        String errorMessage = ErrorLogUtil.generateErrorMessage((Exception)e, (String)className, (String)methodName);
        log.error(errorMessage);
    }

    public static String exceptionLoggingAndReturn(Exception e, String className, String methodName) {
        String errorMessage = ErrorLogUtil.generateErrorMessage((Exception)e, (String)className, (String)methodName);
        log.error(errorMessage);
        return errorMessage;
    }

    private static String generateErrorMessage(Exception e, String className, String methodName) {
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append(" [ ").append(className).append(" :: ").append(methodName).append(" ] :: ").append(e.getClass().getName()).append(" :: ").append(e.getMessage());
        if (e instanceof WebClientResponseException) {
            WebClientResponseException wcException = (WebClientResponseException)e;
            HttpStatusCode status = wcException.getStatusCode();
            String body = wcException.getResponseBodyAsString();
            errorMessage.append(" :: ").append(status).append(" :: ").append(body);
        }
        return errorMessage.toString();
    }
}

