package com.arms.api.analysis.cost.service;

import com.arms.api.analysis.cost.model.dto.CostAggrDTO;
import com.arms.api.analysis.cost.model.dto.CostDTO;
import com.arms.api.analysis.cost.model.dto.CostRequestDTO;
import com.arms.api.analysis.cost.model.vo.AssigneeTimeDiffVO;
import com.arms.api.analysis.cost.model.vo.CostVO;

import java.util.List;

public interface AnalysisCost {

    List<CostVO> getAssigneeList(CostAggrDTO costAggrDTO);

    List<CostVO> getAssigneeListByProductVersionAndRequirement(CostAggrDTO costAggrDTO);

    List<CostVO> aggregationByAssigneeAccountId(CostAggrDTO costAggrDTO);

    List<CostVO> aggregationByReqLinkAndAssigneeAccountId(CostAggrDTO costAggrDTO);

    // durationInfoByAccountId 대체 API
    List<AssigneeTimeDiffVO> calculateWorkdayByAccountId(CostRequestDTO resourceDTO);

    List<CostVO> calculationCost(CostDTO costDTO);

}
