package com.arms.egovframework.javaservice.esframework.esquery.filter;


import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.TermQueryBuilder;

import java.util.List;

public class TermQueryFilter extends Filter<TermQueryBuilder> {

	private TermQueryBuilder termQueryBuilder;

	public <T> TermQueryFilter(String name, T value){
		if(name!=null&&value!=null){
			this.termQueryBuilder = QueryBuilders.termQuery(name, value);
		}
	}

	@Override
	public AbstractQueryBuilder<TermQueryBuilder> abstractQueryBuilder() {
		return  termQueryBuilder;
	}

}
