package com.arms.api.issue.almapi.model.dto;

import com.arms.api.util.errors.ErrorCode;
import lombok.extern.slf4j.Slf4j;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;

@Slf4j
public class AlmIssueValidator implements ConstraintValidator<AlmIssueValid, AlmIssueWithRequirementDTO> {


    @Override
    public boolean isValid(AlmIssueWithRequirementDTO almIssueWithRequirementDTO, ConstraintValidatorContext context) {


        context.disableDefaultConstraintViolation();

        if (almIssueWithRequirementDTO.getJiraServerId() == null) {
            context.buildConstraintViolationWithTemplate("지라이슈_벌크_추가하기 Error: 서버_아이디 " + ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg())
                .addConstraintViolation();
            return false;
        }

        if (almIssueWithRequirementDTO.getIssueKey() == null || almIssueWithRequirementDTO.getIssueKey().isEmpty()) {
            context.buildConstraintViolationWithTemplate("지라이슈_벌크_추가하기 Error 이슈_키 " + ErrorCode.PARAMETER_NULL_ERROR.getErrorMsg())
                .addConstraintViolation();
            return false;
        }

        if (almIssueWithRequirementDTO.getProjectKeyOrId() == null
            || almIssueWithRequirementDTO.getProjectKeyOrId().isEmpty()) {
            context.buildConstraintViolationWithTemplate("지라이슈_벌크_추가하기 Error 프로젝트키_또는_아이디 " + ErrorCode.PARAMETER_NULL_ERROR.getErrorMsg())
                .addConstraintViolation();
            return false;
        }

        if (almIssueWithRequirementDTO.getServiceId() == null
            || almIssueWithRequirementDTO.getVersions() == null
            || almIssueWithRequirementDTO.getVersions().isEmpty()) {
            context.buildConstraintViolationWithTemplate("지라이슈_벌크_추가하기 Error 제품서비스_아이디 또는 제품서비스_버전 " + ErrorCode.PARAMETER_NULL_ERROR.getErrorMsg())
                .addConstraintViolation();
            return false;
        }

        if (almIssueWithRequirementDTO.getCReqLink() == null) {
            context.buildConstraintViolationWithTemplate("지라이슈_벌크_추가하기 Error cReqLink " + ErrorCode.PARAMETER_NULL_ERROR.getErrorMsg())
                .addConstraintViolation();
            return false;
        }


        return  true;
    }
}
