package com.arms.api.issue.almapi.model.dto;

import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;

import lombok.*;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

@Builder
@Getter
@Setter
@Slf4j
@AlmIssueValid
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(of = {"jiraServerId","issueKey","projectKeyOrId"})
public class AlmIssueWithRequirementDTO {

    private String jiraServerId;

    private String cTitle;

    private Long cReqStatusId;

    private String issueKey;

    private String projectKeyOrId;

    private Long serviceId;

    private List<Long> versions;

    private Long cReqLink;

    private CReqProperty cReqProperty;

    public String recentId(){
        return jiraServerId + "_" + projectKeyOrId + "_" + issueKey;
    }

    public String extractIssueKeyFromMainKey(String issueKey){
        return jiraServerId + "_" + projectKeyOrId + "_" + issueKey;
    }

    public String extractIssueKeyFromMainKey(String projectKey, String issueKey){
        return jiraServerId + "_" + projectKey + "_" + issueKey;
    }

    public AlmIssueWithRequirementDTO(AlmIssueEntity almIssueEntity){

        this.jiraServerId = almIssueEntity.getJira_server_id();
        this.cReqStatusId = almIssueEntity.getCReqStatusId();
        this.issueKey = almIssueEntity.getKey();
        this.projectKeyOrId = almIssueEntity.getProject().getKey();
        this.serviceId = almIssueEntity.getPdServiceId();
        this.versions = almIssueEntity.getPdServiceVersions();
        this.cReqLink = almIssueEntity.getCReqLink();
        this.cReqProperty = getCReqProperty(almIssueEntity);

    }

    public AlmIssueWithRequirementDTO(AlmIssueEntity almIssueEntity,String selfGenIssueKey){

        this.jiraServerId = almIssueEntity.getJira_server_id();
        this.cReqStatusId = almIssueEntity.getCReqStatusId();
        this.issueKey = selfGenIssueKey;
        this.projectKeyOrId = almIssueEntity.getProject().getKey();
        this.serviceId = almIssueEntity.getPdServiceId();
        this.versions = almIssueEntity.getPdServiceVersions();
        this.cReqLink = almIssueEntity.getCReqLink();
        this.cReqProperty = getCReqProperty(almIssueEntity);

    }



    private  CReqProperty getCReqProperty(AlmIssueEntity almIssueEntity) {
        AlmIssueEntity.CReqProperty almIssueEntityCReqProperty = almIssueEntity.getCReqProperty();
        if(almIssueEntityCReqProperty==null){
            return null;
        }
        CReqProperty cReqProperty = new CReqProperty();
        cReqProperty.setCReqPriorityLink(almIssueEntityCReqProperty.getCReqPriorityLink());
        cReqProperty.setCReqPriorityName(almIssueEntityCReqProperty.getCReqPriorityName());
        cReqProperty.setCReqDifficultyLink(almIssueEntityCReqProperty.getCReqDifficultyLink());
        cReqProperty.setCReqDifficultyName(almIssueEntityCReqProperty.getCReqDifficultyName());
        cReqProperty.setCReqStateLink(almIssueEntityCReqProperty.getCReqStateLink());
        cReqProperty.setCReqStateName(almIssueEntityCReqProperty.getCReqStateName());
        return cReqProperty;
    }

}
