/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.keycloak.user.controller;

import com.arms.api.keycloak.user.service.KeycloakUserService;
import java.util.List;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.idm.UserRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Controller
public class KeycloakUserController {
    private static final Logger log = LoggerFactory.getLogger(KeycloakUserController.class);
    private final RealmResource realmResource;
    private final KeycloakUserService keycloakUserService;

    @GetMapping(value={"/auth-user/search-user/{userName}"})
    @ResponseBody
    public Mono<List<UserRepresentation>> getUser(ServerWebExchange exchange, @PathVariable(value="userName") String userName) {
        log.info("userName -> " + userName);
        List userRepresentations = this.realmResource.users().search(userName, Integer.valueOf(0), Integer.valueOf(1000), Boolean.valueOf(true));
        return Mono.just((Object)userRepresentations);
    }

    @GetMapping(value={"/auth-user/users"})
    @ResponseBody
    public Mono<List<UserRepresentation>> getUsers(ServerWebExchange exchange) {
        List userRepresentations = this.realmResource.users().list();
        return Mono.just((Object)userRepresentations);
    }

    @GetMapping(value={"/auth-user/user/{user-id}/check-permission/{current-page}"})
    @ResponseBody
    public Mono<Void> ckeckPermissions(ServerWebExchange exchange, @PathVariable(value="user-id") String userId, @PathVariable(value="current-page") String currentPage) {
        Boolean ckeckPermission = this.keycloakUserService.ckeckPermissions(userId, currentPage);
        if (!ckeckPermission.booleanValue()) {
            Mono webSessionMono = exchange.getSession();
            return webSessionMono.flatMap(session -> Mono.fromRunnable(() -> {
                ServerHttpResponse httpResponse = exchange.getResponse();
                httpResponse.setStatusCode(HttpStatus.FORBIDDEN);
            }).then(exchange.getResponse().setComplete()));
        }
        return Mono.empty();
    }

    public KeycloakUserController(RealmResource realmResource, KeycloakUserService keycloakUserService) {
        this.realmResource = realmResource;
        this.keycloakUserService = keycloakUserService;
    }
}

