package com.arms.api.mapping.dto;

import com.arms.api.mapping.domain.AlmIssueStatus;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.springframework.data.annotation.Id;


@NoArgsConstructor
@AllArgsConstructor
@Setter
@Getter
public class AlmIssueStatusDTO {

    @Id
    private String id;
    private String name;
    private String armsStateMappingId;

    public AlmIssueStatus toEntity(){
        return AlmIssueStatus.builder()
            .id(this.id)
            .name(this.name)
            .armsStateMappingId(this.armsStateMappingId)
            .build();
    }
}