////////////////////////////////////////////////////////////////////////////////////////
//Page 전역 변수
////////////////////////////////////////////////////////////////////////////////////////
var senderInfo; // 발신 메일 정보
var receiverInfo ;

var isSmtpValidated = false;
////////////////////////////////////////////////////////////////////////////////////////
//Document Ready
////////////////////////////////////////////////////////////////////////////////////////
function execDocReady() {
    var pluginGroups = [
        [
            "../reference/light-blue/lib/vendor/jquery.ui.widget.js",
            "../reference/light-blue/lib/vendor/http_blueimp.github.io_JavaScript-Templates_js_tmpl.js",
            "../reference/light-blue/lib/vendor/http_blueimp.github.io_JavaScript-Load-Image_js_load-image.js",
            "../reference/light-blue/lib/vendor/http_blueimp.github.io_JavaScript-Canvas-to-Blob_js_canvas-to-blob.js",
            "../reference/light-blue/lib/jquery.iframe-transport.js",
            "../reference/light-blue/lib/jquery.fileupload.js",
            "../reference/light-blue/lib/jquery.fileupload-fp.js",
            "../reference/light-blue/lib/jquery.fileupload-ui.js"
        ],

        [
            "../reference/jquery-plugins/select2-4.0.2/dist/css/select2_lightblue4.css",
            "../reference/jquery-plugins/lou-multi-select-0.9.12/css/multiselect-lightblue4.css",
            "../reference/jquery-plugins/multiple-select-1.5.2/dist/multiple-select-bluelight.css",
            "../reference/jquery-plugins/select2-4.0.2/dist/js/select2.min.js",
            "../reference/jquery-plugins/lou-multi-select-0.9.12/js/jquery.quicksearch.js",
            "../reference/jquery-plugins/lou-multi-select-0.9.12/js/jquery.multi-select.js",
            "../reference/jquery-plugins/multiple-select-1.5.2/dist/multiple-select.min.js"
        ],

        [
            "../reference/jquery-plugins/datetimepicker-2.5.20/build/jquery.datetimepicker.min.css",
            "../reference/light-blue/lib/bootstrap-datepicker.js",
            "../reference/jquery-plugins/datetimepicker-2.5.20/build/jquery.datetimepicker.full.min.js",
            "../reference/lightblue4/docs/lib/widgster/widgster.js",
            "../reference/lightblue4/docs/lib/slimScroll/jquery.slimscroll.min.js",
            "../reference/lightblue4/docs/lib/jquery.sparkline/index.js",
            "../reference/lightblue4/docs/js/charts.js"
        ],

        [
            "../reference/jquery-plugins/dataTables-1.10.16/media/css/jquery.dataTables_lightblue4.css",
            "../reference/jquery-plugins/dataTables-1.10.16/extensions/Responsive/css/responsive.dataTables_lightblue4.css",
            "../reference/jquery-plugins/dataTables-1.10.16/extensions/Select/css/select.dataTables_lightblue4.css",
            "../reference/jquery-plugins/dataTables-1.10.16/media/js/jquery.dataTables.min.js",
            "../reference/jquery-plugins/dataTables-1.10.16/extensions/Responsive/js/dataTables.responsive.min.js",
            "../reference/jquery-plugins/dataTables-1.10.16/extensions/Select/js/dataTables.select.min.js",
            "../reference/jquery-plugins/dataTables-1.10.16/extensions/RowGroup/js/dataTables.rowsGroup.min.js",
            "../reference/jquery-plugins/dataTables-1.10.16/extensions/Buttons/js/dataTables.buttons.min.js",
            "../reference/jquery-plugins/dataTables-1.10.16/extensions/Buttons/js/buttons.html5.js",
            "../reference/jquery-plugins/dataTables-1.10.16/extensions/Buttons/js/buttons.print.js",
            "../reference/jquery-plugins/dataTables-1.10.16/extensions/Buttons/js/jszip.min.js",
            "../reference/jquery-plugins/dataTables-1.10.16/extensions/Buttons/js/pdfmake.min.js",
            "../reference/jquery-plugins/dataTables-1.10.16/extensions/Buttons/js/vfs_fonts.js",
            // timezone-picker
            "../reference/jquery-plugins/kevalbhatt-timezone-picker-2.0.0/dist/timezone-picker.min.js",
            "../reference/jquery-plugins/kevalbhatt-timezone-picker-2.0.0/dist/styles/timezone-picker.css"
        ]
        // 추가적인 플러그인 그룹들을 이곳에 추가하면 됩니다.
    ];

    loadPluginGroupsParallelAndSequential(pluginGroups)
        .then(function () {
            console.log("모든 플러그인 로드 완료");

            // 사이드 메뉴 색상 설정
            $(".widget").widgster();
            setSideMenu("sidebar_menu_config", "sidebar_menu_config_mailReport");


            // 편집하기 버튼 클릭
            clickEditMailInfo();
            initializeTabButtonVisibility(); // 편집하기, 등록하기, 변경사항 저장

            /* 발신 메일 관련 함수 */
            get_sender_info(); //저장된 발신 메일 조회

            delete_sender_info(); //저장된 발신 메일 삭제

            update_sender_info(); //저장된 발신 메일 업데이트

            save_sender_info(); // 발신 메일 저장

            validate_smtp_config(); // 발신 메일 저장전 검증

            initializeModal(); // 모달 초기화
            setSmtpHost(); // 항목 중 선택 시
            togglePasswordVisibility('modalTogglePassword', 'modal_sender_password'); // 첫 번째 필드
            togglePasswordVisibility('togglePassword', 'senderPassword'); // 두 번째 필드
            enforceHourlyInput('#modal_sender_time');
            enforceHourlyInput('#senderTime');

            /* 수신 메일 관련 함수 */
            save_receiver_info(); // 수신 메일 정보 저장

            update_receiver_info(); // 수신 메일 정보 업데이트

            delete_receiver_info(); // 수신 메일 정보 삭제

            send_test_mail(); // 테스트 메일 발송

            mail_test();
        })
        .catch(function (error) {
            console.error("플러그인 로드 중 오류 발생");
            console.log(error);
        });
}

function initializeTabButtonVisibility() {
    $('a[data-toggle="tab"]').on('shown.bs.tab', function(e) {
        const target = $(e.target).attr("href");

        if (target === "#outgoingMail") { // 발신 메일 탭 선택
            showOutgoingMailButtons();
        }else{ // 수신 메일 탭
            showIncomingMailButtons();
            get_receiver_info();
        }
    });
}
// 발신 메일 버튼 보이기
function showOutgoingMailButtons() {
    $('.incoming-buttons').addClass("hidden");

    $('.editMailInfo').prop('disabled', true);

    if (!check_sender_info()) { // 필드 안에 데이터가 없으면
        $("#saverSenderInfo").removeClass("hidden");
        $("#deleteOutgoingMailInfo, #editOutgoingMailInfo").addClass("hidden");
    } else { // 필드 안에 데이터가 있으면
        $("#saverSenderInfo").addClass("hidden");
        $("#deleteOutgoingMailInfo, #editOutgoingMailInfo").removeClass("hidden");
    }
}
// 수신 메일 버튼 보이기
function showIncomingMailButtons() {
    $('.outgoing-buttons').addClass("hidden");
    $('.incoming-buttons').removeClass("hidden");
}


function check_sender_info() {
    smtpServer = $("#smtpServer").val();
    smtpPort = $("#smtpPort").val();
    senderEmail = $("#senderEmail").val();
    senderPassword = $("#senderPassword").val();
    emailSubject = $("#emailSubject").val();
    sendTime = $("#senderTime").val();
    return smtpServer && smtpPort && senderEmail && senderPassword && emailSubject && sendTime ? true : false;
}
/*
발신 메일 정보 저장
*/
function get_sender_info(){
    $.ajax({
        url: '/auth-user/api/arms/report/mail-sender/getNodesWithoutRoot.do',
        type: 'GET',
        contentType: 'application/json',
        statusCode: {
            200: function (data) {
                // 필드값 초기화
                resetSenderFields();
                console.log("[ mail report :: get sender info ] :: ->");
                senderInfo = data.result[0];
                console.log(senderInfo);
                // 필드값 셋
                set_sender_info(senderInfo);
            }
        },
        error: function(e) {
            console.error('Error:', e);
            jError("발신 메일 정보 조회 오류 발생.");
        }
    });
}

function set_sender_info(senderInfo){

    if (senderInfo !== undefined && senderInfo !== null){
        $('#saverSenderInfo').addClass("hidden");
        $('#deleteOutgoingMailInfo').removeClass("hidden");
        $('#editOutgoingMailInfo').removeClass("hidden");

        $("#smtpServer").val(senderInfo.c_smtp_server);
        $("#smtpPort").val(senderInfo.c_smtp_port);
        $("#senderEmail").val(senderInfo.c_sender_email);
        $("#senderPassword").val(senderInfo.c_sender_password);
        $("#emailSubject").val(senderInfo.c_email_subject);
        $("#senderTime").val(formatTime(senderInfo.c_send_time))
    }else{
        $('#saverSenderInfo').removeClass("hidden");
        $('#deleteOutgoingMailInfo').addClass("hidden");
        $('#editOutgoingMailInfo').addClass("hidden");
    }
}

function enforceHourlyInput(selector) {
    $(selector).on('input', function () {
        const value = $(this).val();
        const [hour, minute] = value.split(':').map(Number);

        if (minute !== 0) {
            $(this).val(`${String(hour).padStart(2, '0')}:00`);
        }
    });
}

function formatTime(timeObj) {
    const { hour, minute } = timeObj;
    return `${String(hour).padStart(2, '0')}:${String(minute).padStart(2, '0')}`;
}
/*
발신 메일정보 검증
*/
function validate_smtp_config(){
    $("#validate_smtp_config").click(function() {
        const smtpServer = $('#modal_smtp_server').val();
        const smtpPort = $('#modal_smtp_port').val();
        const senderEmail = $('#modal_sender_email').val();
        const senderPassword = $('#modal_sender_password').val();
        const subject = $('#modal_subject').val();

        if ( !smtpServer || !smtpPort || !senderEmail || !senderPassword  ) {
            jError('모든 필드를 입력해 주세요.');
            return;
        }

        // 데이터 객체 생성
        const data = {
            c_smtp_server: smtpServer,
            c_smtp_port: smtpPort,
            c_sender_email: senderEmail,
            c_sender_password: senderPassword,
            c_email_subject: subject
        };

        console.log(data);

        $.ajax({
            url: '/auth-user/api/arms/mail/validate',
            type: 'POST',
            contentType: 'application/json',
            data: JSON.stringify(data),
            statusCode: {
                200: function (data) {
                    console.log(data);
                    if(data.success){
                        jSuccess("SMTP 설정이 유효합니다.");
                        isSmtpValidated = true;
                    }else{
                        console.log("SMTP 설정 오류");
                        console.log(data.errorMessage);
                        jError(`SMTP 설정이 유효하지 않습니다. 오류 = ${data.errorMessage}`);
                    }
                }
            },
            error: function(e) {
                console.error('Error:', e);
                jError("SMTP 설정 검증시 오류가 발생하였습니다.");
                isSmtpValidated = false;
            }
        });
    });
}

/*
발신 메일 정보 저장
*/
function save_sender_info() {
    $("#save_sender").click(function() {
        // 검증 여부 확인
        if (!isSmtpValidated) {
            jError('먼저 SMTP 설정을 검증해 주세요.');
            $("#validate_smtp_config").focus(); // 검증 버튼에 포커스
            return;
        }
        // 비밀번호 표시/숨김 기능
        const smtpServer = $('#modal_smtp_server').val();
        const smtpPort = $('#modal_smtp_port').val();
        const senderEmail = $('#modal_sender_email').val();
        const senderPassword = $('#modal_sender_password').val();
        const subject = $('#modal_subject').val();
        const senderTime =$('#modal_sender_time').val();

        $('#togglePassword').on('click', function() {
            const $passwordField = $('#modal_sender_password');
            const $icon = $(this).find('i');

            if ($passwordField.attr('type') === 'password') {
                $passwordField.attr('type', 'text'); // 비밀번호를 보이게
                $icon.removeClass('fa-eye').addClass('fa-eye-slash'); // 아이콘 변경
            } else {
                $passwordField.attr('type', 'password'); // 비밀번호를 숨김
                $icon.removeClass('fa-eye-slash').addClass('fa-eye'); // 아이콘 변경
            }
        });

        if ( !smtpServer || !smtpPort || !senderEmail || !senderPassword || !senderTime ) {
            jError('모든 필드를 입력해 주세요.');
            return;
        }

        // 데이터 객체 생성
        const data = {
            ref:2,
            c_type: "default",
            c_smtp_server: smtpServer,
            c_smtp_port: smtpPort,
            c_sender_email: senderEmail,
            c_sender_password: senderPassword,
            c_email_subject: subject,
            c_send_time:senderTime
        };

        console.log(data);

        $.ajax({
            url: '/auth-user/api/arms/report/mail-sender/addNode.do',
            type: 'POST',
            data: data,
            statusCode: {
                200: function () {
                    jSuccess("발신 메일 정보가 등록 되었습니다.");
                    $("#close_sender").trigger("click");
                    resetSenderModalFields();
                    get_sender_info();
                    // 편집 완료 후 버튼 텍스트 변경
                    checkEditMode();
                }
            },
            error: function(e) {
                console.error('Error:', e);
                jError("SMTP 정보를 저장하는 데 문제가 발생했습니다.");
            }
        });
    });
}
/*
발신 메일 정보 삭제
*/
function delete_sender_info(){
    $("#deleteOutgoingMailInfo").click(function() {
        if (!confirm("정말로 삭제하시겠습니까?")) {
            return; // 사용자가 취소를 누르면 삭제 중단
        }
        // 데이터 객체 생성
        const data ={
            c_id : senderInfo.c_id
        };
        $.ajax({
            url: '/auth-user/api/arms/report/mail-sender/removeNode.do',
            type: 'DELETE',
            data: data,
            statusCode: {
                200: function () {
                    jSuccess("발신 메일 정보가 삭제되었습니다.");
                    get_sender_info();
                }
            },
            error: function(e) {
                console.error('Error:', e);
                jError("SMTP 정보를 삭제시 문제가 발생했습니다.");
            }
        });
    });
}
function clickEditMailInfo() {
    $('#editOutgoingMailInfo').on('click', function() {
        // 편집 버튼이 활성화 상태인지 확인
        const isEditMode = !$('.editMailInfo').prop('disabled');

        if (isEditMode) {
            // 편집 취소 모드
            $('.editMailInfo').prop('disabled', true);
            $('#saveChangedOutgoingMailInfo').addClass("hidden");
            $(this).text("편집하기"); // 버튼 텍스트를 편집 모드로 전환
            get_sender_info(); // 편집 중에 편집 취소 버튼 눌렀을 때 필드 데이터 초기화 하기 위해 한번 더 호출
        } else {
            // 편집 활성화 모드
            $('.editMailInfo').prop('disabled', false);
            $('#saveChangedOutgoingMailInfo').removeClass("hidden");

            checkEditMode();
        }
    });
}
// saveChangedOutgoingMailInfo가 보일 때만 텍스트 변경
function checkEditMode(){
    if ($('#saveChangedOutgoingMailInfo').is(":visible")) {
        $("#editOutgoingMailInfo").text("편집 취소");
    } else {
        $("#editOutgoingMailInfo").text("편집하기");
    }
}
/*
발신 메일 정보 업데이트
*/
function update_sender_info(){
    $("#saveChangedOutgoingMailInfo").click(function() {

        const data = {
            c_id : senderInfo.c_id,
            c_smtp_server: $("#smtpServer").val(),
            c_smtp_port: $("#smtpPort").val(),
            c_sender_email: $("#senderEmail").val(),
            c_sender_password: $("#senderPassword").val(),
            c_email_subject: $("#emailSubject").val(),
            c_send_time:$("#senderTime").val()
        };
        $.ajax({
            url: '/auth-user/api/arms/report/mail-sender/updateNode.do',
            type: 'PUT',
            data: data,
            statusCode: {
                200: function () {
                    jSuccess("발신 메일 정보가 수정되었습니다.");
                    get_sender_info();
                    $('.editMailInfo').prop('disabled', true);
                    $('#saveChangedOutgoingMailInfo').addClass("hidden");
                    $("#editOutgoingMailInfo").text("편집 하기");
                }
            },
            error: function(e) {
                console.error('Error:', e);
                jError("SMTP 정보를 수정시 오류가 발생했습니다.");
            }
        });
    });
}

function mail_test(){
    $("#mailTest").click(function() {

        $.ajax({
            url: '/auth-user/api/arms/mail/send-to-registered-users',
            type: 'GET',
            data: data,
            statusCode: {
                200: function () {
                    jSuccess("발신 메일 테스트가 완료되었습니다.");
                }
            },
            error: function(e) {
                console.error('Error:', e);
                jError("발신 메일 테스트 실패");
            }
        });
    });
}

function togglePasswordVisibility(toggleButtonId, passwordFieldId) {
    $(`#${toggleButtonId}`).on('click', function() {
        const $passwordField = $(`#${passwordFieldId}`);
        const $icon = $(this).find('i');

        if ($passwordField.attr('type') === 'password') {
            $passwordField.attr('type', 'text'); // 비밀번호를 보이게
            $icon.removeClass('fa-eye').addClass('fa-eye-slash'); // 아이콘 변경
        } else {
            $passwordField.attr('type', 'password'); // 비밀번호를 숨김
            $icon.removeClass('fa-eye-slash').addClass('fa-eye'); // 아이콘 변경
        }
    });
}

function initializeModal() {
    $('#saveOutgoingMailModal').on("hidden.bs.modal", function () {
        resetSenderModalFields();
    });

    $(".close").click(function() {
        $('#saveOutgoingMailModal').modal('hide');
        resetSenderModalFields();
    });
}

// 모달 입력 필드 초기화 함수
function resetSenderModalFields() {
    $('#saveOutgoingMailModal').find('form')[0].reset();
    $('#modal_smtp_server').val(''); // SMTP 서버 초기화
    $('#modal_smtp_port').val(''); // SMTP 포트 초기화
    $('#modal_sender_email').val(''); // 발신자 이메일 초기화
    $('#modal_sender_password').val(''); // 발신자 비밀번호 초기화
    $('#modal_sender_time').val(''); // 발신 tlrks chrlghk
}
// 발신 메일 정보 필드 초기화
function resetSenderFields() {
    //$('#outgoingMail').find('form')[0].reset();
    $('#smtpServer').val(''); // SMTP 서버 초기화
    $('#smtpPort').val(''); // SMTP 포트 초기화
    $('#senderEmail').val(''); // 발신자 이메일 초기화
    $('#senderPassword').val(''); // 발신자 비밀번호 초기화
    $('#senderTime').val(''); // 발신 tlrks

}

function setSmtpHost() {
    const smtpProvider = $('#smtpProvider').val(); // 선택된 SMTP 제공 업체
    let smtpServer = '';
    let smtpPort = '';

    // 제공 업체별 SMTP 정보 설정
    switch (smtpProvider) {
        case 'smtp.gmail.com':
            smtpServer = 'smtp.gmail.com';
            smtpPort = '587';
            break;
        case 'smtp.office365.com':
            smtpServer = 'smtp.office365.com';
            smtpPort = '587';
            break;
        case 'smtp.naver.com':
            smtpServer = 'smtp.naver.com';
            smtpPort = '465';
            break;
        case 'smtp.daum.net':
            smtpServer = 'smtp.daum.net';
            smtpPort = '465';
            break;
        default:
            resetSenderModalFields();
            return;
    }
    $('#modal_smtp_server').val(smtpServer);
    $('#modal_smtp_port').val(smtpPort);;
}
////////////////////////////////////////////////////////////////////////////////////////
/*
수신 메일 등록
*/
function save_receiver_info() {
    $("#save_receiver").click(function() {
        const receiverName = $('#modal_receiver_name').val();
        const receiverEmail = $('#modal_receiver_email').val();
        const receiverActivate = $('#modal_receiver_activate').val();

        if ( !receiverName || !receiverEmail  ) {
            jError('모든 필드를 입력해 주세요.');
            return;
        }

        // 데이터 객체 생성
        const data = {
            ref:2,
            c_type: "default",
            c_receiver_name: receiverName,
            c_receiver_email: receiverEmail,
            c_receiver_activate : receiverActivate
        };

        console.log(data);

        $.ajax({
            url: '/auth-user/api/arms/report/mail-receiver/addNode.do',
            type: 'POST',
            data: data,
            statusCode: {
                200: function () {
                    jSuccess("수신 메일 정보가 등록 되었습니다.");
                    $("#close_receiver").trigger("click");
                    resetReceiverModalFields();
                    get_receiver_info();
                }
            },
            error: function(e) {
                console.error('Error:', e);
                jError("수신 메일 정보를 저장하는 데 문제가 발생했습니다.");
            }
        });
    });
}

// 모달 입력 필드 초기화 함수
function resetReceiverModalFields() {
    $('#saveIncomingMailModal').find('form')[0].reset();
    $('#modal_receiver_name').val('');
    $('#modal_receiver_email').val('');
}
// 수신 메일 목록 리트스
function get_receiver_info() {
    var columnList = [
        {
            name: "c_receiver_name",
            title: "수신자 이름",
            data: "c_receiver_name",
            render: function (data, type, row, meta) {
                return data ? data : "<span style='color: #aaa'>N/A</span>";
            },
            className: "dt-body-left",
            visible: true
        },
        {
            name: "c_receiver_email",
            title: "수신자 메일",
            data: "c_receiver_email",
            render: function (data, type, row, meta) {
                return data ? data : "<span style='color: #aaa'>N/A</span>";
            },
            className: "dt-body-left",
            visible: true
        },
        {
            name: "c_receiver_activate",
            title: "수신 여부",
            data: "c_receiver_activate",
            render: function (data, type, row, meta) {
                // 빈 값 처리
                return data === "true" ? "활성화" : "비활성화";
            },
            className: "dt-body-left",
            visible: true
        },
        {
            name: "edit",
            title: "편집",
            data: null,
            render: function (data, type, row, meta) {
                return `
                    <div style="text-align: center;">
                        <button  type="button" class="btn btn-success btn-sm edit-btn">
                            <i class="fa fa-external-link"></i> 정보 수정 및 삭제
                        </button>
                    </div>`;
            },
            className: "dt-body-left",
            visible: true
        }
    ];

    var rowsGroupList = [];
    var columnDefList = [{
        "defaultContent": "<div style='color: #f8f8f8'>N/A</div>",
        "targets": "_all"
    }];
    var orderList = [];
    var jquerySelector = "#receiverInfo";

    var ajaxUrl = "/auth-user/api/arms/report/mail-receiver/getNodesWithoutRoot.do";
    var jsonRoot = "result";
    var buttonList = [];
    var selectList = {};
    var isServerSide = false;

    // DataTable 생성
    receiverInfo = dataTable_build(
        jquerySelector,
        ajaxUrl,
        jsonRoot,
        columnList,
        rowsGroupList,
        columnDefList,
        selectList,
        orderList,
        buttonList,
        isServerSide
    );
    // edit-btn 버튼 클릭 이벤트 추가
    $(jquerySelector).on('click', '.edit-btn', function(event) {
        event.preventDefault();
        const rowData = receiverInfo.row($(this).parents('tr')).data();
        showEditModal(rowData);
    });
}
function showEditModal(rowData) {
    $('#modal_edit_receiver_name').val(rowData.c_receiver_name || '');
    $('#modal_edit_receiver_email').val(rowData.c_receiver_email || '');
    $('#modal_edit_receiver_activate').prop('checked', rowData.c_receiver_activate === "true");

    $('#updateIncomingMailModal').data('rowData', rowData);
    // 모달 열기
    $('#updateIncomingMailModal').modal('show');
}

// 데이터 테이블 열 클릭 이벤트
function dataTableClick(tempDataTable, selectedData) {
    console.log("Row clicked:", selectedData);
    // 원하는 동작 추가
}

// 데이터 테이블 렌더링 후 콜백 함수
function dataTableCallBack(settings, json) {
    console.log("DataTable loaded");
}

// 데이터 테이블 재그리기 후 콜백 함수
function dataTableDrawCallback(tableInfo) {
    console.log(tableInfo);
    $("#" + tableInfo.sInstance)
        .DataTable()
        .columns.adjust()
        .responsive.recalc();
}
// 수신자 정보 수정 함수
function update_receiver_info() {
    $("#edit_receiver").click(function() {
        const rowData = $('#updateIncomingMailModal').data('rowData');

        const receiverName = $('#modal_edit_receiver_name').val();
        const receiverEmail = $('#modal_edit_receiver_email').val();
        const receiverActivate = $('#modal_edit_receiver_activate').is(':checked') ? "true" : "false";

        if (!receiverName || !receiverEmail ) {
            jError("모든 필드를 입력해야 합니다.");
            return; // 저장을 차단
        }
        const updatedData = {
            c_id: rowData.c_id,
            c_receiver_name: receiverName,
            c_receiver_email: receiverEmail,
            c_receiver_activate: receiverActivate
        };

        $.ajax({
            url: '/auth-user/api/arms/report/mail-receiver/updateNode.do',
            type: 'PUT',
            data: updatedData,
            success: function() {
                jSuccess("메일 정보가 수정되었습니다.");
                $('#updateIncomingMailModal').modal('hide'); // 모달 닫기
                get_receiver_info(); // 테이블 갱신
            },
            error: function(e) {
                console.error('Error:', e);
                jError("정보를 수정 시 오류가 발생했습니다.");
            }
        });
    });
}
function delete_receiver_info(){
    $("#delete_receiver").click(function() {
        const rowData = $('#updateIncomingMailModal').data('rowData');

        if (!confirm("정말로 삭제하시겠습니까?")) {
            return; // 사용자가 취소를 누르면 삭제 중단
        }

        const data ={
            c_id : rowData.c_id
        };

        $.ajax({
            url: '/auth-user/api/arms/report/mail-receiver/removeNode.do',
            type: 'DELETE',
            data: data,
            success: function() {
                jSuccess("메일 정보가 삭제되었습니다.");
                $('#updateIncomingMailModal').modal('hide'); // 모달 닫기
                get_receiver_info(); // 테이블 갱신
            },
            error: function(e) {
                console.error('Error:', e);
                jError("정보 삭제시 오류가 발생했습니다.");
            }
        });
    });
}

function send_test_mail(){
    $("#send_test_mail").click(function() {

        const mailInfo = $('#modal_edit_receiver_email').val();

        $.ajax({
            url: '/auth-user/api/arms/mail/send-test',
            type: 'POST',
            data: { userEmail: mailInfo },
            statusCode: {
                200: function (data) {
                    jSuccess("테스트 메일 발송 성공");
                }
            },
            error: function(e) {
                console.error('Error:', e);
                jError("테스트 메일 발송 오류");
            }
        });
    });
}


