////////////////////////////////////////////////////////////////////////////////////////
//Page 전역 변수
////////////////////////////////////////////////////////////////////////////////////////
var dataTableRef;
var searchString; // 검색어
var searchRangeType; //날짜 검색 기준. 모든날짜 / 1일 / 7일 / 1달 / 1년 등...
////////////////////////////////////////////////////////////////////////////////////////
//Document Ready
////////////////////////////////////////////////////////////////////////////////////////
function execDocReady() {
	var pluginGroups = [
		[
			"../reference/light-blue/lib/vendor/jquery.ui.widget.js",
			"../reference/light-blue/lib/vendor/http_blueimp.github.io_JavaScript-Templates_js_tmpl.js",
			"../reference/light-blue/lib/vendor/http_blueimp.github.io_JavaScript-Load-Image_js_load-image.js",
			"../reference/light-blue/lib/vendor/http_blueimp.github.io_JavaScript-Canvas-to-Blob_js_canvas-to-blob.js",
			"../reference/light-blue/lib/jquery.iframe-transport.js",
			"../reference/light-blue/lib/jquery.fileupload.js",
			"../reference/light-blue/lib/jquery.fileupload-fp.js",
			"../reference/light-blue/lib/jquery.fileupload-ui.js"
		],
		[
			"../reference/jquery-plugins/dataTables-1.10.16/media/js/jquery.dataTables.min.js",
			"../reference/jquery-plugins/dataTables-1.10.16/extensions/Responsive/js/dataTables.responsive.min.js",
			"../reference/jquery-plugins/dataTables-1.10.16/extensions/Select/js/dataTables.select.min.js",
			"../reference/jquery-plugins/dataTables-1.10.16/extensions/RowGroup/js/dataTables.rowsGroup.min.js",
			"../reference/jquery-plugins/dataTables-1.10.16/extensions/Buttons/js/dataTables.buttons.min.js",
			"../reference/jquery-plugins/dataTables-1.10.16/extensions/Buttons/js/buttons.html5.js",
			"../reference/jquery-plugins/dataTables-1.10.16/extensions/Buttons/js/buttons.print.js",
			"../reference/jquery-plugins/dataTables-1.10.16/extensions/Buttons/js/jszip.min.js"
		],
		[
			"../reference/lightblue4/docs/lib/slimScroll/jquery.slimscroll.min.js",
			"../reference/jquery-plugins/unityping-0.1.0/dist/jquery.unityping.min.js",
			"../reference/lightblue4/docs/lib/widgster/widgster.js"
		],
		[
			// table_new
			"../arms/js/common/table_new.js"
		]
		// 추가적인 플러그인 그룹들을 이곳에 추가하면 됩니다.
	];

	loadPluginGroupsParallelAndSequential(pluginGroups)
		.then(function () {
			console.log("모든 플러그인 로드 완료");
			//상단 메뉴
			$(".widget").widgster();
			setSideMenu("sidebar_menu_system", "sidebar_menu_system_privacy");

			setTimeout(function () {
				var script = document.createElement("script");
				script.src = "../reference/jquery-plugins/dataTables-1.10.16/extensions/Buttons/js/vfs_fonts.js";
				script.defer = true; // defer 속성 설정
				document.head.appendChild(script);
			}, 2000); // 2초 후에 실행됩니다.

			// 높이 조정
			$(".privacy-box").matchHeight({
				target: $(".privacy-box2")
			});

			$(document).trigger($.Event("init.privacyTable1"));
			$(document).trigger($.Event("init.privacyTable2"));
			$(document).trigger($.Event("init.privacyTable3"));
			$(document).trigger($.Event("init.privacyTable5"));
			$(document).trigger($.Event("init.privacyTable6"));
		})
		.catch(function (e) {
			console.error("플러그인 로드 중 오류 발생");
		});
}
+(function ($) {
	// table 1, 2
	let table1columns = [
		{
			name: "category",
			title: "구분",
			data: "category",
			render: function (data, type, row) {
				if (isEmpty(data)) {
					return "<div style='color: #808080'>N/A</div>";
				} else {
					return "<div>" + data + "</div>";
				}
			},
			className: "dt-head-center dt-body-left",
			orderable: false,
			width: "30%",
			visible: true
		},
		{
			name: "purpose",
			title: "자세한 내용",
			data: "purpose",
			render: function (data, type, row) {
				if (isEmpty(data)) {
					return "<div style='color: #808080'>N/A</div>";
				} else {
					return "<div>" + data + "</div>";
				}
			},
			className: "dt-head-center dt-body-left",
			orderable: false,
			width: "70%",
			visible: true
		}
	];
	let table3columns = [
		{
			name: "collectedItems",
			title: "보유 항목",
			data: "collectedItems",
			render: function (data, type, row) {
				if (isEmpty(data)) {
					return "<div style='color: #808080'>N/A</div>";
				} else {
					return "<div>" + data + "</div>";
				}
			},
			className: "dt-head-center dt-body-left",
			orderable: false,
			width: "40%",
			visible: true
		},
		{
			name: "retentionPeriod",
			title: "보유 기간",
			data: "retentionPeriod",
			render: function (data, type, row) {
				if (isEmpty(data)) {
					return "<div style='color: #808080'>N/A</div>";
				} else {
					return "<div>" + data + "</div>";
				}
			},
			className: "dt-head-center dt-body-left",
			orderable: false,
			width: "20%",
			visible: true
		},
		{
			name: "legalBasis",
			title: "법적 근거",
			data: "legalBasis",
			render: function (data, type, row) {
				if (isEmpty(data)) {
					return "<div style='color: #808080'>N/A</div>";
				} else {
					return "<div>" + data + "</div>";
				}
			},
			className: "dt-head-center dt-body-left",
			orderable: false,
			width: "40%",
			visible: true
		}
	];
	// table4 is pass (do not need)
	// table5 - 개인정보의 제공 및 공유
	let table5columns = [
		{
			name: "recipients",
			title: "제공받는 자",
			data: "recipients",
			render: function (data, type, row) {
				if (isEmpty(data)) {
					return "<div style='color: #808080'>N/A</div>";
				} else {
					return "<div>" + data + "</div>";
				}
			},
			className: "dt-head-center dt-body-left",
			orderable: false,
			width: "25%",
			visible: true
		},
		{
			name: "informationProvided",
			title: "제공 항목",
			data: "informationProvided",
			render: function (data, type, row) {
				if (isEmpty(data)) {
					return "<div style='color: #808080'>N/A</div>";
				} else {
					return "<div>" + data + "</div>";
				}
			},
			className: "dt-head-center dt-body-left",
			orderable: false,
			width: "25%",
			visible: true
		},
		{
			name: "purpose",
			title: "제공 목적",
			data: "purpose",
			render: function (data, type, row) {
				if (isEmpty(data)) {
					return "<div style='color: #808080'>N/A</div>";
				} else {
					return "<div>" + data + "</div>";
				}
			},
			className: "dt-head-center dt-body-left",
			orderable: false,
			width: "25%",
			visible: true
		},
		{
			name: "retentionPeriod",
			title: "보유 및 이용기간",
			data: "retentionPeriod",
			render: function (data, type, row) {
				if (isEmpty(data)) {
					return "<div style='color: #808080'>N/A</div>";
				} else {
					return "<div>" + data + "</div>";
				}
			},
			className: "dt-head-center dt-body-left",
			orderable: false,
			width: "25%",
			visible: true
		}
	];
	let table6_1columns = [
		{
			name: "entrustedCompany",
			title: "수탁업체",
			data: "entrustedCompany",
			render: function (data, type, row) {
				if (isEmpty(data)) {
					return "<div style='color: #808080'>N/A</div>";
				} else {
					return "<div>" + data + "</div>";
				}
			},
			className: "dt-head-center dt-body-left",
			orderable: false,
			width: "30%",
			visible: true
		},
		{
			name: "entrustedTasks",
			title: "위탁하는 업무의 내용",
			data: "entrustedTasks",
			render: function (data, type, row) {
				if (isEmpty(data)) {
					return "<div style='color: #808080'>N/A</div>";
				} else {
					return "<div>" + data + "</div>";
				}
			},
			className: "dt-head-center dt-body-left",
			orderable: false,
			width: "70%",
			visible: true
		}
	];
	let table6_2columns = [
		{
			name: "companyName",
			title: "이전업체",
			data: "companyName",
			render: function (data, type, row) {
				if (isEmpty(data)) {
					return "<div style='color: #808080'>N/A</div>";
				} else {
					return "<div>" + data + "</div>";
				}
			},
			className: "dt-head-center dt-body-left",
			orderable: false,
			width: "20%",
			visible: true
		},
		{
			name: "contact",
			title: "연락처",
			data: "contact",
			render: function (data, type, row) {
				if (isEmpty(data)) {
					return "<div style='color: #808080'>N/A</div>";
				} else {
					return "<div>" + data + "</div>";
				}
			},
			className: "dt-head-center dt-body-left",
			orderable: false,
			width: "20%",
			visible: true
		},
		{
			name: "purpose",
			title: "이전목적",
			data: "purpose",
			render: function (data, type, row) {
				if (isEmpty(data)) {
					return "<div style='color: #808080'>N/A</div>";
				} else {
					return "<div>" + data + "</div>";
				}
			},
			className: "dt-head-center dt-body-left",
			orderable: false,
			width: "20%",
			visible: true
		},
		{
			name: "entrustedTasks",
			title: "이전되는 항목",
			data: "entrustedTasks",
			render: function (data, type, row) {
				if (isEmpty(data)) {
					return "<div style='color: #808080'>N/A</div>";
				} else {
					return "<div>" + data + "</div>";
				}
			},
			className: "dt-head-center dt-body-left",
			orderable: false,
			width: "20%",
			visible: true
		},
		{
			name: "entrustedCountry",
			title: "이전되는 국가",
			data: "entrustedCountry",
			render: function (data, type, row) {
				if (isEmpty(data)) {
					return "<div style='color: #808080'>N/A</div>";
				} else {
					return "<div>" + data + "</div>";
				}
			},
			className: "dt-head-center dt-body-left",
			orderable: false,
			width: "20%",
			visible: true
		},
		{
			name: "dateAndProcedure",
			title: "이전 일시 및 방법",
			data: "dateAndProcedure",
			render: function (data, type, row) {
				if (isEmpty(data)) {
					return "<div style='color: #808080'>N/A</div>";
				} else {
					return "<div>" + data + "</div>";
				}
			},
			className: "dt-head-center dt-body-left",
			orderable: false,
			width: "20%",
			visible: true
		},
		{
			name: "retentionPeriod",
			title: "보유∙이용 기간",
			data: "retentionPeriod",
			render: function (data, type, row) {
				if (isEmpty(data)) {
					return "<div style='color: #808080'>N/A</div>";
				} else {
					return "<div>" + data + "</div>";
				}
			},
			className: "dt-head-center dt-body-left",
			orderable: false,
			width: "20%",
			visible: true
		}
	];
	let table6_1Data = [
		{
			entrustedCompany: "와이제이정보㈜",
			entrustedTasks: "SMS 발송"
		},
		{
			entrustedCompany: "KT Alpha",
			entrustedTasks: "모바일 쿠폰발송"
		},
		{
			entrustedCompany: "Amazon Web Services, Inc.",
			entrustedTasks: "데이터 보관 및 인프라 관리"
		},
		{
			entrustedCompany: "비즈쿠팝",
			entrustedTasks: "모바일 쿠폰발송"
		},
		{
			entrustedCompany: "엠퍼니인터랙티브(주)",
			entrustedTasks: "SMS 발송"
		}
	];
	let table6_2Data = [
		{
			companyName: "Google LLC.",
			contact: "Google LLC Privacy Team <br/>	googlekrsupport@google.com",
			purpose: "상담정보 관리",
			entrustedTasks: "회사명, 이름, 부서, 직책 휴대전화번호, 이메일",
			entrustedCountry: "미국, 대만, 일본, 시드니, 싱가포르, EU미국, 대만, 일본, 시드니, 싱가포르, EU",
			dateAndProcedure: "상담신청 시 네트워크를 통한 전송",
			retentionPeriod: "3년"
		},
		{
			companyName: "Salesforce Inc.",
			contact: "Salesforce Data Protection Officer <br/>	privacy@salesforce.com",
			purpose: "상담정보 관리",
			entrustedTasks: "회사, 이름, 직급, 부서, 연락처, 이메일, 상담신청 문의경로, 사업장 위치(상세주소), 문의내용",
			entrustedCountry: "일본",
			dateAndProcedure: "상담 문의 또는 고객관리 시 네트워크를 통한 전송",
			retentionPeriod: "3년"
		}
	];
	let table1Data = [
		{
			category: "회원관리 및 본인확인",
			purpose:
				"회원제 서비스 이용에 따른 본인확인, 개인 식별, 불량회원의 부정 이용 방지와 비인가 사용 방지, 가입 의사 확인, 연령확인 <br/>" +
				"만14세 미만 아동 개인정보 수집 시 법정 대리인 동의여부 확인"
		},
		{
			category: "고객 문의 응대",
			purpose:
				"불만처리 의사소통 경로 확보, 문의 및 민원 응대, 관련 분쟁 예방 및 처리, 고객제안, 고지사항 전달 <br/>" +
				"민원인의 신원확인, 민원사항 확인, 사실조사를 위한 연락·통지, 처리결과 통보 의 목적<br/>" +
				"이메일 문의/신고 접수 및 처리, 결과 회신"
		},
		{
			category: "홍보 이벤트 및 행사 참여",
			purpose:
				"홍보 이벤트 및 행사 참여<br/>" +
				"홍보 이벤트 및 행사 컨텐츠 제작, 컨텐츠를 활용한 방송/SNS 등에서의 홍보 활동<br/>"
		},
		{
			category: "마케팅 등 광고에 활용 (회원에 한정)",
			purpose:
				"상품ㆍ서비스, 사은ㆍ판촉행사, 이벤트 등의 광고성 정보 전달<br/>" +
				"시장조사, 고객만족도조사, 상품ㆍ서비스 개발연구, 접속 빈도 및 고객별 통계분석자료 활용<br/>" +
				"통신판매, 전화권유판매, 전화상담업무, SMSㆍDMㆍTMㆍE-mailㆍPush-mail 발송"
		}
	];
	let table2Data = [
		{
			category: "필수항목",
			purpose: "이름, 생년월일, 이메일주소, 전화번호, 주소, CI값 <br/>" + "웹사이트 이용정보"
		},
		{
			category: "선택항목",
			purpose:
				"회사명, 사업자등록번호, 특허출원번호, 카테고리 및 그 외 개인이 직접 입력한 내용 (제목, 개요, 요약, 파일 )제품모델명, S/N, 구입일, 팩스번호, 회사/부서 <br/>" +
				"민원인의 신원확인, 민원사항 확인, 사실조사를 위한 연락·통지, 처리결과 통보 의 목적<br/>"
		}
	];
	let table3Data = [
		{
			collectedItems: "계약 또는 청약철회 등에 관련 기록",
			retentionPeriod: "5년",
			legalBasis: "전자상거래 등에서의 소비자보호에 관한 법률"
		},
		{
			collectedItems: "대금결제 및 재화 등의 공급에 관한 기록",
			retentionPeriod: "5년",
			legalBasis: "전자상거래 등에서의 소비자보호에 관한 법률"
		},
		{
			collectedItems: "소비자의 불만 또는 분쟁처리에 관한 기록",
			retentionPeriod: "3년",
			legalBasis: "전자상거래 등에서의 소비자보호에 관한 법률"
		},
		{
			collectedItems: "신용정보의 수집/처리 및 이용 등에 관한 기록",
			retentionPeriod: "3년",
			legalBasis: "신용정보의 이용 및 보호에 관한 법률"
		},
		{
			collectedItems: "표시/광고에 관한 기록",
			retentionPeriod: "6개월",
			legalBasis: "전자상거래 등에서의 소비자보호에 관한 법률"
		},
		{
			collectedItems: "이용자의 인터넷 등 로그기록/ 이용자의 접속지 추적자료 그 외의 통신사실 확인 자료",
			retentionPeriod: "3개월 12개월",
			legalBasis: "통신비밀보호법"
		}
	];
	let table5Data = [
		{
			// 제공받는자
			recipients: "313DEVGRP",
			// 제공항목
			informationProvided: "RMS PMS 서비스 제공",
			// 제공목적
			purpose: "5년",
			// 보유 및 이용기간
			retentionPeriod: "서비스 제공기간"
		},
		{
			// 제공받는자
			recipients: "MZC(예시)",
			// 제공항목
			informationProvided: "이름, 회사명, 이메일, 연락처, 부서, 직책",
			// 제공목적
			purpose: "서비스에 관한 의사소통 및 고객 요청 대응",
			// 보유 및 이용기간
			retentionPeriod: "서비스 제공기간"
		}
	];
	let table1Data_bk = [
		{ category: "상담 문의 또는 서비스 신청(체험)", purpose: "상담 업무 처리, 무료체험 서비스 제공" },
		{ category: "교육 신청", purpose: "교육생 정보 관리, 상담 업무 처리, 공지사항 안내" },
		{
			category: "마케팅 및 홍보(구독 포함)",
			purpose: "뉴스레터 전송, 고객 맞춤 마케팅 및 신규 서비스 홍보, 이벤트 정보 제공"
		},
		{ category: "이벤트참가, 설문제출", purpose: "세미나/행사 등의 이벤트 참석자 확인 및 안내, 설문 조사" }
	];
	$(document)
		.one("init.privacyTable1", function () {
			$("#privacyTable1").table({
				order: [],
				columns: table1columns,
				scrollCollapse: false,
				data: table1Data,
				select: false, // 선택 X
				lengthChange: false, // pageLength 변경
				paging: false, // 페이지네이션
				searching: false, // 검색기능
				info: false, // 행(row)수 표시
				drawCallback: function () {
					console.log("table1columns :: drawCallback");
				}
			});
		})
		.one("init.privacyTable2", function () {
			$("#privacyTable2").table({
				order: [],
				columns: table1columns,
				scrollCollapse: false,
				data: table2Data,
				select: false, // 선택 X
				lengthChange: false, // pageLength 변경
				paging: false, // 페이지네이션
				searching: false, // 검색기능
				info: false, // 행(row)수 표시
				drawCallback: function () {
					console.log("table2columns :: drawCallback");
				}
			});
		})
		.one("init.privacyTable3", function () {
			$("#privacyTable3").table({
				order: [],
				columns: table3columns,
				scrollCollapse: false,
				data: table3Data,
				rowsGroup: [2],
				select: false, // 선택 X
				lengthChange: false, // pageLength 변경
				paging: false, // 페이지네이션
				searching: false, // 검색기능
				info: false, // 행(row)수 표시
				drawCallback: function () {
					console.log("table3columns :: drawCallback");
				}
			});
		})
		.one("init.privacyTable5", function () {
			$("#privacyTable5").table({
				order: [],
				columns: table5columns,
				scrollCollapse: false,
				data: table5Data,
				select: false, // 선택 X
				lengthChange: false, // pageLength 변경
				paging: false, // 페이지네이션
				searching: false, // 검색기능
				info: false, // 행(row)수 표시
				drawCallback: function () {
					console.log("table5columns :: drawCallback");
				}
			});
		})
		.one("init.privacyTable6_2", function () {
			$("#privacyTable6-1").table({
				order: [],
				columns: table6_1columns,
				scrollCollapse: false,
				data: table6_1Data,
				select: false, // 선택 X
				lengthChange: false, // pageLength 변경
				paging: false, // 페이지네이션
				searching: false, // 검색기능
				info: false, // 행(row)수 표시
				drawCallback: function () {
					console.log("table3columns :: drawCallback");
				}
			});
			$("#privacyTable6-2").table({
				order: [],
				columns: table6_2columns,
				scrollCollapse: false,
				data: table6_2Data,
				select: false, // 선택 X
				lengthChange: false, // pageLength 변경
				paging: false, // 페이지네이션
				searching: false, // 검색기능
				info: false, // 행(row)수 표시
				drawCallback: function () {
					console.log("table3columns :: drawCallback");
				}
			});
		});
})(jQuery);
