(function () {
	CKEDITOR.plugins.add("accordion", {
		requires: "slashcommand",
		init: function (editor) {
			editor.widgets.add("accordion", {
				template:
					'<div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">' +
					'<div class="panel panel-default">' +
					'<div class="panel-heading" role="tab" id="headingOne">' +
					'<h4 class="panel-title clearfix">' +
					'<a role="button" data-toggle="collapse" data-parent="#accordion" href="#collapseOne" aria-expanded="true" aria-controls="collapseOne">' +
					"Collapsible Group Item #1" +
					"</a>" +
					'<span class="caret pull-right"></span>' +
					"</h4>" +
					"</div>" +
					'<div id="collapseOne" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingOne">' +
					'<div class="panel-body"></div>' +
					"</div>" +
					"</div>" +
					"</div>",

				editables: {
					title: {
						selector: ".panel-title"
					},
					description: {
						selector: ".panel-body"
					}
				}
			});

			if (editor.addMenuItem) {
				editor.addMenuItem("accordion", {
					label: "Accordion",
					group: "slashcommand",
					icon: "requirement",
					onClick: function () {
						editor.execCommand("accordion");
					}
				});
			}

			if (editor.contextMenu) {
				editor.contextMenu.addListener(function () {
					var startElement = editor.getSelection().getStartElement();
					var text = startElement.$.textContent;

					if (/^\/$/.test(text)) {
						return {
							accordion: CKEDITOR.TRISTATE_OFF
						};
					}
				});
			}
		}
	});

	CKEDITOR.ACCORDION = "accordion";
})();
