(function () {
	CKEDITOR.plugins.add("linkeddoc", {
		requires: ["slashcommand", "dialog"],
		init: function (editor) {
			CKEDITOR.dialog.add("linkeddoc", this.path + "dialogs/linkeddoc.js");

			editor.widgets.add("linkeddoc", {
				data: function (data) {
					var html =
						"<div class='thumbnail'>" +
						"<h4>" +
						"<a href=" +
						CKEDITOR.tools.htmlEncode(data.url) +
						">" +
						"<i class='fa fa-file-text'></i>" +
						CKEDITOR.tools.htmlEncode(data.title) +
						"</a>" +
						"</h4>" +
						"<div style='text-wrap: nowrap; overflow: hidden; text-overflow: ellipsis'>" +
						data.desc +
						"</div>" +
						"</div>";

					return CKEDITOR.dom.element.createFromHtml(html, editor.document);
				}
			});

			if (editor.addMenuItem) {
				editor.addMenuItem("linkeddoc", {
					label: "Linked Doc",
					group: "slashcommand",
					icon: "requirement",
					onClick: function () {
						var widget = editor.widgets.registered.linkeddoc;

						editor.openDialog("linkeddoc", function (dialog) {
							console.log();

							dialog.widget = widget;
						});
					}
				});
			}

			if (editor.contextMenu) {
				editor.contextMenu.addListener(function () {
					var startElement = editor.getSelection().getStartElement();
					var text = startElement.$.textContent;

					if (/^\/$/.test(text)) {
						return {
							linkeddoc: CKEDITOR.TRISTATE_OFF
						};
					}
				});
			}
		}
	});

	CKEDITOR.LINKEDDOC = "linkeddoc";
})();
