package com.arms.api.analysis.scope.model.vo;

import static java.util.stream.Collectors.*;

import java.util.Arrays;
import java.util.Set;

import com.arms.api.requirement.reqadd.model.vo.ReqAddVO;
import lombok.*;

@Getter
@NoArgsConstructor
@AllArgsConstructor
@Builder
@EqualsAndHashCode(of={"id"})
public class TreeBarVO {
    private String id;
    private String name;
    private String parent;

    private long value;
    private String color;
    private String type;

    public TreeBarVO(ReqAddVO reqAddVO) {
        this.id = "requirement-" + reqAddVO.getC_id();
        this.name = reqAddVO.getC_title();
        this.parent = reqAddVO.getC_req_pdservice_versionset_link();
        this.value = 0;
        this.color = "";
        this.type = "requirement";
    }

    public Set<Long> reqVersionLinks(){
        return Arrays.stream(this.getParent()
                .replaceAll("\"", "")
                .replace("[", "")
                .replace("]", "")
                .split(","))
            .map(str->Long.valueOf(str.trim()))
            .collect(toSet());
    }
}
