package com.arms.api.patchnote.controller;

import com.arms.api.patchnote.model.PatchnoteDTO;
import com.arms.api.patchnote.model.PatchnoteEntity;
import com.arms.api.patchnote.service.PatchnoteService;
import com.arms.egovframework.javaservice.treeframework.TreeConstant;
import com.arms.egovframework.javaservice.treeframework.controller.TreeAbstractController;
import com.google.common.collect.Maps;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import javax.annotation.PostConstruct;
import java.util.HashMap;

@Slf4j
@Controller
@RestController
@RequiredArgsConstructor
@RequestMapping(value = {"/anonymous/arms/patchnote"})
public class PatchnoteController extends TreeAbstractController<PatchnoteService, PatchnoteDTO, PatchnoteEntity> {

    private final PatchnoteService patchnoteService;

    @PostConstruct
    public void initialize() {
        setTreeService(patchnoteService);
        setTreeEntity(PatchnoteEntity.class);
    }

    // 단일 조회는 TreeAbstractController에서 제공하는 getNode() 사용

    @ResponseBody
    @GetMapping("/getPatchnoteList.do")
    public ModelAndView getPatchnoteList(PatchnoteDTO patchnoteDTO,
                                         @RequestParam(defaultValue = "1") int pageIndex,
                                         @RequestParam(defaultValue = "3") int pageUnit) throws Exception {

        PatchnoteEntity patchnoteEntity = modelMapper.map(patchnoteDTO, PatchnoteEntity.class);
        patchnoteEntity.setPageIndex(pageIndex);
        patchnoteEntity.setPageUnit(pageUnit);

        patchnoteEntity.getCriterions().add(Restrictions.not(
                Restrictions.in("c_id", TreeConstant.ROOT_CID, TreeConstant.First_Node_CID)));
        patchnoteEntity.getOrder().add(Order.desc("c_patchnote_created")); // c_position도 염두

        ModelAndView modelAndView = new ModelAndView("jsonView");
        HashMap<String, Object> resultMap = Maps.newHashMap();
        resultMap.put("paginationInfo", patchnoteEntity.getPaginationInfo());
        resultMap.put("data", patchnoteService.getPaginatedChildNode(patchnoteEntity));
        modelAndView.addObject("result", resultMap);

        return modelAndView;
    }


}
