package com.arms.api.report.export_service.service;

import com.arms.api.report.export_service.enums.ExportType;
import com.arms.api.report.export_service.generator.PptGenerator;
import com.arms.api.report.export_service.model.ReportData;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * PPT 내보내기 서비스
 *
 * @author HS.Yang
 * @since 25.12.03
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class PptExportService implements ReportExportService {

    private final PptGenerator pptGenerator;

    @Override
    public byte[] export(ReportData data) {
        log.info("Exporting report to PPT: {}", data.getTitle());

        long startTime = System.currentTimeMillis();
        byte[] result = pptGenerator.generate(data);
        long elapsed = System.currentTimeMillis() - startTime;

        log.info("PPT export completed - size: {} bytes, time: {}ms", result.length, elapsed);
        return result;
    }

    @Override
    public ExportType getExportType() {
        return ExportType.PPT;
    }
}
