/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.project.controller;

import com.arms.api.project.service.ProjectService;
import com.arms.api.project.vo.ProjectVO;
import com.arms.api.util.errors.ErrorCode;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/{connectId}/jira/project"})
public class ProjectController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectController.class);
    private final ProjectService projectService;

    @ResponseBody
    @RequestMapping(value={"/{projectKeyOrId}"}, method={RequestMethod.GET})
    public ProjectVO getProject(@PathVariable(value="connectId") String connectId, @PathVariable(value="projectKeyOrId") String projectKeyOrId) {
        if (connectId == null) {
            log.error("getProject Error: connectId {}", (Object)ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg(new Object[0]));
            throw new IllegalArgumentException("getProject Error: connectId " + ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg(new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)projectKeyOrId)) {
            log.error("getProject Error projectKeyOrId {}", (Object)ErrorCode.PARAMETER_NULL_ERROR.getErrorMsg(new Object[0]));
            throw new IllegalArgumentException("getProject Error projectKeyOrId " + ErrorCode.PARAMETER_NULL_ERROR.getErrorMsg(new Object[0]));
        }
        return this.projectService.getProject(connectId, projectKeyOrId);
    }

    @ResponseBody
    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public List<ProjectVO> getProjectList(@PathVariable(value="connectId") String connectId) {
        if (connectId == null) {
            log.error("getProjectList Error: connectId {}", (Object)ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg(new Object[0]));
            throw new IllegalArgumentException("getProjectList Error: connectId " + ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg(new Object[0]));
        }
        return this.projectService.getProjectList(connectId);
    }

    @Generated
    public ProjectController(ProjectService projectService) {
        this.projectService = projectService;
    }
}

