package com.arms.api.account.controller;

import com.arms.api.account.model.AlmAccount;
import com.arms.api.account.service.AccountStrategyService;
import com.arms.api.serverinfo.model.ServerInfo;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/alm/account")
@Slf4j
@AllArgsConstructor
public class AccountController {

    private final AccountStrategyService accountStrategyService;


    /*
    *  서버 등록시에 계정 정보
    * */
    @GetMapping("/verify")
    public AlmAccount verifyAccount(ServerInfo serverInfo)throws Exception{

        log.info("계정_컨트롤러 :: 계정정보_검증하기, 서버 정보 데이터: {}", serverInfo);

        return accountStrategyService.verifyAccount(serverInfo);
    }

    /*
    *  계정 정보가 es에 저장된 경우 조회
    * */
    @GetMapping("/{connectId}/mysel")
    public AlmAccount getAccount(@PathVariable("connectId") String 연결_아이디)throws Exception{

        log.info("계정_컨트롤러 :: 계정정보_가져오기, 연결_아이디: {}",연결_아이디);

        return accountStrategyService.getAccount(연결_아이디);
    }



}
