package com.arms.api.clientcase.controller;

import com.arms.api.clientcase.model.ClientCaseContentsDTO;
import com.arms.api.clientcase.service.ClientCaseService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/engine/clientcase")
@Slf4j
@AllArgsConstructor
public class ClientCaseController {

    private final ClientCaseService clientCaseService;

    @GetMapping("/{clientCaseId}")
    public ResponseEntity<ClientCaseContentsDTO> getClientCase(@PathVariable(name = "clientCaseId") String clientCaseId) {
        log.info("[ClientCaseController] GET /engine/clientcase/{}", clientCaseId);
        return ResponseEntity.ok(clientCaseService.getClientCase(clientCaseId));
    }

    @PutMapping
    public ResponseEntity<String> updateClientCase(@RequestBody ClientCaseContentsDTO clientCaseContentsDTO) {
        log.info("[ClientCaseController] PUT /engine/clientcase - c_id: {}", clientCaseContentsDTO.getC_id());
        return ResponseEntity.ok(clientCaseService.updateClientCase(clientCaseContentsDTO));
    }

    @PostMapping
    public ResponseEntity<String> addClientCase(@RequestBody ClientCaseContentsDTO clientCaseContentsDTO) {
        log.info("[ClientCaseController] POST /engine/clientcase - c_id: {}", clientCaseContentsDTO.getC_id());
        return ResponseEntity.ok(clientCaseService.addClientCase(clientCaseContentsDTO));
    }

    @DeleteMapping("/{clientCaseId}")
    public ResponseEntity<String> deleteClientCase(@PathVariable(name = "clientCaseId") String clientCaseId) {
        log.info("[ClientCaseController] DELETE /engine/clientcase/{}", clientCaseId);
        return ResponseEntity.ok(clientCaseService.deleteClientCase(clientCaseId));
    }
}
