package com.arms.api.holidayadmin.service;

import com.arms.api.holidayadmin.model.dto.HolidayDTO;
import com.arms.api.holidayadmin.model.entity.HolidayEntity;
import com.arms.api.holidayadmin.model.vo.HolidayVO;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SortDTO;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentResultWrapper;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import com.arms.egovframework.javaservice.esframework.esquery.SimpleQuery;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
@AllArgsConstructor
public class HolidayServiceImpl implements HolidayService {

    private final EsCommonRepositoryWrapper<HolidayEntity> esCommonRepositoryWrapper;

    @Override
    public String postMessage(HolidayDTO holidayDTO) {

        HolidayEntity save = esCommonRepositoryWrapper.save(holidayDTO.toBbsEntityWithCreate());

        return save.getId();
    }

    @Override
    public String updateBbsAndNewGroupId(HolidayDTO holidayDTO){

        String bbsId = updateBbsAndGetId(holidayDTO);
        HolidayEntity holidayEntity = esCommonRepositoryWrapper.findDocById(bbsId);

        HolidayDTO sourceHolidayDTO = holidayDTO.toBbsDtoWithBoardTypeAndGroupId(holidayEntity);
        HolidayVO holidayVO = this.bbsList(sourceHolidayDTO);

        holidayVO.getBbsEntities().forEach(
                esCommonRepositoryWrapper::save
        );

        return holidayDTO.getId();

    }

    @Override
    public String updateBbsAndGetId(HolidayDTO holidayDTO) {

        HolidayEntity findHolidayEntity = esCommonRepositoryWrapper.findDocById(holidayDTO.getId());

        if(findHolidayEntity ==null){
            throw new IllegalArgumentException("삭제된 게시글입니다.");
        }

        findHolidayEntity.updateHolidayEntity(holidayDTO.toBbsEntityWithUpdate());

        HolidayEntity save = esCommonRepositoryWrapper.save(findHolidayEntity);

        return save.getId();
    }

    @Override
    public String deleteBbsAndGetId(String deleteId) {

        HolidayEntity holidayEntity = esCommonRepositoryWrapper.findDocById(deleteId);

        if(holidayEntity ==null){
            throw new IllegalArgumentException("게시글이 삭제 되어서 찾을수 없습니다..");
        }

        esCommonRepositoryWrapper.deleteById(holidayEntity.getId());

        return deleteId;
    }

    @Override
    public HolidayVO bbsList(HolidayDTO holidayDTO) {

        DocumentResultWrapper<HolidayEntity> docsBySearchAfter = esCommonRepositoryWrapper.findDocsBySearchAfter(
                SimpleQuery.search(holidayDTO)
                    .orderBy(
                        SortDTO.builder().field("group_id").sortType("desc").build(),
                        SortDTO.builder().field("path").sortType("asc").build()
                    )
        );

        List<HolidayEntity> docs = docsBySearchAfter.toDocs();

        return HolidayVO.builder().bbsEntities(docs)
                .totalHits(docsBySearchAfter.getTotalHits())
                .searchAfter(docsBySearchAfter.getLastSortValue()).build();

    }

}

