package com.arms.api.analysis.scope.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;

@Getter
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AssigneeIssueCountVO {

    private String name;
    private String accountId;
    private String emailAddress;

    private long totalCount = 0L;
    private long reqIssueCount = 0L;
    private long subTaskCount = 0L;
    private long linkedIssueCount = 0L;

    public void addReqIssueCount(long count) {
        this.totalCount += count;
        this.reqIssueCount += count;
    }
    public void addSubTaskCount(long count) {
        this.totalCount += count;
        this.subTaskCount += count;
    }
    public void addLinkedIssueCount(long count) {
        this.totalCount += count;
        this.linkedIssueCount += count;
    }
}
