/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.languageconfig.controller;

import com.arms.api.languageconfig.model.vo.LanguagePackFileVO;
import com.arms.api.languageconfig.model.vo.SingleLanguagePackVO;
import com.arms.api.languageconfig.service.LanguageConfigService;
import com.arms.egovframework.javaservice.gcframework.model.RepoType;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/auth-sche/language-config"})
public class LanguageConfigController {
    private static final Logger log = LoggerFactory.getLogger(LanguageConfigController.class);
    private final LanguageConfigService languageConfigService;

    @ApiOperation(value="\uc5b8\uc5b4\ud329 \ud30c\uc77c \ubaa9\ub85d \uc870\ud68c", notes="\uc800\uc7a5\uc18c\uc5d0 \uc788\ub294 \ubaa8\ub4e0 \uc5b8\uc5b4\ud329 \ud30c\uc77c\uc758 \ubaa9\ub85d\uacfc \uc0c1\uc138 \uc815\ubcf4\ub97c \uc870\ud68c\ud569\ub2c8\ub2e4.")
    @GetMapping(value={"/packs/files"})
    public ResponseEntity<List<LanguagePackFileVO>> getLanguagePackFilesNew(@ApiParam(value="\uc800\uc7a5\uc18c \ud0c0\uc785", defaultValue="GITEA", required=true) @RequestParam(defaultValue="GITEA") RepoType repoType) {
        log.info("[ LanguageConfigController :: getLanguagePackFilesNew ] \ub3d9\uc791 : {}", (Object)Calendar.getInstance().getTime());
        return ResponseEntity.ok((Object)this.languageConfigService.getLanguagePackFiles(repoType));
    }

    @ApiOperation(value="\ud2b9\uc815 \uc5b8\uc5b4\ud329 \uc870\ud68c", notes="\uc9c0\uc815\ub41c \uc5b8\uc5b4 \ucf54\ub4dc\uc5d0 \ud574\ub2f9\ud558\ub294 \uc5b8\uc5b4\ud329\uc758 \ubaa8\ub4e0 key-value \uc30d\uc744 \uc870\ud68c\ud569\ub2c8\ub2e4.")
    @GetMapping(value={"/packs/language/{language}"})
    public ResponseEntity<SingleLanguagePackVO> getSingleLanguagePack(@ApiParam(value="\uc5b8\uc5b4 \ucf54\ub4dc (ko, en, ja, cn \ub4f1)", required=true, example="ko") @PathVariable String language) {
        log.info("[ LanguageConfigController :: getSingleLanguagePack ] language: {}, \ub3d9\uc791 : {}", (Object)language, (Object)Calendar.getInstance().getTime());
        return ResponseEntity.ok((Object)this.languageConfigService.getSingleLanguagePack(language));
    }

    @ApiOperation(value="\ud2b9\uc815 \uc5b8\uc5b4\ud329 \uc218\uc815", notes="\uc9c0\uc815\ub41c \uc5b8\uc5b4 \ucf54\ub4dc\uc5d0 \ud574\ub2f9\ud558\ub294 \uc5b8\uc5b4\ud329\uc744 \uc218\uc815\ud558\uac70\ub098 \uc0c8\ub85c\uc6b4 \uc5b8\uc5b4\ud329\uc744 \ucd94\uac00\ud569\ub2c8\ub2e4.")
    @PutMapping(value={"/packs/language/{language}"})
    public ResponseEntity<String> updateSingleLanguagePack(@ApiParam(value="\uc5b8\uc5b4 \ucf54\ub4dc (ko, en, ja, cn \ub4f1)", required=true, example="ko") @PathVariable String language, @RequestBody List<Map<String, String>> data) throws IOException {
        log.info("[ LanguageConfigController :: updateSingleLanguagePack ] language: {}, \ub3d9\uc791 : {}", (Object)language, (Object)Calendar.getInstance().getTime());
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (Map<String, String> item : data) {
            resultMap.putAll(item);
        }
        return ResponseEntity.ok((Object)this.languageConfigService.updateSingleLanguagePack(language, resultMap));
    }

    @GetMapping(value={"/packs/language/{language}/refresh"})
    public ResponseEntity<SingleLanguagePackVO> refreshSingleLanguagePack(@PathVariable String language) {
        log.info("[ LanguageConfigController :: refreshSingleLanguagePack] :: refresh single language => {}", (Object)language);
        return ResponseEntity.ok((Object)this.languageConfigService.refreshSingleLanguagePack(language));
    }

    @ApiOperation(value="\ud2b9\uc815 \uc5b8\uc5b4\ud329 \uc0ad\uc81c", notes="\uc9c0\uc815\ub41c \uc5b8\uc5b4 \ucf54\ub4dc\uc5d0 \ud574\ub2f9\ud558\ub294 \uc5b8\uc5b4\ud329\uc744 \uc0ad\uc81c\ud569\ub2c8\ub2e4.")
    @DeleteMapping(value={"/packs/language/{language}"})
    public ResponseEntity<String> deleteSingleLanguagePack(@PathVariable String language) {
        log.info("[ LanguageConfigController :: deleteSingleLanguagePack ] language: {}, \ub3d9\uc791 : {}", (Object)language, (Object)Calendar.getInstance().getTime());
        return ResponseEntity.ok((Object)this.languageConfigService.deleteSingleLanguagePack(language));
    }

    @ApiOperation(value="\ubaa8\ub4e0 \uc5b8\uc5b4\ud329 \uc870\ud68c", notes="\ubaa8\ub4e0 \uc5b8\uc5b4\uc758 \uc5b8\uc5b4\ud329 \ub0b4\uc6a9\uc744 \uc870\ud68c\ud569\ub2c8\ub2e4. \uac01 \uc5b8\uc5b4\ud329\ubcc4\ub85c key-value \uc30d\uc744 \ubaa9\ub85d\uc73c\ub85c \ubc18\ud658\ud569\ub2c8\ub2e4.")
    @GetMapping(value={"/packs/all-contents"})
    public ResponseEntity<List<SingleLanguagePackVO>> getAllLanguagePackContents() {
        log.info("[ LanguageConfigController :: getAllLanguagePackContents ] \ub3d9\uc791 : {}", (Object)Calendar.getInstance().getTime());
        return ResponseEntity.ok((Object)this.languageConfigService.getAllLanguagePackContents());
    }

    @ApiOperation(value="\ubaa8\ub4e0 \uc5b8\uc5b4\ud329 \uac31\uc2e0 \ubc0f \uc870\ud68c", notes="\ubaa8\ub4e0 \uc5b8\uc5b4\uc758 \uc5b8\uc5b4\ud329 \ub0b4\uc6a9\uc744 \uac31\uc2e0\ud569\ub2c8\ub2e4. \uac01 \uc5b8\uc5b4\ud329\ubcc4\ub85c key-value \uc30d\uc744 \ubaa9\ub85d\uc73c\ub85c \ubc18\ud658\ud569\ub2c8\ub2e4.")
    @GetMapping(value={"/packs/all-contents/refresh"})
    public ResponseEntity<List<SingleLanguagePackVO>> refreshAllLanguagePackContents() {
        log.info("[ LanguageConfigController :: refreshAllLanguagePackContents ] \ub3d9\uc791 : {}", (Object)Calendar.getInstance().getTime());
        return ResponseEntity.ok((Object)this.languageConfigService.refreshAllLanguagePackContents());
    }

    @ApiOperation(value="KEY \uac00 \uc774\ubbf8 \uc874\uc7ac\ud558\ub294\uc9c0 \ud655\uc778 \ubc0f \ubc18\ud658", notes="\ucd94\uac00\ud560 \ud0a4(KEY)\uac00 \uae30\uc874 \uc5b8\uc5b4\ud329\uc5d0 \uc788\ub294\uc9c0 \ud655\uc778\ud569\ub2c8\ub2e4.")
    @GetMapping(value={"/packs/language/{language}/keys/exists"})
    public ResponseEntity<List<String>> checkLanguageKeyExists(@PathVariable String language, @RequestParam(value="keys") List<String> keys) {
        log.info("[ LanguageConfigController :: checkLanguageKeyExists ] \ub3d9\uc791 : {}, NO. of keys : {}", (Object)Calendar.getInstance().getTime(), (Object)keys.size());
        return ResponseEntity.ok((Object)this.languageConfigService.checkLanguageKeyExists(language, keys));
    }

    public LanguageConfigController(LanguageConfigService languageConfigService) {
        this.languageConfigService = languageConfigService;
    }
}

