package com.arms.api.kafka.reqadd.model;

import lombok.*;
import lombok.experimental.SuperBuilder;
import org.springframework.data.annotation.Id;
import org.springframework.data.redis.core.RedisHash;

import java.util.Date;

@Getter
@Setter
@SuperBuilder  // @Builder 대신 @SuperBuilder 사용 ( @Builder 사용 시 상속 관계에서 주의할 점이 있습니다. 부모 클래스의 필드도 빌더에 포함하려면 )
@ToString(callSuper=true)
@NoArgsConstructor
@AllArgsConstructor
public class ReqAddDTO extends TreeBaseDTO {

    private Long c_req_pdservice_link;

    private String c_req_pdservice_versionset_link;

    private Long c_req_priority_link;

    private Long c_req_state_link;

    private Long c_req_difficulty_link;

    private String c_req_reviewer01;

    private String c_req_reviewer02;

    private String c_req_reviewer03;

    private String c_req_reviewer04;

    private String c_req_reviewer05;

    private String c_req_reviewer01_status;

    private String c_req_reviewer02_status;

    private String c_req_reviewer03_status;

    private String c_req_reviewer04_status;

    private String c_req_reviewer05_status;

    private String c_req_writer;

    @Builder.Default private String c_req_owner = "admin";

    private Date c_req_create_date;

    private Date c_req_update_date;

    private Date c_req_start_date;

    private Date c_req_end_date;

    private Long c_req_total_resource; //'총 작업 MM',

    private Long c_req_plan_resource; // '총 계획 MM',

    private Long c_req_total_time; // '총 기간 Day',

    private Long c_req_plan_time; // '총 계획 Day',

    private Long c_req_plan_progress; // '계획 진척도',

    private Long c_req_performance_progress; // '실적 진척도',

    private String c_req_manager; // '담당자'

    private String c_req_output; // '산출물'

    private String c_req_contents;

    private String c_req_desc;

    private String c_req_etc;

    private String c_drawio_contents;

    private String c_drawio_image_raw;

    private String c_drawdb_contents;

}
