////////////////////////////////////////////////////////////////////////////////////////
//Document Ready
////////////////////////////////////////////////////////////////////////////////////////
function execDocReady() {
	var pluginGroups = [
		["../reference/light-blue/lib/vendor/jquery.ui.widget.js", "../reference/lightblue4/docs/lib/widgster/widgster.js"],
		["../reference/lightblue4/docs/lib/bootstrap-select/dist/js/bootstrap-select.min.js"],
		["../../cover/js/util/authorize.js"],
		[
			"../cover/css/blog/base.css",
			"../cover/css/blog/header.css",
			"../cover/css/blog/carousel.css",
			"../cover/css/blog/category-styles.css",
			"../cover/css/blog/content-sections.css",
			"../cover/css/blog/responsive-main.css",
			"../cover/css/blog/tech-sections.css",
			"../cover/css/blog/special-sections.css",
			"../cover/css/blog/widgets-enhancement.css"
		]
		// 추가적인 플러그인 그룹들을 이곳에 추가하면 됩니다.
	];

	loadPluginGroupsParallelAndSequential(pluginGroups)
		.then(function () {
			console.log("모든 플러그인 로드 완료");

			$(".widget").widgster();

			$("#sidebar").hide();
			$(".wrap").css("margin-left", 0);

			$("#footer").load("/cover/html/template/landing-footer.html");

			// 최신 아티클 섹션 초기화
			initializeRecentArticles();
			// 인기 컨텐츠(블로그) 섹션 초기화
			initializePopularBlogSection();
			// 블로그 페이지의 마지막 섹션 초기화
			updateBlogList();
			initializeHotKeywordList();
			initializeRecommendWidget();
			initializeCrudButtonDisplay();
			// -------------------------------------------------

			defineEvents();
			defineSearchFormEvent();
			defineBlogPageEvents();
		})
		.catch(function (error) {
			console.error(error);
		});
}

const globalOnErrorImageURL = "/cover/img/img-onerror.png";

// 여러 곳에서 사용하는 공통 이벤트 정의
function defineEvents() {
	function onHoverZoomInImage() {
		$(".blog-card").hover(
			function () {
				$(this).css("box-shadow", "0 4px 20px rgba(0,0,0,0.15)");
				$(this).css("transform", "translateY(-2px)");
			},
			function () {
				$(this).css("box-shadow", "none");
				$(this).css("transform", "translateY(0)");
			}
		);
	}

	onHoverZoomInImage();
}

// 블로그 검색용 전역 파라미터
var isLoading = false;
// var searchQuery = "";
var afterCount = 0;
var hasMoreData = true;
var currentSearchAfter = [];

var blogSearchComponents = (function () {
	return {
		render: function (articleList) {
			$(".blog-search-section").html(
				articleList.map((article, index) => {
					return createPurchaseArticleHTML(article, index);
				})
			);

			// 최신, 인기, 우측 위젯, 페이지 리스트를 숨김처리해야 합니다.
			$(".row").find(".recent-article-container, .popular-content-container, .posts-container.well, .widget-card, #recommend-widget").hide();
		},
		onSearch: function (_searchAfter, _blogContents, _append) {
			var SIZE = 5;
			var params = {
				size: SIZE,
				searchAfter: _searchAfter
			};

			if (_blogContents) {
				params.c_blog_contents = _blogContents;
			} else {
				// 기존 숨겼던 섹션들을 전부 보여주고 검색 결과 영역을 비웁니다.
				$(".row").find(".recent-article-container, .popular-content-container, .posts-container.well, .widget-card, #recommend-widget").show();
				$(".blog-search-section").empty();
				return;
			}

			$.ajax({
				url: "/auth-anon/api/arms/blog/searchBlogList.do",
				type: "GET",
				data: params,
				beforeSend: function () {
					// 로직
				},
				success: function (data) {
					const { searchAfter, totalHits, blogEntities } = data;

					currentSearchAfter = searchAfter || [];

					if (!blogEntities || blogEntities.length === 0) {
						appendNoContentMessage(".blog-search-section", params.c_blog_contents);
						$(".row").find(".recent-article-container, .popular-content-container, .posts-container.well, .widget-card, #recommend-widget").hide();
						return;
					}
					blogSearchComponents.render(blogEntities);
				},
				error: function () {
					appendNoContentMessage(".blog-search-section", params.c_blog_contents);
				}
			});
		}
	};
})();

function defineSearchFormEvent() {
	$("#blogSearchForm").on("keydown", function (e) {
		if (e.key === "Enter" || e.keyCode === 13) {
			blogSearchComponents.onSearch(currentSearchAfter, $("#blogSearchInput").val(), false);
		}
	});
}

function defineBlogPageEvents() {
	// 동적 아티클 클릭 이벤트 (이전자 작업으로 확인 필요)
	// 동적으로 생성되는 게시글에 대한 이벤트 위임
	$(document).on("click", "[data-article-id]", function (e) {
		// 공유 버튼 등 내부 버튼 클릭 시 이벤트 전파 방지
		if ($(e.target).closest(".post-share, .share-btn").length > 0) {
			return;
		}

		e.preventDefault();
		const articleId = $(this).attr("data-article-id");

		if (articleId) {
			// 블로그 상세 페이지로 이동
			window.location.href = `template.html?page=blogDetail&id=${articleId}`;
		}
	});

	// 게시글에 커서 스타일 추가
	$(document).on("mouseenter", "[data-article-id]", function () {
		$(this).css("cursor", "pointer");
	});

	// 공유 버튼 클릭 이벤트
	$(document).on("click", ".share-btn", function (e) {
		e.preventDefault();
		e.stopPropagation();

		var articleElement = $(this).closest("[data-article-id]");
		var articleId = articleElement.data("article-id");
		var title = articleElement.find(".post-title h3").text();
		var url = window.location.origin + "/cover/template.html?page=blogDetail&id=" + articleId;

		// 공유 기능 구현
		if (navigator.share) {
			navigator
				.share({
					title: title,
					url: url
				})
				.then(() => {
					console.log("공유 완료");
				})
				.catch((error) => {
					console.log("공유 실패:", error);
					fallbackShare(title, url);
				});
		} else {
			fallbackShare(title, url);
		}
	});

	// 더보기 버튼 클릭 이벤트
	$(document).on("click", ".load-more-btn", function (e) {
		e.preventDefault();

		var $btn = $(this);
		var originalText = $btn.find("span").text();

		// 로딩 상태로 변경
		$btn.prop("disabled", true);
		$btn.find("span").text("로딩 중...");
		$btn.find("i").removeClass("fa-chevron-down").addClass("fa-spinner fa-spin");

		// 실제 구현 시 AJAX로 추가 게시물 로드
		setTimeout(function () {
			// 로딩 완료 후 원래 상태로 복원
			$btn.prop("disabled", false);
			$btn.find("span").text(originalText);
			$btn.find("i").removeClass("fa-spinner fa-spin").addClass("fa-chevron-down");
		}, 1000);

		return false;
	});

	// 공유 기능 폴백 todo:: 추후 확인
	function fallbackShare(title, url) {
		// 클립보드에 URL 복사
		if (navigator.clipboard) {
			navigator.clipboard
				.writeText(url)
				.then(() => {
					jSuccess("링크가 클립보드에 복사되었습니다.");
				})
				.catch(() => {
					prompt("다음 링크를 복사하세요:", url);
				});
		} else {
			prompt("다음 링크를 복사하세요:", url);
		}
	}
}

const pageManager = {
	pageIndex: 1,
	pageUnit: 5,
	totalRecordCount: 50,
	lastPageNo: 5 // 마지막 페이지 번호
};

const searchManager = {
	c_blog_title: ""
};

function hideLoadMoreButton() {
	$("#show-more-button").remove();
}

function appendArticlesToContainer(articles) {
	let articleHtml = "";

	if (!articles || articles.length === 0) {
		appendNoContentMessage("#purchase-articles-container", "블로그");
		return;
	}

	articles.forEach((article, index) => {
		articleHtml += createPurchaseArticleHTML(article, index);
	});
	$("#purchase-articles-container").append(articleHtml);
}

// 블로그 페이징 리스트
function updateBlogList() {
	$.ajax({
		url: "/auth-anon/api/arms/blog/getPaginatedBlogList.do",
		type: "GET",
		data: {
			pageIndex: pageManager.pageIndex,
			pageUnit: pageManager.pageUnit
			// c_blog_title은 있을 때만 {} 안에 추가하는 걸로
		},
		success: function (response) {
			const {
				data,
				paginationInfo: { totalRecordCount, lastPageNo }
			} = response;
			pageManager.totalRecordCount = totalRecordCount || 0;
			pageManager.lastPageNo = lastPageNo;

			if (totalRecordCount === 0) {
				hideLoadMoreButton();
				appendNoContentMessage(".posts-container.well", "");
				return;
			}

			appendArticlesToContainer(data);

			const currentlyLoaded = pageManager.pageIndex * pageManager.pageUnit;
			if (currentlyLoaded >= pageManager.totalRecordCount) {
				hideLoadMoreButton();
			}

			pageManager.pageIndex++;
		}
	});
}

function createPurchaseArticleHTML(article, index) {
	return `
        <article class="purchase-post-item base-post-item" data-article-id="${article.c_id}">
            <div class="post-image">
                <img src="${article.c_blog_thumbnail_url || globalOnErrorImageURL}" alt="${article.c_blog_title}">
            </div>
            <div class="post-content">
                <div class="post-title">
                    <h3>${article.c_blog_title}</h3>
                </div>
                <p class="post-excerpt">${article.c_blog_desc}</p>
                <div class="post-meta text-muted">
                    <span class="date"><span class="glyphicon glyphicon-calendar"></span> ${formatDateOrAgo(
											article.c_blog_created
										)}</span>
                </div>
            </div>
            <div class="post-share">
                <button class="share-btn btn btn-sm btn-default" title="공유하기">
                    <i class="fa fa-share-alt"></i>
                </button>
            </div>
        </article>
        ${index < 9 ? '<hr class="post-divider">' : ""}
    `;
}

// 게시글 상세 페이지로 이동하는 함수
function navigateToArticle(articleId) {
	window.location.href = `template.html?page=blogDetail&id=${articleId}`;
}

// 인기 컨텐츠 캐러셀 변수
var currentSlide = 0;
var totalSlides = 0; // JSON 로드 후 설정됨
var visibleSlides = 4;
var slideWidth = 280 + 24; // 카드 너비 + gap

// 모든 캐러셀 함수들을 window 객체에 등록하여 HTML onclick에서 접근 가능하게 함
window.navigateToArticle = navigateToArticle;
window.slideCarousel = slideCarousel;

// 추가적인 이벤트 리스너로 백업 (클릭 이벤트 위임)
$(document).ready(function () {
	// 인기 콘텐츠 캐러셀 버튼 이벤트 (백업)
	$(document).on("click", ".carousel-prev", function (e) {
		e.preventDefault();
		if (typeof slideCarousel === "function") {
			slideCarousel("prev");
		}
	});

	$(document).on("click", ".carousel-next", function (e) {
		e.preventDefault();
		if (typeof slideCarousel === "function") {
			slideCarousel("next");
		}
	});
});

// 최신 게시글 초기화 함수
function initializeRecentArticles() {
	$.ajax({
		url: "/auth-anon/api/arms/blog/latest/getBlogList.do",
		type: "GET",
		success: function (response) {
			renderRecentArticles(response);
		}
	});
}

// 최신 게시글 HTML 렌더링 (layout-container)
function renderRecentArticles(latestArticleList) {
	if (!latestArticleList || latestArticleList.length < 1) {
		appendNoContentMessage(".recent-article-container .pc-layout", "최신");
		return;
	}

	// 메인 카드 (featured true인 첫 번째 아이템)
	const mainArticle = latestArticleList[0];
	// 사이드 카드들 (type이 side인 아이템들)
	const sideCards = latestArticleList.slice(1);

	// 메인 카드 HTML 생성
	let mainCardHtml = `
        <div class="main-card" data-article-id="${mainArticle.c_id}" style="cursor: pointer;">
            <div class="card-image">
                <img src="${mainArticle.c_blog_thumbnail_url || globalOnErrorImageURL}" alt="${
		mainArticle.c_blog_title
	}" class="img-responsive">
            </div>
            <div class="card-content">
                <div class="title">
                    <h3>${mainArticle.c_blog_title}</h3>
                </div>
                 <div class="note">
                <span>${mainArticle.c_blog_desc}</span>
             </div>
		`;

	if (mainArticle.tags) {
		mainCardHtml += `<div class="tags">
                    ${mainArticle.tags
											.map((tag) => `<button class="tag btn btn-default btn-xs">${tag}</button>`)
											.join("")}
                </div>`;
	}

	mainCardHtml += `
                <div class="meta">
                    <span class="date">${formatDateOrAgo(mainArticle.c_blog_created)}</span>
                </div>
            </div>
        </div>`;

	// 사이드 카드들 HTML 생성
	let sideCardsHtml = '<div class="side-cards">';
	sideCards.forEach((card) => {
		sideCardsHtml += `
            <div class="side-card" data-article-id="${card.c_id}" style="cursor: pointer;">
                <div class="card-image">
                    <img src="${card.c_blog_thumbnail_url || globalOnErrorImageURL}" alt="${
			card.c_blog_title
		}" class="img-responsive">
                </div>
                <div class="card-content">
                    <div class="title">
                        <h3>${card.c_blog_title}</h3>
                    </div>
                    <div class="note">
                <span>${card.c_blog_desc}</span>
             </div>`;

		if (card.tags) {
			sideCardsHtml += `<div class="tags">
								${card.tags.map((tag) => `<button class="tag btn btn-default btn-xs">${tag}</button>`).join("")}
						</div>`;
		}
		sideCardsHtml += `
                    <div class="meta">
                        <span class="date">${formatDateOrAgo(mainArticle.c_blog_created)}</span>
                    </div>
                </div>
            </div>`;
	});
	sideCardsHtml += "</div>";

	// layout-container에 HTML 삽입
	const layoutContainer = document.querySelector(".layout-container");
	if (layoutContainer) {
		layoutContainer.innerHTML = mainCardHtml + sideCardsHtml;
	}

	// 닫혔을 경우 대비 무조건 열기
	$(".recent-article-container").show();
}

function updateGenericArrowButtons({ current, total, visible, prevSelector, nextSelector }) {
	const prevBtn = document.querySelector(prevSelector);
	const nextBtn = document.querySelector(nextSelector);
	if (!prevBtn || !nextBtn) return;
	const maxSlide = Math.max(0, total - visible);
	prevBtn.style.display = current === 0 || total <= visible ? "none" : "flex";
	nextBtn.style.display = current >= maxSlide || total <= visible ? "none" : "flex";
}

// 캐러셀 슬라이드 함수
function slideCarousel(direction) {
	slideGenericCarousel({
		direction,
		getCurrent: () => currentSlide,
		setCurrent: (v) => {
			currentSlide = v;
		},
		getTotal: () => totalSlides,
		visible: visibleSlides,
		slideWidth: slideWidth,
		itemsSelector: ".popular-carousel-items",
		prevSelector: ".carousel-prev",
		nextSelector: ".carousel-next",
		withTransition: true
	});
}

// 날짜 포맷
function formatDateOrAgo(dateString) {
	const date = new Date(dateString);
	const now = new Date();

	const diffTime = now - date;
	const diffDays = Math.floor(diffTime / (1000 * 60 * 60 * 24));

	if (diffDays === 0) return "오늘";
	if (diffDays < 30) return `${diffDays}일 전`;
	if (diffDays < 365) return `${Math.floor(diffDays / 30)}달 전`;
	return `${Math.floor(diffDays / 365)}년 전`;
}

function slideGenericCarousel({
	direction,
	getCurrent,
	setCurrent,
	getTotal,
	visible,
	slideWidth,
	itemsSelector,
	prevSelector,
	nextSelector,
	withTransition = true
}) {
	const carousel = document.querySelector(itemsSelector);
	if (!carousel) return;
	const total = typeof getTotal === "function" ? getTotal() : 0;
	const maxSlide = Math.max(0, total - visible);
	let current = typeof getCurrent === "function" ? getCurrent() : 0;
	if (direction === "next" && current < maxSlide) {
		current++;
	} else if (direction === "prev" && current > 0) {
		current--;
	}
	if (typeof setCurrent === "function") setCurrent(current);
	const translateX = -current * slideWidth;
	if (withTransition) {
		carousel.style.transition = "transform 0.3s ease";
	} else {
		carousel.style.transition = "";
	}
	carousel.style.transform = `translateX(${translateX}px)`;
	updateGenericArrowButtons({ current, total, visible, prevSelector, nextSelector });
}

// 인기 콘텐츠 섹션 초기화
function initializePopularBlogSection() {
	// 인기 콘텐츠 카드 클릭 이벤트
	$(document).on("click", ".popular-carousel-item", function () {
		var itemId = $(this).data("id");

		// 상세 페이지로 이동
		if (itemId) {
			navigateToArticle(itemId);
		}
	});

	// 인기 컨텐츠 화살표 버튼 상태 업데이트
	function updateArrowButtons() {
		updateGenericArrowButtons({
			current: currentSlide,
			total: totalSlides,
			visible: visibleSlides,
			prevSelector: ".carousel-prev",
			nextSelector: ".carousel-next"
		});
	}

	$.ajax({
		url: "/auth-anon/api/arms/blog/popular/getBlogList.do",
		type: "GET",
		data: {
			pageIndex: 1,
			pageUnit: 50 // 데이터가 늘어나면 캐러솔과 같이 조정
		},
		success: function (data) {
			if (data.length === 0) {
				appendNoContentMessage(".popular-carousel-wrapper", "인기");
				return;
			}

			// 캐러셀 초기화
			currentSlide = 0;
			totalSlides = data.length;

			// 부드러운 페이드 효과로 콘텐츠 교체
			const carousel = document.querySelector(".popular-carousel-items");
			if (carousel) {
				// 페이드 아웃
				carousel.style.transition = "opacity 0.2s ease-out";
				carousel.style.opacity = "0";

				setTimeout(() => {
					// 콘텐츠 렌더링
					renderPopularContent(data);

					// 캐러셀 위치 초기화
					carousel.style.transform = "translateX(0px)";

					// 페이드 인
					carousel.style.transition = "opacity 0.3s ease-in";
					carousel.style.opacity = "1";

					// 캐러셀 버튼 상태 업데이트
					setTimeout(() => {
						updateArrowButtons();
					}, 50);
				}, 200);
			}
		}
	});

	// 인기 콘텐츠 HTML 렌더링
	function renderPopularContent(data) {
		const carousel = document.querySelector(".popular-carousel-items");

		if (!carousel) {
			console.error("인기 콘텐츠 캐러셀 요소를 찾을 수 없습니다!");
			return;
		}

		let html = "";

		if (!data || data.length === 0) {
			return;
		}

		data.forEach((item) => {
			html += `
            <div class="popular-carousel-item" data-id="${item.c_id}">
                <div class="popular-item-image">
                    <img src="${item.c_blog_thumbnail_url || globalOnErrorImageURL}" alt="${
				item.c_blog_title || ""
			}" class="img-responsive">
                </div>
                <div class="popular-item-content">
                    <div class="popular-item-meta">
                        <span class="popular-publisher"></span>
                    </div>
                    <div class="popular-item-title">
                        <h5>
                            <a href="#" data-id="${item.c_id}">${item.c_blog_title || "제목 없음"}</a>
                        </h5>
                    </div>
                    <div class="popular-item-excerpt">
                        ${item.c_blog_desc || ""}
                    </div>
                    <div class="popular-item-tags">
                        ${
													item.tags && Array.isArray(item.tags)
														? item.tags
																.map(
																	(tag) =>
																		`<button class="popular-tag btn btn-default btn-xs" data-tag="${tag}">${tag}</button>`
																)
																.join("")
														: ""
												}
                    </div>
                    <div class="popular-item-stats">
                        <span><i class="fas fa-eye"></i> 조회수 ${item.c_blog_view_count || 0}</span>
                        <span>|</span>
                        <span>${formatDateOrAgo(item.c_blog_created)}</span>
                    </div>
                </div>
            </div>
        `;
		});

		carousel.innerHTML = html;
	}

	$(".popular-content-container").show();
}

function initializeCrudButtonDisplay() {
	function valid() {}

	function invalid() {
		var button = document.getElementById("blog-write-button");
		if (!button) return;

		button.style.display = "none";
	}

	// 오류 시에는 버튼만 숨기고 전체 페이지를 에러 스크린으로 교체하지는 않음

	validateAdminRole(valid, invalid, invalid);
}

function initializeHotKeywordList() {
	// 태그 스타일 종류 배열 (총 5개)
	const tagStyles = ["label-primary", "label-success", "label-info", "label-warning", "label-danger"];

	function appendToContainer(html) {
		$(".hot-keywords-list").html(html);
	}

	$.ajax({
		url: "/auth-anon/api/arms/blog/hot/getKeywordList.do",
		type: "GET",
		success: function (hotKeywordList) {
			if (hotKeywordList.length < 1) {
				appendNoContentMessage(".hot-keywords-list", "HOT 키워드");
				return;
			}

			let renderingHtml = "";
			hotKeywordList.forEach((keyword, index) => {
				const styleIndex = index % tagStyles.length;
				const repeatingStyle = tagStyles[styleIndex];

				renderingHtml += `<a href="#" class="label ${repeatingStyle} hot-keyword" style="margin: 2px;">${keyword}</a>`;
			});
			appendToContainer(renderingHtml);
		}
	});
}

var isRecommendWidgetAnimating = false;

function initializeRecommendWidget() {
	$.ajax({
		url: "/auth-anon/api/arms/blog/recommended/getBlogList.do",
		type: "GET",
		success: function (data) {
			const html = createRecommendWidgetHtml(data);
			$("#recommend-widget-slide-container").html(html);
			$("#total-slide-number").html(data.length || 0);

			// 이벤트 리스너 등록
			$(document).on("click", ".pagination-prev", function (e) {
				e.preventDefault();
				onSlideRecommendWidget("prev");
			});
			$(document).on("click", ".pagination-next", function (e) {
				e.preventDefault();
				onSlideRecommendWidget("next");
			});
		}
	});
}

function createNoContentHtml(subject) {
	return `<div class="blog-not-found-screen" style="display: flex; flex-direction: column; align-items: center; justify-content: center; height: 200px; margin-bottom: 16px;">
			<div style="font-size: 48px; margin-bottom: 16px; opacity: 0.5;">📝</div>
			<div style="font-size: 18px; margin-bottom: 8px;">${subject || ""} 블로그가 없습니다.</div>
	</div>`;
}

function appendNoContentMessage(containerSelector, subject) {
	const $container = $(containerSelector);

	if ($container.length > 0) {
		$container.html(createNoContentHtml(subject));
	}
}

function createRecommendWidgetHtml(dataArray) {
	if (!dataArray || dataArray.length < 1) {
		appendNoContentMessage("#recommend-widget-slide-container", "추천");
		$(".panel-footer").hide();
		return;
	}

	let html = "";

	dataArray.forEach((article, index) => {
		html += `<div class="panel-body" key="recommended-widget-${index}" style="${
			index === 0 ? "" : "display: none;"
		}" data-slide-id="${index}">
			<div class="widget-image thumbnail" style="padding: 0; margin-bottom: 0;">
				<img src='${
					article.c_blog_thumbnail_url || "/cover/img/img-onerror.png"
				}' alt="추천 게시글 썸네일" class="img-responsive" style="border-radius: 0;" />
			</div>
			<div class="widget-content">
				<h4 class="widget-title h4">${article.c_blog_title}</h4>
				<p class="widget-excerpt text-muted small">${article.c_blog_desc}</p>`;

		// 키워드 기능은 나중에 구현
		if (article.tags && Array.isArray(article.tags)) {
			html += `<div class="widget-tags">
				<span class="label label-default">#스마트계약</span>
				<span class="label label-default">#블록체인</span>
				<span class="label label-default">#디지털구매</span>
				<span class="label label-default">#구매투명성</span>
			</div>`;
		}

		html += `<div class="widget-meta text-muted">
				<span class="widget-date text-muted"><span
					class="glyphicon glyphicon-calendar"></span> ${formatDateOrAgo(article.c_blog_created)}</span>
				</div>
			</div>
		</div>`;
	});

	return html;
}

function onSlideRecommendWidget(direction) {
	if (isRecommendWidgetAnimating) {
		return;
	}

	const $container = $("#recommend-widget-slide-container");
	const $panels = $container.find(".panel-body");
	const totalPanels = $panels.length;
	if (totalPanels === 0) return;

	let $current = $panels.filter(":visible");
	if ($current.length === 0) {
		$current = $panels.eq(0);
	}

	const currentIndex = $panels.index($current);
	let newIndex;
	if (direction === "next") {
		newIndex = (currentIndex + 1) % totalPanels;
	} else {
		newIndex = (currentIndex - 1 + totalPanels) % totalPanels;
	}

	const $next = $panels.eq(newIndex);

	if ($next.is($current)) {
		return;
	}

	isRecommendWidgetAnimating = true;

	$current.fadeOut(300, function () {
		$next.fadeIn(300, function () {
			isRecommendWidgetAnimating = false;
		});
	});

	$("#current-slide-number").html(newIndex + 1);
}
