var isLoading = false;
var afterCount = 0;
var hasMoreData = true;
var currentSearchAfter = [];

////////////////////////////////////////////////////////////////////////////////////////
//Document Ready
////////////////////////////////////////////////////////////////////////////////////////
function execDocReady() {
	checkAdminAccess(function() {
		let pluginGroups = [
			["../reference/light-blue/lib/vendor/jquery.ui.widget.js", "../reference/lightblue4/docs/lib/widgster/widgster.js"],
			["../reference/lightblue4/docs/lib/bootstrap-select/dist/js/bootstrap-select.min.js"]
		];

		loadPluginGroupsParallelAndSequential(pluginGroups)
			.then(function () {
				console.log("모든 플러그인 로드 완료");

				$(".widget").widgster();
				$('.selectpicker').selectpicker();
				$("#sidebar").hide();
				$(".wrap").css("margin-left", 0);
				$("#footer").load("/cover/html/template/landing-footer.html");

				loadPocData([], false);
				loadStatistics();
			})
			.catch(function (error) {
				console.error("플러그인 로드 중 오류 발생");
				console.error(error);
			});
	});
}

function createLoadingRow() {
	return `
		<tr class="loading-row">
			<td colspan="12" class="text-center" style="padding: 20px;">
				<i class="fa fa-spinner fa-spin"></i> 로딩 중...
			</td>
		</tr>
	`;
}

function createLoadMoreButton(_searchAfter) {
	return `
		<tr id="load-more-row">
			<td colspan="12" class="text-center" style="padding: 15px;">
				<button id="load-more-btn" class="btn btn-info" onclick="loadPocData('${_searchAfter}', true)">
					<i class="fa fa-plus"></i> 더 보기
				</button>
			</td>
		</tr>
	`;
}

function createNoDataRow() {
	return `
		<tr>
			<td colspan="12" class="text-center" style="padding: 30px; color: #666;">
				<i class="fa-solid fa-text-slash"></i> 등록된 POC 요청이 없습니다.
			</td>
		</tr>
	`;
}

function loadPocData(_searchAfter, _append) {
	var $tbody = $("#poc-tbody");
	var SIZE = 10;

	if (isLoading) {
		return;
	}
	isLoading = true;

	if (_searchAfter && _searchAfter.length > 0) {
		afterCount++;
	}

	var params = {
		size: SIZE,
		searchAfter: _searchAfter
	};

	$.ajax({
		url: "/auth-anon/api/arms/poc/getPocList.do",
		type: "GET",
		data: params,
		beforeSend: function () {
			if (!_append) {
				$tbody.html(createLoadingRow());
			}
		},
		success: function (response) {
			if (!response.success || !response.response) {
				$(".loading-row").remove();
				if (!_append) {
					$tbody.html(createNoDataRow());
				}
				hasMoreData = false;
				isLoading = false;
				return;
			}

			let data = response.response;
			let totalCount = data.totalHits || 0;
			let items = data.pocEntities || [];

			let strTotalCount = Number(totalCount).toLocaleString();
			if (totalCount >= 10000) {
				strTotalCount += "+";
			}
			$("#table_total_counts").text(strTotalCount);

			if (!_append) {
				$tbody.empty();
				afterCount = 0;
			} else {
				$("#load-more-row").remove();
			}

			if (totalCount > 0 && totalCount <= (1 + afterCount) * SIZE) {
				hasMoreData = false;
			} else {
				hasMoreData = !(items && items.length < SIZE);
			}

			if (totalCount === 0 || !items || items.length === 0) {
				$tbody.html(createNoDataRow());
				isLoading = false;
				return;
			}

			items.forEach(function (item) {
				$tbody.append(createPocRow(item));
			});

			currentSearchAfter = data.searchAfter;

			if (hasMoreData) {
				$tbody.append(createLoadMoreButton(currentSearchAfter));
			}

			isLoading = false;
		},
		error: function () {
			$(".loading-row").remove();
			$("#load-more-row").remove();
			isLoading = false;
			hasMoreData = false;
		},
		complete: function () {
			isLoading = false;
		}
	});
}

function createPocRow(item) {
	let statusBadge = getStatusBadge(item.c_poc_status);

	return `
		<tr>
			<td style="text-align: center;">${statusBadge}</td>
			<td>${item.c_poc_assignee_name || ''}</td>
			<td>${item.c_poc_company_name || ''}</td>
			<td>${item.c_poc_full_name}</td>
			<td>${item.c_poc_job_title || ''}</td>
			<td>${item.c_poc_company_size || ''}</td>
			<td><a href="mailto:${item.c_poc_email_address}">${item.c_poc_email_address || ''}</a></td>
			<td>${item.c_poc_contact_number || ''}</td>
			<td>${item.c_poc_inquiry_reason || ''}</td>
			<td>${item.c_poc_country || ''}</td>
			<td>${formatDate(item.c_poc_inquiry_date)}</td>
			<td>
				<button class="btn btn-xs btn-default" onclick="goToDetail('${item.id}')" title="상세보기">
					<i class="fa fa-arrow-right"></i>
				</button>
			</td>
		</tr>
	`;
}

function formatDate(dateObj) {
	if (!dateObj) return '';

	if (typeof dateObj === 'object' && dateObj.year) {
		return dateObj.year + '.' +
			String(dateObj.monthValue).padStart(2, '0') + '.' +
			String(dateObj.dayOfMonth).padStart(2, '0');
	}

	try {
		let date = new Date(dateObj);
		if (!isNaN(date.getTime())) {
			return date.toLocaleDateString();
		}
	} catch (e) {
		console.error("날짜 파싱 실패:", e);
	}

	return '';
}

function getStatusBadge(status) {
	if (!status) return '';

	let lowerStatus = status.toLowerCase();

	let badges = {
		pending: '<span style="color: #FA751E;">대기</span>',
		inprogress: '<span style="color: #1e96eb;">진행</span>',
		completed: '<span style="color: #28a745;">완료</span>',
		canceled: '<span style="color: #d73a49;">취소</span>'
	};
	return badges[lowerStatus] || status;
}

function goToDetail(id) {
	window.location.href = "/cover/template.html?page=pocAdminDetail&id=" + id;
}

function loadStatistics() {

	$.ajax({
		url: "/auth-anon/api/arms/poc/getPocList.do",
		type: "GET",
		data: {
			page: 0,
			size: 1
		},
		success: function(response) {
			if (response.success && response.response) {
				$("#totalCount").text(response.response.totalHits || 0);
			}
		},
		error: function(xhr, status, error) {
			console.error("통계 데이터 로드 실패:", error);
			$("#totalCount").text("0");
		}
	});
}

function checkAdminAccess(callback) {
	$.ajax({
		url: "/auth-user/me",
		type: "GET",
		timeout: 7313,
		global: false,
		statusCode: {
			200: function (json) {
				console.log("[ POC Admin :: authUserCheck ] userName = " + json.preferred_username);
				console.log("[ POC Admin :: authUserCheck ] roles = " + json.realm_access.roles);

				var permissions = json.realm_access.roles;

				if (permissions && permissions.indexOf("ROLE_ADMIN") != -1) {
					if (callback) callback();
				} else {
					window.location.href = '/cover/template.html?page=poc';
				}
			},
			401: function() {
				window.location.href = '/cover/template.html?page=poc';
			}
		},
		error: function() {
			window.location.href = '/cover/template.html?page=poc';
		}
	});
}
