/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml.model;

import java.time.temporal.TemporalUnit;
import org.ehcache.xml.XmlModel;
import org.ehcache.xml.model.ExpiryType;
import org.ehcache.xml.model.TimeType;

public class Expiry {
    private final ExpiryType type;

    public Expiry(ExpiryType type) {
        this.type = type;
    }

    public boolean isUserDef() {
        return this.type != null && this.type.getClazz() != null;
    }

    public boolean isTTI() {
        return this.type != null && this.type.getTti() != null;
    }

    public boolean isTTL() {
        return this.type != null && this.type.getTtl() != null;
    }

    public String type() {
        return this.type.getClazz();
    }

    public long value() {
        TimeType time = this.isTTI() ? this.type.getTti() : this.type.getTtl();
        return time == null ? 0L : time.getValue().longValue();
    }

    public TemporalUnit unit() {
        TimeType time = this.isTTI() ? this.type.getTti() : this.type.getTtl();
        if (time != null) {
            return XmlModel.convertToJavaTemporalUnit(time.getUnit());
        }
        return null;
    }
}

