/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.rest.data;

import java.io.IOException;
import org.apache.http.client.ClientProtocolException;

public class Result {
    private final Status status;
    private final Integer httpStatus;
    private final String message;

    private Result(Status status, Integer httpStatus, String message) {
        this.status = status;
        this.httpStatus = httpStatus;
        this.message = message;
    }

    public static Result fromHttpCode(int statusCode, String responseBody) {
        Status status;
        switch (statusCode) {
            case 200: {
                status = Status.SUCCESS;
                break;
            }
            case 400: {
                status = Status.CLIENT_ERROR;
                break;
            }
            case 401: {
                status = Status.AUTHENTICATION_ERROR;
                break;
            }
            case 403: {
                status = Status.MESSAGE_QUOTA_EXCEEDED;
                break;
            }
            case 404: {
                status = Status.NOT_FOUND;
                break;
            }
            default: {
                status = statusCode >= 500 && statusCode < 600 ? Status.SERVER_ERROR : Status.UNKNOWN_ERROR;
            }
        }
        return new Result(status, statusCode, responseBody);
    }

    public static Result fromException(IOException e) {
        return new Result(Status.NETWORK_ERROR, null, e.toString());
    }

    public static Result fromException(ClientProtocolException e) {
        return new Result(Status.UNKNOWN_ERROR, null, e.toString());
    }

    public Status getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public Integer getHttpStatus() {
        return this.httpStatus;
    }

    public static enum Status {
        SUCCESS(false),
        CLIENT_ERROR(false),
        AUTHENTICATION_ERROR(false),
        MESSAGE_QUOTA_EXCEEDED(false),
        NOT_FOUND(false),
        SERVER_ERROR(true),
        NETWORK_ERROR(true),
        UNKNOWN_ERROR(true);

        private final boolean shouldRetry;

        private Status(boolean shouldRetry) {
            this.shouldRetry = shouldRetry;
        }

        public boolean shouldRetry() {
            return this.shouldRetry;
        }
    }
}

