(function () {
	CKEDITOR.plugins.add("requirement", {
		init: function (editor) {
			CKEDITOR.skin.addIcon("requirement", this.path + "icon/313.png");

			editor.addCommand("requirement", {
				context: "requirement",
				exec: function () {
					var selectedText = editor.getSelection().getSelectedText();
					editor.fire("createRequirement", { reqTitle: selectedText });
				}
			});

			editor.ui.addButton("requirement", {
				label: "신규 요구사항 생성",
				command: "requirement",
				toolbar: "basicstyles,1"
			});

			if (editor.addMenuItem) {
				editor.addMenuGroup("requirement");
				editor.addMenuItem("requirement", {
					label: "신규 요구사항 등록",
					group: "requirement",
					icon: "requirement"
				});

				editor.getMenuItem("requirement").onClick = function () {
					var selectedText = editor.getSelection().getSelectedText();
					editor.fire("createRequirement", { reqTitle: selectedText });
				};
			}

			if (editor.contextMenu) {
				editor.contextMenu.addListener(function () {
					var selectedText = editor.getSelection().getSelectedText();

					if (selectedText.trim() !== "") {
						return {
							requirement: CKEDITOR.TRISTATE_OFF
						};
					}
				});
			}
		}
	});
})();
