--
-- Table structure for table `T_ARMS_PATCHNOTE`
--
CREATE TABLE IF NOT EXISTS `aRMS`.`T_ARMS_PATCHNOTE_LOG` (

    `c_id`                                  bigint(20) NOT NULL COMMENT '노드 아이디',
    `c_parentid`                            bigint(20) NOT NULL COMMENT '부모 노드 아이디',
    `c_position`                            bigint(20) NOT NULL COMMENT '노드 포지션',
    `c_left`                                bigint(20) NOT NULL COMMENT '노드 좌측 끝 포인트',
    `c_right`                               bigint(20) NOT NULL COMMENT '노드 우측 끝 포인트',
    `c_level`                               bigint(20) NOT NULL COMMENT '노드 DEPTH',
    `c_title`                               VARCHAR(255) COMMENT '노드 명',
    `c_type`                                VARCHAR(255) COMMENT '노드 타입',

    `c_method`                              text NULL COMMENT '노드 변경 행위',
    `c_state`                               text NULL COMMENT '노드 상태값 ( 이전인지. 이후인지)',
    `c_date`                                DATETIME NULL COMMENT '노드 변경 시',

    `c_patchnote_category`                  VARCHAR(255) COMMENT '카테고리',
    `c_patchnote_title`                     VARCHAR(255) COMMENT '제목',
    `c_patchnote_subtitle`                  VARCHAR(255) COMMENT '부제목',
    `c_patchnote_author_id`                 VARCHAR(255) COMMENT '작성자 아이디',
    `c_patchnote_author_name`               VARCHAR(255) COMMENT '작성자 명',
    `c_patchnote_created`                   DATETIME NULL COMMENT '작성일',
    `c_patchnote_updated`                   DATETIME NULL COMMENT '수정일',
    `c_patchnote_visibility`                VARCHAR(255) COMMENT '공개범위',

    `c_patchnote_slug`                     	VARCHAR(255) COMMENT '슬러그 (URL)',
    `c_patchnote_thumbnail_url`             VARCHAR(500) COMMENT '썸네일 URL',

    `c_patchnote_etc`                 		VARCHAR(255)    COMMENT '비고',
    `c_patchnote_desc`                		text            COMMENT '설명',
    `c_patchnote_contents`            		longtext        COMMENT '내용'

    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='patchnote 테이블 로그';


CREATE TABLE IF NOT EXISTS `aRMS`.`T_ARMS_PATCHNOTE` (

    `c_id`                                   bigint(20) AUTO_INCREMENT primary key COMMENT '노드 아이디',
    `c_parentid`                             bigint(20) NOT NULL COMMENT '부모 노드 아이디',
    `c_position`                             bigint(20) NOT NULL COMMENT '노드 포지션',
    `c_left`                                 bigint(20) NOT NULL COMMENT '노드 좌측 끝 포인트',
    `c_right`                                bigint(20) NOT NULL COMMENT '노드 우측 끝 포인트',
    `c_level`                                bigint(20) NOT NULL COMMENT '노드 DEPTH',
    `c_title`                                VARCHAR(255) COMMENT '노드 명',
    `c_type`                                 VARCHAR(255) COMMENT '노드 타입',

    `c_patchnote_category`                   VARCHAR(255) COMMENT '카테고리',
    `c_patchnote_title`                      VARCHAR(255) COMMENT '제목',
    `c_patchnote_subtitle`                   VARCHAR(255) COMMENT '부제목',
    `c_patchnote_author_id`                  VARCHAR(255) COMMENT '작성자 아이디',
    `c_patchnote_author_name`                VARCHAR(255) COMMENT '작성자 명',
    `c_patchnote_created`                    DATETIME NULL COMMENT '작성일',
    `c_patchnote_updated`                    DATETIME NULL COMMENT '수정일',
    `c_patchnote_visibility`                 VARCHAR(255) COMMENT '공개범위',

    `c_patchnote_slug`                     	 VARCHAR(255) COMMENT '슬러그 (URL)',
    `c_patchnote_thumbnail_url`              VARCHAR(500) COMMENT '썸네일 URL',

    `c_patchnote_etc`                 		 VARCHAR(255)    COMMENT '비고',
    `c_patchnote_desc`                		 text            COMMENT '설명',
    `c_patchnote_contents`            		 longtext        COMMENT '내용'

    ) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='patchnote 테이블';

DELIMITER $$
CREATE TRIGGER TG_INSERT_T_ARMS_PATCHNOTE
    BEFORE  INSERT ON T_ARMS_PATCHNOTE
    FOR EACH ROW
BEGIN
    insert into T_ARMS_PATCHNOTE_LOG (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_METHOD, C_STATE, C_DATE)
    values (NEW.C_ID,NEW.C_PARENTID,NEW.C_POSITION,NEW.C_LEFT,NEW.C_RIGHT,NEW.C_LEVEL,NEW.C_TITLE,NEW.C_TYPE,'update','변경이전데이터',now());
END $$
DELIMITER ;

DELIMITER $$
CREATE TRIGGER TG_UPDATE_T_ARMS_PATCHNOTE
    BEFORE  UPDATE ON T_ARMS_PATCHNOTE
    FOR EACH ROW
BEGIN
    insert into T_ARMS_PATCHNOTE_LOG (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_METHOD, C_STATE, C_DATE)
    values (OLD.C_ID,OLD.C_PARENTID,OLD.C_POSITION,OLD.C_LEFT,OLD.C_RIGHT,OLD.C_LEVEL,OLD.C_TITLE,OLD.C_TYPE,'update','변경이전데이터',now());

    insert into T_ARMS_PATCHNOTE_LOG (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_METHOD, C_STATE, C_DATE)
    values (NEW.C_ID,NEW.C_PARENTID,NEW.C_POSITION,NEW.C_LEFT,NEW.C_RIGHT,NEW.C_LEVEL,NEW.C_TITLE,NEW.C_TYPE,'update','변경이후데이터',now());
END $$
DELIMITER ;

DELIMITER $$
CREATE TRIGGER TG_DELETE_T_ARMS_PATCHNOTE
    BEFORE  DELETE ON T_ARMS_PATCHNOTE
    FOR EACH ROW
BEGIN
    insert into T_ARMS_PATCHNOTE_LOG (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_METHOD, C_STATE, C_DATE)
    values (OLD.C_ID,OLD.C_PARENTID,OLD.C_POSITION,OLD.C_LEFT,OLD.C_RIGHT,OLD.C_LEVEL,OLD.C_TITLE,OLD.C_TYPE,'delete','삭제된데이터',now());
END $$
DELIMITER ;

Insert into `aRMS`.`T_ARMS_PATCHNOTE` (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE)
Values (1, 0, 0, 1, 4, 0, 'T_ARMS_PATCHNOTE', 'root');
Insert into `aRMS`.`T_ARMS_PATCHNOTE` (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE)
Values (2, 1, 0, 2, 3, 1, '패치노트', 'drive');


--
-- Table structure for table `T_ARMS_BLOG`
--
CREATE TABLE IF NOT EXISTS `aRMS`.`T_ARMS_BLOG_LOG` (

    `c_id`                                  bigint(20) NOT NULL COMMENT '노드 아이디',
    `c_parentid`                            bigint(20) NOT NULL COMMENT '부모 노드 아이디',
    `c_position`                            bigint(20) NOT NULL COMMENT '노드 포지션',
    `c_left`                                bigint(20) NOT NULL COMMENT '노드 좌측 끝 포인트',
    `c_right`                               bigint(20) NOT NULL COMMENT '노드 우측 끝 포인트',
    `c_level`                               bigint(20) NOT NULL COMMENT '노드 DEPTH',
    `c_title`                               VARCHAR(255) COMMENT '노드 명',
    `c_type`                                VARCHAR(255) COMMENT '노드 타입',

    `c_method`                              text NULL COMMENT '노드 변경 행위',
    `c_state`                               text NULL COMMENT '노드 상태값 ( 이전인지. 이후인지)',
    `c_date`                                DATETIME NULL COMMENT '노드 변경 시',

    `c_blog_category`                       VARCHAR(255) COMMENT '카테고리',
    `c_blog_title`                          VARCHAR(255) COMMENT '제목',
    `c_blog_subtitle`                       VARCHAR(255) COMMENT '부제목',
    `c_blog_author_id`                      VARCHAR(255) COMMENT '작성자 아이디',
    `c_blog_author_name`                    VARCHAR(255) COMMENT '작성자 명',
    `c_blog_created`                        DATETIME NULL COMMENT '작성일',
    `c_blog_updated`                        DATETIME NULL COMMENT '수정일',
    `c_blog_visibility`                     VARCHAR(255) COMMENT '공개범위',

    `c_blog_slug`                     		VARCHAR(255) COMMENT '슬러그 (URL)',
    `c_blog_thumbnail_url`                  VARCHAR(500) COMMENT '썸네일 URL',

    `c_blog_etc`                 			VARCHAR(255)    COMMENT '비고',
    `c_blog_desc`                			text            COMMENT '설명',
    `c_blog_contents`            			longtext        COMMENT '내용'

    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='blog 테이블 로그';


CREATE TABLE IF NOT EXISTS `aRMS`.`T_ARMS_BLOG` (

    `c_id`                                   bigint(20) AUTO_INCREMENT primary key COMMENT '노드 아이디',
    `c_parentid`                             bigint(20) NOT NULL COMMENT '부모 노드 아이디',
    `c_position`                             bigint(20) NOT NULL COMMENT '노드 포지션',
    `c_left`                                 bigint(20) NOT NULL COMMENT '노드 좌측 끝 포인트',
    `c_right`                                bigint(20) NOT NULL COMMENT '노드 우측 끝 포인트',
    `c_level`                                bigint(20) NOT NULL COMMENT '노드 DEPTH',
    `c_title`                                VARCHAR(255) COMMENT '노드 명',
    `c_type`                                 VARCHAR(255) COMMENT '노드 타입',

    `c_blog_category`                       VARCHAR(255) COMMENT '카테고리',
    `c_blog_title`                          VARCHAR(255) COMMENT '제목',
    `c_blog_subtitle`                       VARCHAR(255) COMMENT '부제목',
    `c_blog_author_id`                      VARCHAR(255) COMMENT '작성자 아이디',
    `c_blog_author_name`                    VARCHAR(255) COMMENT '작성자 명',
    `c_blog_created`                        DATETIME NULL COMMENT '작성일',
    `c_blog_updated`                        DATETIME NULL COMMENT '수정일',
    `c_blog_visibility`                     VARCHAR(255) COMMENT '공개범위',

    `c_blog_slug`                     		VARCHAR(255) COMMENT '슬러그 (URL)',
    `c_blog_thumbnail_url`                  VARCHAR(500) COMMENT '썸네일 URL',

    `c_blog_etc`                 			VARCHAR(255)    COMMENT '비고',
    `c_blog_desc`                			text            COMMENT '설명',
    `c_blog_contents`            			longtext        COMMENT '내용'

    ) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='blog 테이블';

DELIMITER $$
CREATE TRIGGER TG_INSERT_T_ARMS_BLOG
    BEFORE  INSERT ON T_ARMS_BLOG
    FOR EACH ROW
BEGIN
    insert into T_ARMS_BLOG_LOG (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_METHOD, C_STATE, C_DATE)
    values (NEW.C_ID,NEW.C_PARENTID,NEW.C_POSITION,NEW.C_LEFT,NEW.C_RIGHT,NEW.C_LEVEL,NEW.C_TITLE,NEW.C_TYPE,'update','변경이전데이터',now());
END $$
DELIMITER ;

DELIMITER $$
CREATE TRIGGER TG_UPDATE_T_ARMS_BLOG
    BEFORE  UPDATE ON T_ARMS_BLOG
    FOR EACH ROW
BEGIN
    insert into T_ARMS_BLOG_LOG (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_METHOD, C_STATE, C_DATE)
    values (OLD.C_ID,OLD.C_PARENTID,OLD.C_POSITION,OLD.C_LEFT,OLD.C_RIGHT,OLD.C_LEVEL,OLD.C_TITLE,OLD.C_TYPE,'update','변경이전데이터',now());

    insert into T_ARMS_BLOG_LOG (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_METHOD, C_STATE, C_DATE)
    values (NEW.C_ID,NEW.C_PARENTID,NEW.C_POSITION,NEW.C_LEFT,NEW.C_RIGHT,NEW.C_LEVEL,NEW.C_TITLE,NEW.C_TYPE,'update','변경이후데이터',now());
END $$
DELIMITER ;

DELIMITER $$
CREATE TRIGGER TG_DELETE_T_ARMS_BLOG
    BEFORE  DELETE ON T_ARMS_BLOG
    FOR EACH ROW
BEGIN
    insert into T_ARMS_BLOG_LOG (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_METHOD, C_STATE, C_DATE)
    values (OLD.C_ID,OLD.C_PARENTID,OLD.C_POSITION,OLD.C_LEFT,OLD.C_RIGHT,OLD.C_LEVEL,OLD.C_TITLE,OLD.C_TYPE,'delete','삭제된데이터',now());
END $$
DELIMITER ;

Insert into `aRMS`.`T_ARMS_BLOG` (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE)
Values (1, 0, 0, 1, 4, 0, 'T_ARMS_BLOG', 'root');
Insert into `aRMS`.`T_ARMS_BLOG` (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE)
Values (2, 1, 0, 2, 3, 1, '블로그', 'drive');

--
-- Table structure for table `T_ARMS_NEWSLETTER`
--
CREATE TABLE IF NOT EXISTS `aRMS`.`T_ARMS_NEWSLETTER_LOG` (

    `c_id`                                  bigint(20) NOT NULL COMMENT '노드 아이디',
    `c_parentid`                            bigint(20) NOT NULL COMMENT '부모 노드 아이디',
    `c_position`                            bigint(20) NOT NULL COMMENT '노드 포지션',
    `c_left`                                bigint(20) NOT NULL COMMENT '노드 좌측 끝 포인트',
    `c_right`                               bigint(20) NOT NULL COMMENT '노드 우측 끝 포인트',
    `c_level`                               bigint(20) NOT NULL COMMENT '노드 DEPTH',
    `c_title`                               VARCHAR(255) COMMENT '노드 명',
    `c_type`                                VARCHAR(255) COMMENT '노드 타입',

    `c_method`                              text NULL COMMENT '노드 변경 행위',
    `c_state`                               text NULL COMMENT '노드 상태값 ( 이전인지. 이후인지)',
    `c_date`                                DATETIME NULL COMMENT '노드 변경 시',

    `c_newsletter_category`                 VARCHAR(255) COMMENT '카테고리',
    `c_newsletter_title`                    VARCHAR(255) COMMENT '제목',
    `c_newsletter_subtitle`                 VARCHAR(255) COMMENT '부제목',
    `c_newsletter_author_id`                VARCHAR(255) COMMENT '작성자 아이디',
    `c_newsletter_author_name`              VARCHAR(255) COMMENT '작성자 명',
    `c_newsletter_created`                  DATETIME NULL COMMENT '작성일',
    `c_newsletter_updated`                  DATETIME NULL COMMENT '수정일',
    `c_newsletter_visibility`               VARCHAR(255) COMMENT '공개범위',

    `c_newsletter_slug`                     VARCHAR(255) COMMENT '슬러그 (URL)',
    `c_newsletter_thumbnail_url`            VARCHAR(500) COMMENT '썸네일 URL',

    `c_newsletter_etc`                 		VARCHAR(255)    COMMENT '비고',
    `c_newsletter_desc`                		text            COMMENT '설명',
    `c_newsletter_contents`            		longtext        COMMENT '내용'

    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='newsletter 테이블 로그';


CREATE TABLE IF NOT EXISTS `aRMS`.`T_ARMS_NEWSLETTER` (

    `c_id`                                   bigint(20) AUTO_INCREMENT primary key COMMENT '노드 아이디',
    `c_parentid`                             bigint(20) NOT NULL COMMENT '부모 노드 아이디',
    `c_position`                             bigint(20) NOT NULL COMMENT '노드 포지션',
    `c_left`                                 bigint(20) NOT NULL COMMENT '노드 좌측 끝 포인트',
    `c_right`                                bigint(20) NOT NULL COMMENT '노드 우측 끝 포인트',
    `c_level`                                bigint(20) NOT NULL COMMENT '노드 DEPTH',
    `c_title`                                VARCHAR(255) COMMENT '노드 명',
    `c_type`                                 VARCHAR(255) COMMENT '노드 타입',

    `c_newsletter_category`                  VARCHAR(255) COMMENT '카테고리',
    `c_newsletter_title`                     VARCHAR(255) COMMENT '제목',
    `c_newsletter_subtitle`                  VARCHAR(255) COMMENT '부제목',
    `c_newsletter_author_id`                 VARCHAR(255) COMMENT '작성자 아이디',
    `c_newsletter_author_name`               VARCHAR(255) COMMENT '작성자 명',
    `c_newsletter_created`                   DATETIME NULL COMMENT '작성일',
    `c_newsletter_updated`                   DATETIME NULL COMMENT '수정일',
    `c_newsletter_visibility`                VARCHAR(255) COMMENT '공개범위',

    `c_newsletter_slug`                      VARCHAR(255) COMMENT '슬러그 (URL)',
    `c_newsletter_thumbnail_url`             VARCHAR(500) COMMENT '썸네일 URL',

    `c_newsletter_etc`                 		 VARCHAR(255)    COMMENT '비고',
    `c_newsletter_desc`                		 text            COMMENT '설명',
    `c_newsletter_contents`            		 longtext        COMMENT '내용'

    ) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='newsletter 테이블';

DELIMITER $$
CREATE TRIGGER TG_INSERT_T_ARMS_NEWSLETTER
    BEFORE  INSERT ON T_ARMS_NEWSLETTER
    FOR EACH ROW
BEGIN
    insert into T_ARMS_NEWSLETTER_LOG (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_METHOD, C_STATE, C_DATE)
    values (NEW.C_ID,NEW.C_PARENTID,NEW.C_POSITION,NEW.C_LEFT,NEW.C_RIGHT,NEW.C_LEVEL,NEW.C_TITLE,NEW.C_TYPE,'update','변경이전데이터',now());
END $$
DELIMITER ;

DELIMITER $$
CREATE TRIGGER TG_UPDATE_T_ARMS_NEWSLETTER
    BEFORE  UPDATE ON T_ARMS_NEWSLETTER
    FOR EACH ROW
BEGIN
    insert into T_ARMS_NEWSLETTER_LOG (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_METHOD, C_STATE, C_DATE)
    values (OLD.C_ID,OLD.C_PARENTID,OLD.C_POSITION,OLD.C_LEFT,OLD.C_RIGHT,OLD.C_LEVEL,OLD.C_TITLE,OLD.C_TYPE,'update','변경이전데이터',now());

    insert into T_ARMS_NEWSLETTER_LOG (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_METHOD, C_STATE, C_DATE)
    values (NEW.C_ID,NEW.C_PARENTID,NEW.C_POSITION,NEW.C_LEFT,NEW.C_RIGHT,NEW.C_LEVEL,NEW.C_TITLE,NEW.C_TYPE,'update','변경이후데이터',now());
END $$
DELIMITER ;

DELIMITER $$
CREATE TRIGGER TG_DELETE_T_ARMS_NEWSLETTER
    BEFORE  DELETE ON T_ARMS_NEWSLETTER
    FOR EACH ROW
BEGIN
    insert into T_ARMS_NEWSLETTER_LOG (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_METHOD, C_STATE, C_DATE)
    values (OLD.C_ID,OLD.C_PARENTID,OLD.C_POSITION,OLD.C_LEFT,OLD.C_RIGHT,OLD.C_LEVEL,OLD.C_TITLE,OLD.C_TYPE,'delete','삭제된데이터',now());
END $$
DELIMITER ;

Insert into `aRMS`.`T_ARMS_NEWSLETTER` (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE)
Values (1, 0, 0, 1, 4, 0, 'T_ARMS_NEWSLETTER', 'root');
Insert into `aRMS`.`T_ARMS_NEWSLETTER` (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE)
Values (2, 1, 0, 2, 3, 1, '뉴스레터', 'drive');


--
-- Table structure for table `T_ARMS_CLIENTCASE`
--
CREATE TABLE IF NOT EXISTS `aRMS`.`T_ARMS_CLIENTCASE_LOG` (

    `c_id`                                  bigint(20) NOT NULL COMMENT '노드 아이디',
    `c_parentid`                            bigint(20) NOT NULL COMMENT '부모 노드 아이디',
    `c_position`                            bigint(20) NOT NULL COMMENT '노드 포지션',
    `c_left`                                bigint(20) NOT NULL COMMENT '노드 좌측 끝 포인트',
    `c_right`                               bigint(20) NOT NULL COMMENT '노드 우측 끝 포인트',
    `c_level`                               bigint(20) NOT NULL COMMENT '노드 DEPTH',
    `c_title`                               VARCHAR(255) COMMENT '노드 명',
    `c_type`                                VARCHAR(255) COMMENT '노드 타입',

    `c_method`                              text NULL COMMENT '노드 변경 행위',
    `c_state`                               text NULL COMMENT '노드 상태값 ( 이전인지. 이후인지)',
    `c_date`                                DATETIME NULL COMMENT '노드 변경 시',

    `c_clientcase_category`                 VARCHAR(255) COMMENT '카테고리',
    `c_clientcase_title`                    VARCHAR(255) COMMENT '제목',
    `c_clientcase_subtitle`                 VARCHAR(255) COMMENT '부제목',
    `c_clientcase_author_id`                VARCHAR(255) COMMENT '작성자 아이디',
    `c_clientcase_author_name`              VARCHAR(255) COMMENT '작성자 명',
    `c_clientcase_created`                  DATETIME NULL COMMENT '작성일',
    `c_clientcase_updated`                  DATETIME NULL COMMENT '수정일',
    `c_clientcase_visibility`               VARCHAR(255) COMMENT '공개범위',

    `c_clientcase_slug`                     VARCHAR(255) COMMENT '슬러그 (URL)',
    `c_clientcase_thumbnail_url`            VARCHAR(500) COMMENT '썸네일 URL',

    `c_clientcase_etc`                 		VARCHAR(255)    COMMENT '비고',
    `c_clientcase_desc`                		text            COMMENT '설명',
    `c_clientcase_contents`            		longtext        COMMENT '내용'

    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='고객사례 테이블 로그';


CREATE TABLE IF NOT EXISTS `aRMS`.`T_ARMS_CLIENTCASE` (

    `c_id`                                   bigint(20) AUTO_INCREMENT primary key COMMENT '노드 아이디',
    `c_parentid`                             bigint(20) NOT NULL COMMENT '부모 노드 아이디',
    `c_position`                             bigint(20) NOT NULL COMMENT '노드 포지션',
    `c_left`                                 bigint(20) NOT NULL COMMENT '노드 좌측 끝 포인트',
    `c_right`                                bigint(20) NOT NULL COMMENT '노드 우측 끝 포인트',
    `c_level`                                bigint(20) NOT NULL COMMENT '노드 DEPTH',
    `c_title`                                VARCHAR(255) COMMENT '노드 명',
    `c_type`                                 VARCHAR(255) COMMENT '노드 타입',

    `c_clientcase_category`                  VARCHAR(255) COMMENT '카테고리',
    `c_clientcase_title`                     VARCHAR(255) COMMENT '제목',
    `c_clientcase_subtitle`                  VARCHAR(255) COMMENT '부제목',
    `c_clientcase_author_id`                 VARCHAR(255) COMMENT '작성자 아이디',
    `c_clientcase_author_name`               VARCHAR(255) COMMENT '작성자 명',
    `c_clientcase_created`                   DATETIME NULL COMMENT '작성일',
    `c_clientcase_updated`                   DATETIME NULL COMMENT '수정일',
    `c_clientcase_visibility`                VARCHAR(255) COMMENT '공개범위',

    `c_clientcase_slug`                      VARCHAR(255) COMMENT '슬러그 (URL)',
    `c_clientcase_thumbnail_url`             VARCHAR(500) COMMENT '썸네일 URL',

    `c_clientcase_etc`                 		 VARCHAR(255)    COMMENT '비고',
    `c_clientcase_desc`                		 text            COMMENT '설명',
    `c_clientcase_contents`            		 longtext        COMMENT '내용'

    ) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='고객사례 테이블';

DELIMITER $$
CREATE TRIGGER TG_INSERT_T_ARMS_CLIENTCASE
    BEFORE  INSERT ON T_ARMS_CLIENTCASE
    FOR EACH ROW
BEGIN
    insert into T_ARMS_CLIENTCASE_LOG (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_METHOD, C_STATE, C_DATE)
    values (NEW.C_ID,NEW.C_PARENTID,NEW.C_POSITION,NEW.C_LEFT,NEW.C_RIGHT,NEW.C_LEVEL,NEW.C_TITLE,NEW.C_TYPE,'update','변경이전데이터',now());
END $$
DELIMITER ;

DELIMITER $$
CREATE TRIGGER TG_UPDATE_T_ARMS_CLIENTCASE
    BEFORE  UPDATE ON T_ARMS_CLIENTCASE
    FOR EACH ROW
BEGIN
    insert into T_ARMS_CLIENTCASE_LOG (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_METHOD, C_STATE, C_DATE)
    values (OLD.C_ID,OLD.C_PARENTID,OLD.C_POSITION,OLD.C_LEFT,OLD.C_RIGHT,OLD.C_LEVEL,OLD.C_TITLE,OLD.C_TYPE,'update','변경이전데이터',now());

    insert into T_ARMS_CLIENTCASE_LOG (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_METHOD, C_STATE, C_DATE)
    values (NEW.C_ID,NEW.C_PARENTID,NEW.C_POSITION,NEW.C_LEFT,NEW.C_RIGHT,NEW.C_LEVEL,NEW.C_TITLE,NEW.C_TYPE,'update','변경이후데이터',now());
END $$
DELIMITER ;

DELIMITER $$
CREATE TRIGGER TG_DELETE_T_ARMS_CLIENTCASE
    BEFORE  DELETE ON T_ARMS_CLIENTCASE
    FOR EACH ROW
BEGIN
    insert into T_ARMS_CLIENTCASE_LOG (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_METHOD, C_STATE, C_DATE)
    values (OLD.C_ID,OLD.C_PARENTID,OLD.C_POSITION,OLD.C_LEFT,OLD.C_RIGHT,OLD.C_LEVEL,OLD.C_TITLE,OLD.C_TYPE,'delete','삭제된데이터',now());
END $$
DELIMITER ;

Insert into `aRMS`.`T_ARMS_CLIENTCASE` (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE)
Values (1, 0, 0, 1, 4, 0, 'T_ARMS_CLIENTCASE', 'root');
Insert into `aRMS`.`T_ARMS_CLIENTCASE` (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE)
Values (2, 1, 0, 2, 3, 1, '고객사례', 'drive');